/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.util;

import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class QueryUtils {
    public static BooleanQuery.Builder conditionalAdd(BooleanQuery.Builder qb, Query term, BooleanClause.Occur occur) {
        try {
            if (term != null) {
                boolean add = true;
                if (term instanceof BooleanQuery) {
                    boolean bl = add = ((BooleanQuery)term).clauses().size() > 0;
                }
                if (add) {
                    qb.add(term, occur);
                }
            }
        }
        catch (BooleanQuery.TooManyClauses tooManyClauses) {
            // empty catch block
        }
        return qb;
    }

    public static boolean isJapaneseSymbol(char ch) {
        if (ch <= '\u00ff') {
            return false;
        }
        if (ch >= '\u2460' && ch <= '\u2473') {
            return true;
        }
        if (ch >= '\u2160' && ch <= '\u2169') {
            return true;
        }
        if (ch >= '\u2170' && ch <= '\u2179') {
            return true;
        }
        return ch == '\u2116' || ch == '\u33cd' || ch == '\u2121' || ch == '\u3231' || ch == '\u3232' || ch == '\u3239';
    }

    public static boolean isThai(char ch) {
        if (ch <= '\u00ff') {
            return false;
        }
        return ch >= '\u0e01' && ch <= '\u0e7f';
    }

    public static boolean isCJK(char ch) {
        if (ch <= '\u00ff') {
            return false;
        }
        if (ch >= '\u3040' && ch <= '\u318f') {
            return true;
        }
        if (ch >= '\u31a0' && ch <= '\u31bf') {
            return true;
        }
        if (ch >= '\u31f0' && ch <= '\u31ff') {
            return true;
        }
        if (ch >= '\u3300' && ch <= '\u337f') {
            return true;
        }
        if (ch >= '\u3300' && ch <= '\u33ff') {
            return true;
        }
        if (ch >= '\u3400' && ch <= '\u4dbf') {
            return true;
        }
        if (ch >= '\u4e00' && ch <= '\u9fff') {
            return true;
        }
        if (ch >= '\uf900' && ch <= '\ufaff') {
            return true;
        }
        if (ch >= '\ufe30' && ch <= '\ufe4f') {
            return true;
        }
        if (ch >= '\uff65' && ch <= '\uff9f') {
            return true;
        }
        if (ch >= '\u2e80' && ch <= '\u2eff') {
            return true;
        }
        if (ch >= '\u2f00' && ch <= '\u2fdf') {
            return true;
        }
        if (ch >= '\u3190' && ch <= '\u319f') {
            return true;
        }
        if (ch >= '\u31c0' && ch <= '\u31ef') {
            return true;
        }
        if (ch >= '\u2ff0' && ch <= '\u2fff') {
            return true;
        }
        if (ch >= '\u3000' && ch <= '\u303f') {
            return true;
        }
        if (ch >= '\u3200' && ch <= '\u32ff') {
            return true;
        }
        if (ch >= '\ua960' && ch <= '\ua97f') {
            return true;
        }
        if (ch >= '\ue000' && ch <= '\uf8ff') {
            return true;
        }
        if (ch >= '\uff00' && ch <= '\uffef') {
            return true;
        }
        if (ch >= '\uac00' && ch <= '\ud7af') {
            return true;
        }
        if (ch >= '\ud7b0' && ch <= '\ud7ff') {
            return true;
        }
        if (ch >= '\u1100' && ch <= '\u11ff') {
            return true;
        }
        return QueryUtils.isJapaneseSymbol(ch);
    }

    public static boolean isChinese(String string) {
        boolean foundCJK = false;
        int i = 0;
        int length = string.length();
        while (i < length) {
            char c = string.charAt(i);
            if (QueryUtils.isCJK(c)) {
                foundCJK = true;
                if (QueryUtils.isJapaneseOnly(c) || QueryUtils.isKoreanOnly(c)) {
                    return false;
                }
            }
            ++i;
        }
        return foundCJK;
    }

    public static boolean isJapaneseOnly(char ch) {
        if (ch >= '\u3040' && ch <= '\u309f') {
            return true;
        }
        if (ch >= '\u30a0' && ch <= '\u30ff') {
            return true;
        }
        if (ch >= '\u31f0' && ch <= '\u31ff') {
            return true;
        }
        return QueryUtils.isJapaneseSymbol(ch);
    }

    public static boolean isKoreanOnly(char ch) {
        if (ch >= '\u3130' && ch <= '\u318f') {
            return true;
        }
        if (ch >= '\ua960' && ch <= '\ua97f') {
            return true;
        }
        if (ch >= '\uac00' && ch <= '\ud7af') {
            return true;
        }
        if (ch >= '\ud7b0' && ch <= '\ud7ff') {
            return true;
        }
        return ch >= '\u1100' && ch <= '\u11ff';
    }

    public static String termText(CharTermAttribute term) {
        return term instanceof ArtifactAttribute ? ((ArtifactAttribute)term).term() : term.toString();
    }

    public static final class Pair<F, S> {
        private final F fPairFirst;
        private final S fPairSecond;

        private Pair(F first, S second) {
            this.fPairFirst = first;
            this.fPairSecond = second;
        }

        public static <F, S> Pair<F, S> create(F pairFirst, S pairSecond) {
            return new Pair<F, S>(pairFirst, pairSecond);
        }

        public final F getFirst() {
            return this.fPairFirst;
        }

        public final S getSecond() {
            return this.fPairSecond;
        }
    }
}

