/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.util;

import com.ibm.team.foundation.common.internal.util.FoundationStatus;
import com.ibm.team.foundation.common.util.FoundationLog;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class AnalyzerDebugUtils {
    private static final String SHOW_INDEX_TOKENS_ID = "/debug/showIndexTokens";
    public static final boolean SHOW_INDEX_TOKENS = Boolean.toString(true).equals(AnalyzerDebugUtils.getDebugOption("com.ibm.team.fulltext.common/debug/showIndexTokens"));
    private static final String SHOW_QUERY_ID = "/debug/showQuery";
    public static final boolean SHOW_QUERY = Boolean.toString(true).equals(AnalyzerDebugUtils.getDebugOption("com.ibm.team.fulltext.common/debug/showQuery"));
    private static final String SHOW_RESULT_EXPLANATION_ID = "/debug/showResultExplanation";
    public static final boolean SHOW_RESULT_EXPLANATION = Boolean.toString(true).equals(AnalyzerDebugUtils.getDebugOption("com.ibm.team.fulltext.common/debug/showResultExplanation"));

    public static void printTokens(Analyzer analyzer, Reader text) {
        AnalyzerDebugUtils.printTokens(analyzer, text, "ignore");
    }

    private static Status createStatus(String str) {
        return new FoundationStatus(1, "com.ibm.team.fulltext.common", 0, str, null, false);
    }

    public static void printTokens(Analyzer analyzer, Reader text, String field) {
        if (!SHOW_INDEX_TOKENS) {
            return;
        }
        FoundationLog.log((IStatus)AnalyzerDebugUtils.createStatus(field));
        try {
            TokenStream stream = analyzer.tokenStream(field, text);
            PositionIncrementAttribute positionIncrementAttribute = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAttribute = (OffsetAttribute)stream.getAttribute(OffsetAttribute.class);
            TypeAttribute typeAttribute = (TypeAttribute)stream.getAttribute(TypeAttribute.class);
            CharTermAttribute termAttribute = (CharTermAttribute)stream.getAttribute(CharTermAttribute.class);
            int position = 0;
            stream.reset();
            try {
                while (stream.incrementToken()) {
                    String term = new String(termAttribute.buffer(), 0, termAttribute.length());
                    FoundationLog.log((IStatus)AnalyzerDebugUtils.createStatus(String.valueOf(position += positionIncrementAttribute.getPositionIncrement()) + ": [" + term + ":" + offsetAttribute.startOffset() + " -> " + offsetAttribute.endOffset() + ": " + typeAttribute.type() + "]"));
                }
                stream.end();
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void printQuery(Query query) {
        if (!SHOW_QUERY) {
            return;
        }
        FoundationLog.log((IStatus)AnalyzerDebugUtils.createStatus(query.toString()));
    }

    public static void print(BooleanQuery query) {
        StringBuilder builder = new StringBuilder();
        AnalyzerDebugUtils.print(query, builder, 0);
        FoundationLog.log((IStatus)AnalyzerDebugUtils.createStatus(builder.toString()));
    }

    private static void print(BooleanQuery query, StringBuilder builder, int indent) {
        List clauses = query.clauses();
        for (BooleanClause clause : clauses) {
            AnalyzerDebugUtils.appendIndent(builder, indent);
            if (clause.isProhibited()) {
                builder.append("[-]");
            } else if (clause.isRequired()) {
                builder.append("[+]");
            }
            Query subQuery = clause.getQuery();
            float boost = 1.0f;
            if (subQuery instanceof BoostQuery) {
                boost = ((BoostQuery)subQuery).getBoost();
                subQuery = ((BoostQuery)subQuery).getQuery();
            }
            if (subQuery instanceof BooleanQuery) {
                boolean needParens;
                builder.append("(\n");
                boolean bl = needParens = (double)boost != 1.0 || query.getMinimumNumberShouldMatch() > 0;
                if (needParens) {
                    AnalyzerDebugUtils.appendIndent(builder, indent);
                    builder.append("(\n");
                    AnalyzerDebugUtils.appendIndent(builder, indent);
                }
                AnalyzerDebugUtils.print((BooleanQuery)subQuery, builder, indent + 1);
                builder.append("\n");
                AnalyzerDebugUtils.appendIndent(builder, indent);
                builder.append(")\n");
                if (!needParens) continue;
                builder.append("\n");
                AnalyzerDebugUtils.appendIndent(builder, indent);
                builder.append(")");
                continue;
            }
            builder.append(subQuery.toString());
        }
    }

    private static void appendIndent(StringBuilder builder, int indent) {
        int i = 0;
        while (i < indent) {
            builder.append("   ");
            ++i;
        }
    }

    private static String getDebugOption(String option) {
        String property = option.replace('/', '.');
        String value = System.getProperty(property);
        if (value != null) {
            return value;
        }
        return Platform.getDebugOption((String)option);
    }
}

