/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.query;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.FulltextException;
import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import com.ibm.team.fulltext.common.IndexConfig;
import com.ibm.team.fulltext.common.internal.TokenGroup;
import com.ibm.team.fulltext.common.internal.analysis.DelegatingAnalyzer;
import com.ibm.team.fulltext.common.internal.analysis.QuoteAnalyzer;
import com.ibm.team.fulltext.common.internal.index.IIndexAccess;
import com.ibm.team.fulltext.common.internal.index.IndexManagerImpl;
import com.ibm.team.fulltext.common.internal.query.DefaultQueryProvider;
import com.ibm.team.fulltext.common.internal.query.FindRelatedQueryBuilder;
import com.ibm.team.fulltext.common.internal.query.IQueryManager;
import com.ibm.team.fulltext.common.internal.query.Messages;
import com.ibm.team.fulltext.common.internal.query.PorterStemmingCache;
import com.ibm.team.fulltext.common.internal.result.ResultFactory;
import com.ibm.team.fulltext.common.internal.result.ScoredResultDTO;
import com.ibm.team.fulltext.common.internal.result.URIReferenceDTO;
import com.ibm.team.fulltext.common.internal.util.AnalyzerDebugUtils;
import com.ibm.team.fulltext.common.internal.util.QueryUtils;
import com.ibm.team.fulltext.common.model.IFilter;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class QueryManagerImpl
implements IQueryManager,
ExtensionRegistryReaderListener<Object> {
    private static final Log logger = LogFactory.getLog((String)"com.ibm.team.fulltext.common");
    private static int MAX_CLAUSE_COUNT;
    private static final int DEFAULT_MAX_CLAUSE_COUNT = 10000;
    public static final long SCORE_TO_LONG_MULTIPLIER = 100000L;
    private static final String QUERY_PROVIDER_EXTENSION_POINT = "queryProvider";
    private static final String QUERY_PROVIDER_CLASS_ATTRIBUTE = "class";
    private static final String TOKEN_TYPE = "tokenType";
    private static final String TOKEN_TYPE_ID = "id";
    private static QueryManagerImpl fgSingleton;
    public static final String ASTERISK = "*";
    public static final String QMARK = "?";
    static float MIN_SCORE_FACTOR_DUPLICATE;
    private static final float DEFAULT_SCORE_FACTOR = 1.0f;
    private final IQueryProvider fDefaultQueryProvider = new DefaultQueryProvider();
    private final Map<String, IConfigurationElement> fQueryProviders = new ConcurrentHashMap<String, IConfigurationElement>();
    private final Map<String, IQueryProvider> fResolvedQueryProvidersCache = new ConcurrentHashMap<String, IQueryProvider>();
    private final DelegatingAnalyzer fDelegatingAnalyzer = new DelegatingAnalyzer(true);

    static {
        fgSingleton = new QueryManagerImpl();
        MIN_SCORE_FACTOR_DUPLICATE = 0.3f;
    }

    public static IQueryManager getInstance() {
        return fgSingleton;
    }

    private QueryManagerImpl() {
        ExtensionRegistryReader<Object> extensionReader = new ExtensionRegistryReader<Object>("com.ibm.team.fulltext.common", QUERY_PROVIDER_EXTENSION_POINT){};
        extensionReader.addListener((ExtensionRegistryReaderListener)this);
        extensionReader.start();
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        MAX_CLAUSE_COUNT = indexManager.getMaxClauseInQuery();
        BooleanQuery.setMaxClauseCount((int)MAX_CLAUSE_COUNT);
        if (MAX_CLAUSE_COUNT > 10000) {
            logger.warn((Object)("The default value for Maximum number of clauses used in full-text search is 10,000 and you have set " + indexManager.getMaxClauseInQuery() + " that can impact the performance of full text search"));
        }
        this.fDelegatingAnalyzer.setUseLanguageStemmer(indexManager.getUseLanguageStemmer());
    }

    public void handleExtensionAdded(IConfigurationElement element, Object descriptor) throws Exception {
        IConfigurationElement[] tokenTypes;
        IConfigurationElement[] iConfigurationElementArray = tokenTypes = element.getChildren(TOKEN_TYPE);
        int n = tokenTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement tokenType = iConfigurationElementArray[n2];
            String tokenTypeId = tokenType.getAttribute(TOKEN_TYPE_ID);
            this.fQueryProviders.put(tokenTypeId, element);
            ++n2;
        }
    }

    public void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
        IConfigurationElement[] tokenTypes;
        IConfigurationElement[] iConfigurationElementArray = tokenTypes = element.getChildren(TOKEN_TYPE);
        int n = tokenTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement tokenType = iConfigurationElementArray[n2];
            String tokenTypeId = tokenType.getAttribute(TOKEN_TYPE_ID);
            this.fQueryProviders.remove(tokenTypeId);
            this.fResolvedQueryProvidersCache.remove(tokenTypeId);
            ++n2;
        }
    }

    public void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    public void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptor) throws Exception {
    }

    @Override
    public List<IScoredResult> find(Collection<UUID> context, UUID[] owners, String[] frontSideUris, String text, String language, String[] searchScope, String constrainType, int resultLimit, int searchDuration, boolean sortByDate, IFilter userFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        List<IScoredResult> result = Collections.emptyList();
        try {
            try {
                this.fDelegatingAnalyzer.setOverridenLanguage(language);
                PorterStemmingCache.initialize();
                result = this.doFind(context, owners, frontSideUris, text, searchScope, constrainType, indexAccess, this.fDelegatingAnalyzer, resultLimit, searchDuration, sortByDate, userFilter);
            }
            catch (BooleanQuery.TooManyClauses tooManyClauses) {
                PorterStemmingCache.close();
                this.fDelegatingAnalyzer.setOverridenLanguage(null);
            }
        }
        finally {
            PorterStemmingCache.close();
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
        return result;
    }

    @Override
    public List<IScoredResult> findByContainerReferences(Set<UUID> contexts, UUID[] owners, URIReference[] containerReferences, String[] searchScope, String constrainType, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        int index = 0;
        int length = containerReferences.length;
        List<IScoredResult> result = null;
        int maxClauseCount = BooleanQuery.getMaxClauseCount();
        while (index < length) {
            BooleanQuery.Builder qb = new BooleanQuery.Builder();
            int max = Math.min(index + maxClauseCount, length);
            int i = index;
            while (i < max) {
                URIReference container = containerReferences[i];
                qb = qb.add((Query)new TermQuery(new Term("_containerId", container.getURI().toString())), BooleanClause.Occur.SHOULD);
                ++i;
            }
            try {
                if (result == null) {
                    result = this.execute(contexts, owners, null, (Query)qb.build(), null, searchScope, indexAccess, constrainType, 1.0f, 1.0f, resultLimit, searchDuration, false, userFilter);
                } else {
                    result.addAll(this.execute(contexts, owners, null, (Query)qb.build(), null, searchScope, indexAccess, constrainType, 1.0f, 1.0f, resultLimit, searchDuration, false, userFilter));
                }
            }
            catch (IOException e) {
                throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, "", searchScope, constrainType), (Object[])new Object[0]), e);
            }
            catch (TeamRepositoryException e) {
                throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, "", searchScope, constrainType), (Object[])new Object[0]), e);
            }
            index += max;
        }
        return result;
    }

    private List<IScoredResult> doFind(Collection<UUID> context, UUID[] owners, String[] frontSideUris, String text, String[] searchScope, String constrainType, IIndexAccess indexAccess, Analyzer analyzer, int resultLimit, int searchDuration, boolean sortByDate, IFilter userFilter) throws FulltextException {
        try {
            BooleanQuery.Builder qb = new BooleanQuery.Builder();
            text = text.trim();
            if (text.length() > 1 && text.matches("[* ? ]*$") || text.equals(QMARK)) {
                return Collections.emptyList();
            }
            if (text.startsWith("\"") && text.endsWith("\"") && text.length() > 1) {
                QuoteAnalyzer quoteAnalyzer = new QuoteAnalyzer();
                DisjunctionMaxQuery spanQuery = this.createSpanQuery(text, quoteAnalyzer, 0);
                qb = qb.add((Query)spanQuery, BooleanClause.Occur.MUST);
            } else {
                ITokenGroup tokenGroup = TokenGroup.createTokenGroup(analyzer, "com.ibm.team.fulltext.service.internal.analysis.DelegatingAnalyzer.ContentWildcardAware", new StringReader(text));
                Set<String> tokenTypes = tokenGroup.getTokenTypes();
                for (String tokenType : tokenTypes) {
                    Query tokenQuery;
                    IQueryProvider queryProvider = this.fDefaultQueryProvider;
                    if (this.fQueryProviders.containsKey(tokenType)) {
                        if (this.fResolvedQueryProvidersCache.containsKey(tokenType)) {
                            queryProvider = this.fResolvedQueryProvidersCache.get(tokenType);
                        } else {
                            queryProvider = (IQueryProvider)this.fQueryProviders.get(tokenType).createExecutableExtension(QUERY_PROVIDER_CLASS_ATTRIBUTE);
                            this.fResolvedQueryProvidersCache.put(tokenType, queryProvider);
                        }
                    }
                    if ((tokenQuery = queryProvider.createQuery(tokenType, analyzer, tokenGroup)) == null) continue;
                    qb = QueryUtils.conditionalAdd(qb, tokenQuery, BooleanClause.Occur.MUST);
                }
                DisjunctionMaxQuery spanQuery = this.createSpanQuery(text, analyzer, 2);
                if (!spanQuery.getDisjuncts().isEmpty()) {
                    qb = QueryUtils.conditionalAdd(qb, (Query)spanQuery, BooleanClause.Occur.SHOULD);
                }
            }
            if (!text.equals(ASTERISK) && qb.build().clauses().isEmpty()) {
                return Collections.emptyList();
            }
            if (searchScope != null && (!IndexConfig.useMultipleIndexes() || qb.build().clauses().isEmpty())) {
                BooleanQuery.Builder scopesQb = new BooleanQuery.Builder();
                String[] stringArray = searchScope;
                int n = searchScope.length;
                int spanQuery = 0;
                while (spanQuery < n) {
                    String scope = stringArray[spanQuery];
                    if (scope != null) {
                        TermQuery artifactTypeQuery = new TermQuery(new Term("_artifactType", scope));
                        scopesQb = QueryUtils.conditionalAdd(scopesQb, (Query)artifactTypeQuery, BooleanClause.Occur.SHOULD);
                    }
                    ++spanQuery;
                }
                if (!scopesQb.build().clauses().isEmpty()) {
                    BoostQuery scopesQuery = new BoostQuery((Query)scopesQb.build(), 0.0f);
                    qb = QueryUtils.conditionalAdd(qb, (Query)scopesQuery, BooleanClause.Occur.MUST);
                }
            }
            if (constrainType != null) {
                BooleanQuery.Builder constrainTypeQb = new BooleanQuery.Builder();
                TermQuery artifactTypeQuery = new TermQuery(new Term("_artifactType", constrainType));
                constrainTypeQb = QueryUtils.conditionalAdd(constrainTypeQb, (Query)artifactTypeQuery, BooleanClause.Occur.SHOULD);
                TermQuery containerTypeQuery = new TermQuery(new Term("_containerType", constrainType));
                constrainTypeQb = QueryUtils.conditionalAdd(constrainTypeQb, (Query)containerTypeQuery, BooleanClause.Occur.SHOULD);
                BoostQuery constrainTypeQuery = new BoostQuery((Query)constrainTypeQb.build(), 0.0f);
                qb = QueryUtils.conditionalAdd(qb, (Query)constrainTypeQuery, BooleanClause.Occur.MUST);
            }
            return this.execute(context, owners, frontSideUris, (Query)qb.build(), null, searchScope, indexAccess, constrainType, 0.0f, 1.0f, resultLimit, searchDuration, sortByDate, userFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, text, searchScope, constrainType), (Object[])new Object[0]), e);
        }
        catch (CoreException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, text, searchScope, constrainType), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, text, searchScope, constrainType), (Object[])new Object[0]), e);
        }
    }

    private DisjunctionMaxQuery createSpanQuery(String text, Analyzer analyzer, int slop) throws IOException {
        String[] fields;
        ArrayList<Object> disjuncts = new ArrayList<Object>();
        String[] stringArray = fields = new String[]{"_name", "_content", "_meta", "_tags"};
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            ArrayList<SpanTermQuery> spans = new ArrayList<SpanTermQuery>();
            TokenStream tokenStream = analyzer.tokenStream(field, (Reader)new StringReader(text));
            CharTermAttribute termAtt = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            tokenStream.reset();
            try {
                while (tokenStream.incrementToken()) {
                    if (PorterStemmingCache.containsValue(QueryUtils.termText(termAtt))) continue;
                    spans.add(new SpanTermQuery(new Term(field, QueryUtils.termText(termAtt))));
                }
                if (spans.size() > 1) {
                    SpanNearQuery spanNearQuery = new SpanNearQuery(spans.toArray(new SpanQuery[spans.size()]), slop, true);
                    if (field == "_name") {
                        disjuncts.add(new BoostQuery((Query)spanNearQuery, 2.0f));
                    } else {
                        disjuncts.add(spanNearQuery);
                    }
                } else if (spans.size() == 1) {
                    disjuncts.add((Query)spans.get(0));
                }
                tokenStream.end();
            }
            finally {
                tokenStream.close();
                PorterStemmingCache.clear();
            }
            ++n2;
        }
        DisjunctionMaxQuery spanQuery = new DisjunctionMaxQuery(disjuncts, 0.0f);
        return spanQuery;
    }

    private Query getQueryFilter(BooleanQuery filter, Collection<UUID> contexts, UUID[] owners, String[] frontSideUris) {
        BoostQuery oldOwnersQuery;
        BooleanQuery.Builder contextsQb = null;
        if (contexts != null && !contexts.isEmpty()) {
            contextsQb = new BooleanQuery.Builder();
            for (UUID context : contexts) {
                TermQuery contextQuery = new TermQuery(new Term("_context", context.getUuidValue()));
                contextsQb = QueryUtils.conditionalAdd(contextsQb, (Query)contextQuery, BooleanClause.Occur.SHOULD);
            }
        }
        BooleanQuery.Builder ownersQb = null;
        if (owners != null && owners.length > 0) {
            ownersQb = new BooleanQuery.Builder();
            UUID[] uUIDArray = owners;
            int n = owners.length;
            int contextQuery = 0;
            while (contextQuery < n) {
                UUID owner = uUIDArray[contextQuery];
                TermQuery ownerQuery = new TermQuery(new Term("_owner", owner.getUuidValue()));
                ownersQb = QueryUtils.conditionalAdd(ownersQb, (Query)ownerQuery, BooleanClause.Occur.SHOULD);
                ++contextQuery;
            }
            BooleanQuery.Builder oldOwnersQb = new BooleanQuery.Builder();
            BooleanQuery.Builder oldContextsQb = new BooleanQuery.Builder();
            UUID[] uUIDArray2 = owners;
            int ownerQuery = owners.length;
            int n2 = 0;
            while (n2 < ownerQuery) {
                UUID owner = uUIDArray2[n2];
                TermQuery oldContextQuery = new TermQuery(new Term("_context", owner.getUuidValue()));
                oldContextsQb = QueryUtils.conditionalAdd(oldContextsQb, (Query)oldContextQuery, BooleanClause.Occur.SHOULD);
                ++n2;
            }
            BoostQuery oldContextsQuery = new BoostQuery((Query)oldContextsQb.build(), 0.0f);
            oldOwnersQb = QueryUtils.conditionalAdd(oldOwnersQb, (Query)oldContextsQuery, BooleanClause.Occur.MUST);
            BoostQuery allOwnersRangeQuery = new BoostQuery((Query)new TermRangeQuery("_owner", null, null, true, true), 0.0f);
            oldOwnersQb = QueryUtils.conditionalAdd(oldOwnersQb, (Query)allOwnersRangeQuery, BooleanClause.Occur.MUST_NOT);
            oldOwnersQuery = new BoostQuery((Query)oldOwnersQb.build(), 0.0f);
            ownersQb = QueryUtils.conditionalAdd(ownersQb, (Query)oldOwnersQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery.Builder fronSideUrisQb = null;
        if (frontSideUris != null && ((String[])frontSideUris).length > 0) {
            fronSideUrisQb = new BooleanQuery.Builder();
            oldOwnersQuery = frontSideUris;
            int allOwnersRangeQuery = ((String[])oldOwnersQuery).length;
            int oldContextsQuery = 0;
            while (oldContextsQuery < allOwnersRangeQuery) {
                String frontSideUri = oldOwnersQuery[oldContextsQuery];
                TermQuery fronSideUrisQuery = new TermQuery(new Term("_frontsideuri", frontSideUri));
                fronSideUrisQb = QueryUtils.conditionalAdd(fronSideUrisQb, (Query)fronSideUrisQuery, BooleanClause.Occur.SHOULD);
                ++oldContextsQuery;
            }
        }
        if (contextsQb == null && ownersQb == null && fronSideUrisQb == null) {
            return filter;
        }
        BoostQuery contextsQuery = null;
        if (contextsQb != null) {
            contextsQuery = new BoostQuery((Query)contextsQb.build(), 0.0f);
        }
        BoostQuery ownersQuery = null;
        if (ownersQb != null) {
            ownersQuery = new BoostQuery((Query)ownersQb.build(), 0.0f);
        }
        BoostQuery fronSideUrisQuery = null;
        if (fronSideUrisQb != null) {
            fronSideUrisQuery = new BoostQuery((Query)fronSideUrisQb.build(), 0.0f);
        }
        if (filter != null) {
            BooleanQuery.Builder filterQb = new BooleanQuery.Builder();
            for (BooleanClause clause : filter.clauses()) {
                filterQb = QueryUtils.conditionalAdd(filterQb, clause.getQuery(), clause.getOccur());
            }
            if (contextsQuery != null) {
                filterQb = QueryUtils.conditionalAdd(filterQb, (Query)contextsQuery, BooleanClause.Occur.MUST);
            }
            if (ownersQuery != null) {
                filterQb = QueryUtils.conditionalAdd(filterQb, (Query)ownersQuery, BooleanClause.Occur.MUST);
            }
            if (fronSideUrisQuery != null) {
                filterQb = QueryUtils.conditionalAdd(filterQb, (Query)fronSideUrisQuery, BooleanClause.Occur.MUST);
            }
            return new BoostQuery((Query)filterQb.build(), 0.0f);
        }
        if (contextsQuery != null && ownersQuery == null && fronSideUrisQuery == null) {
            return contextsQuery;
        }
        if (ownersQuery != null && contextsQuery == null && fronSideUrisQuery == null) {
            return ownersQuery;
        }
        if (fronSideUrisQuery != null && ownersQuery == null && contextsQuery == null) {
            return fronSideUrisQuery;
        }
        BooleanQuery.Builder contextOwnerAndFrontsideuriQb = new BooleanQuery.Builder();
        contextOwnerAndFrontsideuriQb = QueryUtils.conditionalAdd(contextOwnerAndFrontsideuriQb, (Query)contextsQuery, BooleanClause.Occur.MUST);
        contextOwnerAndFrontsideuriQb = QueryUtils.conditionalAdd(contextOwnerAndFrontsideuriQb, (Query)ownersQuery, BooleanClause.Occur.MUST);
        contextOwnerAndFrontsideuriQb = QueryUtils.conditionalAdd(contextOwnerAndFrontsideuriQb, (Query)fronSideUrisQuery, BooleanClause.Occur.MUST);
        return new BoostQuery((Query)contextOwnerAndFrontsideuriQb.build(), 0.0f);
    }

    @Override
    public List<IScoredResult> findDuplicateByReference(Collection<UUID> context, UUID[] owners, String id, String name, String content, String language, String type, String[] searchScope, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        if (name == null && content == null) {
            return this.doFindDuplicate(context, owners, id, type, searchScope, indexAccess, resultLimit, searchDuration, userFilter);
        }
        try {
            this.fDelegatingAnalyzer.setOverridenLanguage(language);
            List<IScoredResult> list = this.doFindDuplicate(context, owners, id, name, content, type, searchScope, indexAccess, this.fDelegatingAnalyzer, resultLimit, searchDuration, userFilter);
            return list;
        }
        finally {
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
    }

    @Override
    public List<IScoredResult> findDuplicate(Collection<UUID> context, UUID[] owners, String name, String content, String language, String type, String[] searchScope, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        try {
            this.fDelegatingAnalyzer.setOverridenLanguage(language);
            List<IScoredResult> list = this.doFindDuplicate(context, owners, name, content, type, searchScope, indexAccess, this.fDelegatingAnalyzer, resultLimit, searchDuration, userFilter);
            return list;
        }
        finally {
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
    }

    private List<IScoredResult> doFindDuplicate(Collection<UUID> context, UUID[] owners, String id, String type, String[] searchScope, IIndexAccess indexAccess, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        try {
            String constrainType = type;
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(id, IndexConfig.useMultipleIndexes() ? type : "com.ibm.team.fulltext.service.internal.index.SingleIndexType", constrainType, searchScope, indexAccess);
            return this.execute(context, owners, null, (Query)queries.getFirst(), queries.getSecond(), searchScope, indexAccess, constrainType, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), resultLimit, searchDuration, false, userFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, searchScope, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, searchScope, null), (Object[])new Object[0]), e);
        }
    }

    private List<IScoredResult> doFindDuplicate(Collection<UUID> context, UUID[] owners, String id, String name, String content, String type, String[] searchScope, IIndexAccess indexAccess, Analyzer analyzer, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(id, name, content, type, searchScope, indexAccess, analyzer);
            return this.execute(context, owners, null, (Query)queries.getFirst(), queries.getSecond(), searchScope, indexAccess, type, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), resultLimit, searchDuration, false, userFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
    }

    private List<IScoredResult> doFindDuplicate(Collection<UUID> context, UUID[] owners, String name, String content, String type, String[] searchScope, IIndexAccess indexAccess, Analyzer analyzer, int resultLimit, int searchDuration, IFilter userfFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(name, content, type, searchScope, indexAccess, analyzer);
            return this.execute(context, owners, null, (Query)queries.getFirst(), queries.getSecond(), searchScope, indexAccess, type, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), resultLimit, searchDuration, false, userfFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
    }

    @Override
    public List<IScoredResult> findRelatedByReference(Collection<UUID> context, String id, String type, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        return this.doFindRelated(context, id, type, indexAccess, resultLimit, searchDuration, userFilter);
    }

    @Override
    public List<IScoredResult> findRelated(Collection<UUID> context, String name, String content, String language, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        try {
            this.fDelegatingAnalyzer.setOverridenLanguage(language);
            List<IScoredResult> list = this.doFindRelated(context, name, content, indexAccess, this.fDelegatingAnalyzer, resultLimit, searchDuration, userFilter);
            return list;
        }
        finally {
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
    }

    private List<IScoredResult> doFindRelated(Collection<UUID> context, String id, String type, IIndexAccess indexAccess, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(id, IndexConfig.useMultipleIndexes() ? type : "com.ibm.team.fulltext.service.internal.index.SingleIndexType", null, null, indexAccess);
            return this.execute(context, null, null, (Query)queries.getFirst(), queries.getSecond(), null, indexAccess, null, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), resultLimit, searchDuration, false, userFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, null, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, null, null), (Object[])new Object[0]), e);
        }
    }

    private List<IScoredResult> doFindRelated(Collection<UUID> context, String name, String content, IIndexAccess indexAccess, Analyzer analyzer, int resultLimit, int searchDuration, IFilter userFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(name, content, null, null, indexAccess, analyzer);
            return this.execute(context, null, null, (Query)queries.getFirst(), queries.getSecond(), null, indexAccess, null, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), resultLimit, searchDuration, false, userFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, String.valueOf(name) + "\n\n" + content, null, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, String.valueOf(name) + "\n\n" + content, null, null), (Object[])new Object[0]), e);
        }
    }

    private float getScoreNormalizationFactor(FindRelatedQueryBuilder builder) {
        float knownTermCount;
        float unknownTermCount = builder.getUnknownTermCount();
        float allTermCount = unknownTermCount + (knownTermCount = (float)builder.getKnownTermCount());
        if (allTermCount == 0.0f) {
            return 1.0f;
        }
        float unknownTermRatio = unknownTermCount / allTermCount;
        return Math.max(0.1f, 1.0f - unknownTermRatio);
    }

    private List<IScoredResult> execute(Collection<UUID> context, UUID[] owners, String[] frontSideUris, Query query, BooleanQuery filter, String[] searchScope, IIndexAccess indexAccess, String constrainType, float minScoreFactor, float maxScoreRatio, int resultLimit, int searchDuration, boolean sortByDate, IFilter userFilter) throws IOException, TeamRepositoryException, FulltextException {
        List<IScoredResult> allResults = new ArrayList<IScoredResult>();
        AnalyzerDebugUtils.printQuery(query);
        Query filterQuery = this.getQueryFilter(filter, context, owners, frontSideUris);
        if (filterQuery != null) {
            AnalyzerDebugUtils.printQuery(filterQuery);
        }
        List<QueryUtils.Pair<Document, Float>> documents = indexAccess.search(searchScope, query, filterQuery, minScoreFactor, resultLimit, searchDuration, userFilter);
        HashMap<URIReferenceDTO, ScoredResultDTO> mapRefToResult = new HashMap<URIReferenceDTO, ScoredResultDTO>(documents.size());
        final HashMap<ScoredResultDTO, String> mapResultToDate = new HashMap<ScoredResultDTO, String>(sortByDate ? documents.size() : 10);
        int i = 0;
        while (i < documents.size()) {
            ScoredResultDTO existingResult;
            Document document = documents.get(i).getFirst();
            String id = document.get("_id");
            String type = document.get("_artifactType");
            String name = document.get("_artifactName");
            String details = document.get("_artifactDetails");
            if (details == null) {
                details = document.get("_name");
            }
            URIReferenceDTO resultReference = ResultFactory.eINSTANCE.createURIReferenceDTO();
            resultReference.setName(name);
            resultReference.setDetails(details);
            resultReference.setTypeVal(type);
            resultReference.setUriVal(id);
            long score = Math.round(documents.get(i).getSecond().floatValue() * 100000.0f);
            ArrayList<URIReferenceDTO> containerReferences = null;
            String[] containerIds = document.getValues("_containerId");
            if (containerIds != null) {
                containerReferences = new ArrayList<URIReferenceDTO>(containerIds.length);
                String[] containerContexts = document.getValues("_containerContext");
                String[] containerTypes = document.getValues("_containerType");
                String[] containerDetails = document.getValues("_containerDetails");
                String[] containerNames = document.getValues("_containerName");
                int j = 0;
                while (j < containerIds.length) {
                    String containerId = containerIds[j];
                    String containerContext = containerContexts != null && containerContexts.length > j ? containerContexts[j] : null;
                    String containerType = containerTypes[j];
                    String containerDetail = containerDetails[j];
                    String containerName = containerNames[j];
                    if (containerContext == null || context == null || context.isEmpty() || context.contains(UUID.valueOf((String)containerContext))) {
                        URIReferenceDTO containerReference = ResultFactory.eINSTANCE.createURIReferenceDTO();
                        containerReference.setName(containerName);
                        containerReference.setDetails(containerDetail);
                        containerReference.setTypeVal(containerType);
                        containerReference.setUriVal(containerId);
                        containerReferences.add(containerReference);
                    }
                    ++j;
                }
            }
            if (constrainType != null && !type.equals(constrainType) && containerReferences != null) {
                for (URIReferenceDTO containerReference : containerReferences) {
                    if (!containerReference.getTypeVal().equals(constrainType)) continue;
                    resultReference = containerReference;
                    containerReferences = null;
                    break;
                }
            }
            if ((existingResult = (ScoredResultDTO)mapRefToResult.get(resultReference)) != null) {
                long existingScore = existingResult.getScore();
                long newScore = Math.min(100000L, score + existingScore);
                existingResult.setScore(newScore);
            } else {
                String indexDate;
                ScoredResultDTO result = ResultFactory.eINSTANCE.createScoredResultDTO();
                result.setResultValue(resultReference);
                result.setScore((long)((float)score * maxScoreRatio));
                if (containerReferences != null) {
                    result.getContainerValues().addAll(containerReferences);
                }
                allResults.add(result);
                mapRefToResult.put(result.getResultValue(), result);
                if (sortByDate && (indexDate = document.get("_indexDate")) != null) {
                    mapResultToDate.put(result, indexDate);
                }
            }
            ++i;
        }
        if (resultLimit > 0 && allResults.size() > resultLimit) {
            allResults = allResults.subList(0, resultLimit);
        }
        if (sortByDate) {
            Collections.sort(allResults, new Comparator<IScoredResult>(){

                @Override
                public int compare(IScoredResult o1, IScoredResult o2) {
                    String date1 = (String)mapResultToDate.get(o1);
                    String date2 = (String)mapResultToDate.get(o2);
                    if (date1 != null && date2 == null) {
                        return -1;
                    }
                    if (date1 == null && date2 != null) {
                        return 1;
                    }
                    if (date1 != null && date2 != null && !date1.equals(date2)) {
                        return date1.compareTo(date2) * -1;
                    }
                    return 0;
                }
            });
        }
        return allResults;
    }

    private String getLogDetails(String id, String type, String text, String[] searchScope, String constrainType) {
        String details = "";
        details = String.valueOf(details) + " [Text: " + text + "] ";
        details = String.valueOf(details) + " [Constrain Type: " + constrainType + "] ";
        details = String.valueOf(details) + " [ID: " + id + "] ";
        details = String.valueOf(details) + " [Type: " + type + "] ";
        if (searchScope != null && searchScope.length != 0) {
            StringBuilder scopeVal = new StringBuilder();
            String[] stringArray = searchScope;
            int n = searchScope.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                scopeVal.append(scope);
                scopeVal.append(" ");
                ++n2;
            }
            details = String.valueOf(details) + " [Search Scope: " + scopeVal.toString() + "] ";
        } else {
            details = String.valueOf(details) + " [Search Scope: null] ";
        }
        return details;
    }
}

