/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.query;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;

public class PorterStemmingCache {
    private static ThreadLocal<Multimap<String, String>> cache = new ThreadLocal();

    protected static void initialize() {
        cache.set((Multimap<String, String>)LinkedHashMultimap.create());
    }

    public static Collection<String> get(String porterStemmedText) {
        Multimap<String, String> map = cache.get();
        if (map == null) {
            return null;
        }
        return map.get((Object)porterStemmedText);
    }

    public static boolean containsKey(String text) {
        Multimap<String, String> map = cache.get();
        if (map == null) {
            return false;
        }
        return map.containsKey((Object)text);
    }

    public static boolean containsValue(String text) {
        Multimap<String, String> map = cache.get();
        if (map == null) {
            return false;
        }
        return map.containsValue((Object)text);
    }

    public static void put(String porterStemmedText, String originalText) {
        Multimap<String, String> map = cache.get();
        if (map == null) {
            return;
        }
        if (!map.containsEntry((Object)porterStemmedText, (Object)originalText)) {
            map.put((Object)porterStemmedText, (Object)originalText);
        }
    }

    public static Set<String> keySet() {
        Multimap<String, String> map = cache.get();
        return map.keySet();
    }

    public static void clear() {
        Multimap<String, String> map = cache.get();
        if (map != null) {
            map.clear();
        }
    }

    public static void close() {
        if (cache.get() != null) {
            cache.set(null);
        }
    }
}

