/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.query;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import com.ibm.team.fulltext.common.internal.query.PorterStemmingCache;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class DefaultQueryProvider
implements IQueryProvider {
    private static final char WILDCARD_ASTERISK = '*';
    private static final char WILDCARD_MARK = '?';

    @Override
    public Query createQuery(String tokenType, Analyzer analyzer, ITokenGroup tokenGroup) {
        return this.createStandardQuery(tokenType, tokenGroup);
    }

    private Query createStandardQuery(String tokenType, ITokenGroup tokenGroup) {
        BooleanQuery.Builder qb = new BooleanQuery.Builder();
        ITokenGroup subGroup = tokenGroup.getSubGroup(tokenType);
        HashSet<String> usedTokenValues = new HashSet<String>();
        int numClauses = 0;
        for (ArtifactToken token : subGroup) {
            String termText = token.term();
            if (usedTokenValues.contains(termText)) continue;
            boolean containsWildcards = this.containsWildcards(termText);
            if (containsWildcards) {
                termText = this.normalizeWildcards(termText);
            }
            ArrayList<Query> disjuncts = new ArrayList<Query>();
            if (PorterStemmingCache.containsValue(termText)) continue;
            this.createPartialQuery("_name", termText, containsWildcards, disjuncts, 2);
            this.createPartialQuery("_content", termText, containsWildcards, disjuncts, 0);
            this.createPartialQuery("_meta", termText, containsWildcards, disjuncts, 0);
            if (PorterStemmingCache.containsKey(termText)) {
                Collection<String> originalTextCollection = PorterStemmingCache.get(termText);
                for (String originalText : originalTextCollection) {
                    this.createPartialQuery("_tags", originalText, containsWildcards, disjuncts, 0);
                }
            } else {
                Term tagsTerm = new Term("_tags", termText);
                WildcardQuery query = containsWildcards ? new WildcardQuery(tagsTerm) : new PrefixQuery(tagsTerm);
                disjuncts.add((Query)query);
            }
            DisjunctionMaxQuery disjunctionQuery = new DisjunctionMaxQuery(disjuncts, 0.0f);
            qb = qb.add((Query)disjunctionQuery, BooleanClause.Occur.SHOULD);
            ++numClauses;
            usedTokenValues.add(termText);
        }
        if (numClauses > 2) {
            qb.setMinimumNumberShouldMatch(numClauses - 1);
        } else if (numClauses == 2) {
            qb.setMinimumNumberShouldMatch(2);
        }
        return qb.build();
    }

    private void createPartialQuery(String fieldName, String text, boolean containsWildcards, List<Query> disjuncts, int boost) {
        WildcardQuery query;
        if (text.isEmpty()) {
            return;
        }
        Term term = new Term(fieldName, text);
        Object object = query = containsWildcards ? new WildcardQuery(term) : new TermQuery(term);
        if (boost > 0) {
            disjuncts.add((Query)new BoostQuery((Query)query, (float)boost));
        } else {
            disjuncts.add((Query)query);
        }
    }

    private String normalizeWildcards(String termText) {
        StringBuilder str = new StringBuilder();
        StringReader reader = new StringReader(termText);
        boolean inAsterisk = false;
        try {
            int curChar;
            while ((curChar = reader.read()) != -1) {
                if (curChar == 42) {
                    if (inAsterisk) continue;
                    inAsterisk = true;
                } else {
                    inAsterisk = false;
                }
                str.append((char)curChar);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return str.toString();
    }

    private boolean containsWildcards(String token) {
        return token.indexOf(42) >= 0 || token.indexOf(63) >= 0;
    }
}

