/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.query;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import com.ibm.team.fulltext.common.internal.StandardTokenTypes;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class CamelCaseQueryProvider
implements IQueryProvider {
    @Override
    public Query createQuery(String tokenType, Analyzer analyzer, ITokenGroup tokenGroup) {
        if (StandardTokenTypes.CAMELCASE.getId().equals(tokenType)) {
            return this.createCamelcaseTypeQuery(tokenGroup);
        }
        if (StandardTokenTypes.CAMELCASE_PART.getId().equals(tokenType) || StandardTokenTypes.ACRONYM.getId().equals(tokenType)) {
            return null;
        }
        return null;
    }

    private Query createCamelcaseTypeQuery(ITokenGroup tokenGroup) {
        BooleanQuery.Builder qb = new BooleanQuery.Builder();
        ITokenGroup camelCaseGroup = tokenGroup.getSubGroup(StandardTokenTypes.CAMELCASE.getId());
        int numClauses = 0;
        for (ArtifactToken camelCaseToken : camelCaseGroup) {
            ArrayList<TermQuery> disjuncts = new ArrayList<TermQuery>();
            TermQuery query = new TermQuery(new Term("_name", camelCaseToken.term()));
            query = new BoostQuery((Query)query, 2.0f);
            disjuncts.add(query);
            query = new TermQuery(new Term("_content", camelCaseToken.term()));
            disjuncts.add(query);
            query = new PrefixQuery(new Term("_tags", camelCaseToken.term()));
            disjuncts.add(query);
            query = new TermQuery(new Term("_meta", camelCaseToken.term()));
            disjuncts.add(query);
            ++numClauses;
            DisjunctionMaxQuery camelCaseQuery = new DisjunctionMaxQuery(disjuncts, 0.0f);
            qb.add((Query)camelCaseQuery, BooleanClause.Occur.SHOULD);
        }
        if (numClauses > 2) {
            qb.setMinimumNumberShouldMatch(numClauses - 1);
        } else if (numClauses == 2) {
            qb.setMinimumNumberShouldMatch(2);
        }
        return qb.build();
    }
}

