/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.index;

import com.google.common.collect.MinMaxPriorityQueue;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.FulltextException;
import com.ibm.team.fulltext.common.IIndexManager;
import com.ibm.team.fulltext.common.IndexConfig;
import com.ibm.team.fulltext.common.NoPermissionException;
import com.ibm.team.fulltext.common.internal.analysis.DelegatingAnalyzer;
import com.ibm.team.fulltext.common.internal.analysis.WordSpliter;
import com.ibm.team.fulltext.common.internal.index.IIndexAccess;
import com.ibm.team.fulltext.common.internal.index.IIndexingCounter;
import com.ibm.team.fulltext.common.internal.index.IIndexingLanguage;
import com.ibm.team.fulltext.common.internal.index.Messages;
import com.ibm.team.fulltext.common.internal.index.RefCountIndexSearcher;
import com.ibm.team.fulltext.common.internal.util.AnalyzerDebugUtils;
import com.ibm.team.fulltext.common.internal.util.QueryUtils;
import com.ibm.team.fulltext.common.model.IFilter;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.fulltext.common.model.IModified;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IContextManagerService;
import com.ibm.team.repository.common.util.NLS;
import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.LimitTokenCountAnalyzer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LogDocMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.SlowCompositeReaderWrapper;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.util.BytesRef;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class IndexManagerImpl
implements IIndexManager {
    private static IndexManagerImpl fgSingleton = new IndexManagerImpl();
    private static final int FLUSH_TIME_STORES_THRESHOLD = 100;
    static final String SHUTDOWN_MARKER_FILE = "jfs-shutdown-sync.lock";
    public static final String SINGLE_INDEX_TYPE = "com.ibm.team.fulltext.service.internal.index.SingleIndexType";
    public static final String LAST_CLEANUP_PROCESSED_TIME = "com.ibm.team.fulltext.service.internal.index.lastCleanupProcessedTime";
    private static final String LUCENE_CFS = "cfs";
    private static final String LUCENE_SEGMENTS = "segments";
    private final Map<String, Long> fMapTypeToLastIndexTime = new ConcurrentHashMap<String, Long>(2);
    private final AtomicInteger fTimeStoreAccessCounter = new AtomicInteger();
    private static final String LAST_INDEX_TIME_STORE = "lastindextimes";
    private static final long UPDATING_PROGRESS_SIZE_LIMIT = 0x100000L;
    private static final int MAX_SEARCH_DURATION = 600;
    private static final int MAX_RESULT_LIMIT = 10000;
    private final DelegatingAnalyzer fDelegatingAnalyzer = new DelegatingAnalyzer();
    static final int ADDITIONAL_RESULT_FOR_LATER_FILTERING = 100;
    private final Map<String, Directory> fCachedDirectories = new ConcurrentHashMap<String, Directory>();
    private final Map<String, IndexWriter> fCachedIndexWriters = new ConcurrentHashMap<String, IndexWriter>();
    private final Map<String, RefCountIndexSearcher> fCachedIndexSearchers = new ConcurrentHashMap<String, RefCountIndexSearcher>();
    private final Map<String, Boolean> fIsFlushRequired = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, SnapshotDeletionPolicy> fCachedSnapshots = new ConcurrentHashMap<String, SnapshotDeletionPolicy>();
    private Set<String> fCachedIndexNames;
    private static final Log logger = LogFactory.getLog((String)"com.ibm.team.fulltext.common");
    private String fullTextIndexName = null;
    private boolean potentiallyCorruptedIndexes = false;
    private boolean createMarker = true;
    private int maxSearchDuration = 600;
    private int maxClauseInQuery;
    private int maxResultLimit = 10000;
    private Map<String, Map<String, Long>> indexFileSizeCacheMaps = new ConcurrentHashMap<String, Map<String, Long>>();
    private Map<String, Map<String, IndexCommitPair>> indexCommitMaps = new ConcurrentHashMap<String, Map<String, IndexCommitPair>>();
    private IIndexingCounter indexCounter;

    public static IndexManagerImpl getInstance() {
        return fgSingleton;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void index(Collection<IInformationArtifact> artifacts, boolean withDate, IContextManagerService contextManagerService, Map<String, Long> mapTypeToModifed, IProgressMonitor monitor) throws FulltextException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[DOLOOP]], but top level block is 17[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void putModified(Map<String, Long> mapTypeToModifed, IInformationArtifact artifact, String type) {
        long current;
        long modified = artifact instanceof IModified ? ((IModified)((Object)artifact)).modified() : System.currentTimeMillis();
        Long currentModified = mapTypeToModifed.get(type);
        long l = current = currentModified == null ? -1L : currentModified;
        if (modified > current) {
            mapTypeToModifed.put(type, modified);
        }
    }

    private void collectDocuments(IInformationArtifact artifact, boolean withDate, Map<String, Long> mapTypeToModifed, Map<String, List<Document>> mapTypeToDocuments) throws FulltextException {
        List<Document> documents;
        URIReference reference = artifact.getId();
        Assert.isNotNull((Object)reference, (String)Messages.getString("IndexManagerImpl.ERROR_ID_NULL"));
        Assert.isNotNull((Object)reference.getType(), (String)Messages.getString("IndexManagerImpl.ERROR_REFERENCE_TYPE_NULL"));
        if (artifact.getContainerId() != null) {
            Assert.isNotNull((Object)artifact.getContainerId().getType(), (String)Messages.getString("IndexManagerImpl.ERROR_REFERENCE_TYPE_NULL"));
            Assert.isTrue((!artifact.getContainerId().getType().equals(reference.getType()) ? 1 : 0) != 0, (String)Messages.getString("IndexManagerImpl.ERROR_WRONG_CONTAINER_TYPE"));
        }
        String type = reference.getType();
        if (!IndexConfig.useMultipleIndexes()) {
            type = SINGLE_INDEX_TYPE;
        }
        if ((documents = mapTypeToDocuments.get(type)) == null) {
            documents = new ArrayList<Document>();
            mapTypeToDocuments.put(type, documents);
        }
        Document doc = this.createDocument(artifact, withDate);
        documents.add(doc);
        if (mapTypeToModifed != null) {
            this.putModified(mapTypeToModifed, artifact, type);
        }
    }

    private Document createDocument(IInformationArtifact artifact, boolean withDate) {
        UUID context;
        Document document = new Document();
        document.add((IndexableField)new Field("_id", artifact.getId().getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (artifact.getFrontSideUri() != null) {
            document.add((IndexableField)new Field("_frontsideuri", artifact.getFrontSideUri(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        document.add((IndexableField)new Field("_artifactType", artifact.getId().getType(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        document.add((IndexableField)new Field("_artifactName", artifact.getId().getName(), Field.Store.YES, Field.Index.NO));
        document.add((IndexableField)new BinaryDocValuesField("_docId", new BytesRef((CharSequence)artifact.getId().getURI().toString())));
        boolean refDetailsMatchesName = artifact.getId().getDetails().equals(artifact.getName());
        if (!refDetailsMatchesName) {
            document.add((IndexableField)new Field("_artifactDetails", artifact.getId().getDetails(), Field.Store.YES, Field.Index.NO));
        }
        if (artifact.getContainerId() != null) {
            URIReference container = artifact.getContainerId();
            document.add((IndexableField)new Field("_containerId", container.getURI().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((IndexableField)new Field("_containerType", container.getType(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add((IndexableField)new Field("_containerName", container.getName(), Field.Store.YES, Field.Index.NO));
            document.add((IndexableField)new Field("_containerDetails", container.getDetails(), Field.Store.YES, Field.Index.NO));
            UUID containerContext = artifact.getContainerContext();
            if (containerContext == null) {
                containerContext = IContext.PUBLIC;
            }
            document.add((IndexableField)new Field("_containerContext", containerContext.getUuidValue(), Field.Store.YES, Field.Index.NO));
        }
        if ((context = artifact.getContext()) == null) {
            context = IContext.PUBLIC;
        }
        document.add((IndexableField)new Field("_context", context.getUuidValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        UUID owner = artifact.getOwner();
        if (owner != null) {
            document.add((IndexableField)new Field("_owner", owner.getUuidValue(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (artifact.getName() != null) {
            AnalyzerDebugUtils.printTokens(this.fDelegatingAnalyzer, new StringReader(artifact.getName()), "_name");
            document.add((IndexableField)new Field("_name", artifact.getName(), refDetailsMatchesName ? Field.Store.YES : Field.Store.NO, Field.Index.ANALYZED, Field.TermVector.YES));
        }
        if (artifact.getContent() != null) {
            document.add((IndexableField)new Field("_content", artifact.getContent(), Field.TermVector.YES));
        }
        if (artifact.getTags() != null) {
            AnalyzerDebugUtils.printTokens(this.fDelegatingAnalyzer, new StringReader(artifact.getTags()), "_tags");
            document.add((IndexableField)new Field("_tags", artifact.getTags(), Field.Store.NO, Field.Index.ANALYZED));
        }
        if (artifact.getMeta() != null) {
            AnalyzerDebugUtils.printTokens(this.fDelegatingAnalyzer, new StringReader(artifact.getMeta()), "_meta");
            document.add((IndexableField)new Field("_meta", artifact.getMeta(), Field.Store.NO, Field.Index.ANALYZED));
        }
        if (withDate) {
            document.add((IndexableField)new Field("_indexDate", DateTools.timeToString((long)System.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        if (artifact.getLanguage() != null) {
            document.add((IndexableField)new Field("_artifactLanguage", artifact.getLanguage(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        }
        return document;
    }

    private synchronized void write(String type, Collection<Document> documents, IContextManagerService contextManagerService, IProgressMonitor monitor) throws IOException, FulltextException {
        IndexWriter writer = this.getIndexWriter(type);
        if (this.fIsFlushRequired.containsKey(type) && this.fIsFlushRequired.get(type).booleanValue()) {
            writer.commit();
            this.fIsFlushRequired.put(type, false);
        }
        IndexSearcher searcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)this.fCachedDirectories.get(type)));
        try {
            for (Document document : documents) {
                long indexingStart;
                block17: {
                    if (logger.isDebugEnabled()) {
                        String artifactName = document.get("_artifactName");
                        String artifactType = document.get("_artifactType");
                        String containerName = document.get("_containerName");
                        String containerType = document.get("_containerType");
                        if (containerName == null) {
                            logger.debug((Object)String.format("Indexing artifact '%s' of type %s", artifactName, artifactType));
                        } else {
                            logger.debug((Object)String.format("Indexing document '%s' of type %s belonging to artifact '%s' of type %s", artifactName, artifactType, containerName, containerType));
                        }
                    }
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    indexingStart = System.currentTimeMillis();
                    String itemId = document.get("_id");
                    this.handleUpdate(document, itemId, searcher, contextManagerService);
                    try {
                        String language = document.get("_artifactLanguage");
                        this.fDelegatingAnalyzer.setOverridenLanguage(language);
                        writer.updateDocument(new Term("_id", itemId), (Iterable)document);
                    }
                    catch (CharConversionException e) {
                        String message = NLS.bind((String)Messages.getString("IndexManagerImpl.SKIP_INDEX_ENCODING_PROBLEM"), (Object)itemId, (Object[])new Object[]{type});
                        this.logException(message, (Exception)e);
                        this.fDelegatingAnalyzer.setOverridenLanguage(null);
                        break block17;
                    }
                    catch (Exception e) {
                        try {
                            this.logException(document, e);
                            break block17;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.fDelegatingAnalyzer.setOverridenLanguage(null);
                        }
                    }
                    this.fDelegatingAnalyzer.setOverridenLanguage(null);
                }
                this.fIsFlushRequired.put(type, true);
                if (this.indexCounter == null) continue;
                long indexingTime = System.currentTimeMillis() - indexingStart;
                this.indexCounter.incrementCounter(type, indexingTime);
            }
        }
        finally {
            searcher.getIndexReader().close();
        }
    }

    private void handleUpdate(Document document, String documentId, IndexSearcher searcher, IContextManagerService contextManagerService) throws IOException, FulltextException {
        TermQuery artifactQuery = new TermQuery(new Term("_id", documentId));
        TopDocs topDocs = searcher.search((Query)artifactQuery, 1);
        if (topDocs.totalHits == 1) {
            Document existingDocument = searcher.doc(topDocs.scoreDocs[0].doc);
            String newContainerId = document.get("_containerId");
            this.assertWritePermission(existingDocument, contextManagerService);
            String[] containerIds = existingDocument.getValues("_containerId");
            if (containerIds != null) {
                String[] containerContexts = existingDocument.getValues("_containerContext");
                String[] containerTypes = existingDocument.getValues("_containerType");
                String[] containerDetails = existingDocument.getValues("_containerDetails");
                String[] containerNames = existingDocument.getValues("_containerName");
                int j = 0;
                while (j < containerIds.length) {
                    if (!containerIds[j].equals(newContainerId)) {
                        String containerId = containerIds[j];
                        String containerContext = containerContexts != null && containerContexts.length > j ? containerContexts[j] : null;
                        String containerType = containerTypes[j];
                        String containerDetail = containerDetails[j];
                        String containerName = containerNames[j];
                        document.add((IndexableField)new Field("_containerId", containerId, Field.Store.YES, Field.Index.NOT_ANALYZED));
                        if (containerContext != null) {
                            document.add((IndexableField)new Field("_containerContext", containerContext, Field.Store.YES, Field.Index.NO));
                        }
                        document.add((IndexableField)new Field("_containerType", containerType, Field.Store.YES, Field.Index.NOT_ANALYZED));
                        document.add((IndexableField)new Field("_containerName", containerName, Field.Store.YES, Field.Index.NO));
                        document.add((IndexableField)new Field("_containerDetails", containerDetail, Field.Store.YES, Field.Index.NO));
                    }
                    ++j;
                }
            }
        }
    }

    @Override
    public synchronized void closeAllWriters() {
        Collection<IndexWriter> writers = this.fCachedIndexWriters.values();
        for (IndexWriter writer : writers) {
            try {
                writer.close();
            }
            catch (IOException e) {
                LogFactory.getLog((String)"com.ibm.team.fulltext.common").error((Object)Messages.getString("IndexManagerImpl.ERROR_CLOSING_WRITER"), (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Long> delete(Collection<IInformationArtifact> artifacts, IContextManagerService contextManagerService, IProgressMonitor monitor) throws FulltextException {
        HashMap<String, Long> mapTypeToModifed = new HashMap<String, Long>();
        for (IInformationArtifact artifact : artifacts) {
            URIReference reference = artifact.getId();
            this.delete(reference, null, contextManagerService, monitor);
            this.putModified(mapTypeToModifed, null, reference.getType());
        }
        return mapTypeToModifed;
    }

    public Map<String, Long> deleteReferences(Collection<URIReference> references, IContextManagerService contextManagerService, IProgressMonitor monitor) throws FulltextException {
        HashMap<String, Long> mapTypeToModifed = new HashMap<String, Long>();
        for (URIReference reference : references) {
            this.delete(reference, null, contextManagerService, monitor);
            this.putModified(mapTypeToModifed, null, reference.getType());
        }
        return mapTypeToModifed;
    }

    @Override
    public void delete(URIReference reference, URIReference container, IContextManagerService contextManagerService, IProgressMonitor monitor) throws FulltextException {
        try {
            String id = reference.getURI().toString();
            String type = reference.getType();
            TermQuery artifactQuery = new TermQuery(new Term("_id", id));
            IIndexAccess indexAccess = this.getIndexAccess();
            List<QueryUtils.Pair<Document, Float>> search = indexAccess.search(new String[]{type}, (Query)artifactQuery, null, 0.0f, 0, 0, null);
            if (search.size() == 1) {
                Document artifactToDelete = search.get(0).getFirst();
                this.assertWritePermission(artifactToDelete, contextManagerService);
                String[] containerIds = artifactToDelete.getValues("_containerId");
                if (container != null && containerIds != null && containerIds.length > 1) {
                    return;
                }
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (IndexConfig.useMultipleIndexes()) {
                this.internalDelete(id, type);
            } else {
                this.internalDelete(id, SINGLE_INDEX_TYPE);
            }
        }
        catch (IOException e) {
            this.logErrorDeletingArtifact(reference, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void delete(String id, IProgressMonitor monitor) throws FulltextException {
        try {
            Set<String> indexNames;
            Set<String> set = indexNames = this.getIndexNames();
            synchronized (set) {
                for (String indexName : indexNames) {
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    this.internalDelete(id, indexName);
                }
            }
        }
        catch (IOException e) {
            this.logErrorDeletingArtifact(id, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flushAllWriters(IProgressMonitor monitor) throws IOException {
        Set<String> indexNames;
        Set<String> set = indexNames = this.getIndexNames();
        synchronized (set) {
            for (String indexName : indexNames) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                IndexWriter writer = this.getIndexWriter(indexName);
                if (!this.fIsFlushRequired.containsKey(indexName) || !this.fIsFlushRequired.get(indexName).booleanValue()) continue;
                writer.commit();
                this.fIsFlushRequired.put(indexName, false);
                RefCountIndexSearcher indexSearcher = this.fCachedIndexSearchers.get(indexName);
                if (indexSearcher == null) continue;
                this.fCachedIndexSearchers.remove(indexName);
                indexSearcher.close();
            }
        }
    }

    private void logErrorDeletingArtifact(Object reference, Exception e) throws FulltextException {
        throw new FulltextException(NLS.bind((String)Messages.getString("IndexManagerImpl.ERROR_DELETING_ARTIFACT2"), (Object)this.getLogDetails(reference), (Object[])new Object[0]), e);
    }

    private void assertWritePermission(Document document, IContextManagerService contextManagerService) throws FulltextException {
        if (!contextManagerService.isReadPermissionEnabled()) {
            return;
        }
        String artifactContext = document.get("_context");
        String artifactOwner = document.get("_owner");
        String containerContext = document.get("_containerContext");
        if (artifactContext == null && containerContext == null && artifactOwner == null) {
            return;
        }
        try {
            UUID artifactContextUUID = UUID.valueOf((String)artifactContext);
            if (!contextManagerService.isUserInContext(artifactContextUUID)) {
                throw new NoPermissionException(Messages.getString("IndexManagerImpl.PERMISSION_DENIED"));
            }
        }
        catch (IllegalArgumentException artifactContextUUID) {
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(e.getMessage(), e);
        }
        try {
            UUID containerContextUUID = UUID.valueOf((String)containerContext);
            if (!contextManagerService.isUserInContext(containerContextUUID)) {
                throw new NoPermissionException(Messages.getString("IndexManagerImpl.PERMISSION_DENIED"));
            }
        }
        catch (IllegalArgumentException containerContextUUID) {
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(e.getMessage(), e);
        }
        try {
            UUID artifactOwnerUUID = UUID.valueOf((String)artifactOwner);
            if (!contextManagerService.isUserInContext(artifactOwnerUUID)) {
                throw new NoPermissionException(Messages.getString("IndexManagerImpl.PERMISSION_DENIED"));
            }
        }
        catch (IllegalArgumentException artifactOwnerUUID) {
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(e.getMessage(), e);
        }
    }

    private synchronized void internalDelete(String id, String type) throws IOException {
        this.getIndexWriter(type).deleteDocuments(new Term[]{new Term("_id", id)});
        this.fIsFlushRequired.put(type, true);
    }

    @Override
    public void enableIndexOptimization() {
    }

    @Override
    public void disableIndexOptimization() {
    }

    @Override
    public synchronized void optimizeIndex() throws FulltextException {
    }

    private IndexWriter getIndexWriter(String type) throws IOException {
        IndexWriter writer = this.fCachedIndexWriters.get(type);
        if (writer == null) {
            this.createIndexDirectoryAndWriterIfRequired(type);
            writer = this.fCachedIndexWriters.get(type);
        }
        return writer;
    }

    public IIndexAccess getIndexAccess() {
        return new IIndexAccess(){

            @Override
            public int docFreq(String[] searchScope, Term term) throws IOException {
                IndexSearcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(searchScope);
                try {
                    int n = searcher.getIndexReader().docFreq(term);
                    return n;
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }

            @Override
            public Terms getTermVector(int docNumber, String type, String field) throws IOException {
                RefCountIndexSearcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(type);
                try {
                    Terms terms = searcher.getIndexReader().getTermVector(docNumber, field);
                    return terms;
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }

            @Override
            public int numDocs(String[] types) throws IOException {
                int numDocs = 0;
                IndexSearcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(types);
                try {
                    numDocs = searcher.getIndexReader().numDocs();
                }
                finally {
                    this.closeSearcher(searcher);
                }
                return numDocs;
            }

            @Override
            public List<QueryUtils.Pair<Document, Float>> search(String[] searchScope, Query query, Query filter, float minScoreFactor, int resultLimit, int searchDuration, IFilter userFilter) throws IOException, FulltextException {
                ArrayList<QueryUtils.Pair<Document, Float>> results = new ArrayList<QueryUtils.Pair<Document, Float>>();
                IndexSearcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(searchScope);
                if (searcher == null) {
                    return results;
                }
                try {
                    float maxScore;
                    int resultLength;
                    ScoreDoc[] resultDocs;
                    block19: {
                        Object qb;
                        int finalResultLimit = resultLimit > 0 && resultLimit < IndexManagerImpl.this.getMaxResultLimit() ? resultLimit + 100 : IndexManagerImpl.this.getMaxResultLimit() + 100;
                        if (filter != null) {
                            qb = new BooleanQuery.Builder();
                            qb.add(query, BooleanClause.Occur.MUST);
                            qb.add(filter, BooleanClause.Occur.FILTER);
                            query = qb.build();
                        }
                        if (searchDuration <= 0 || searchDuration > IndexManagerImpl.this.getMaxSearchDuration()) {
                            searchDuration = IndexManagerImpl.this.getMaxSearchDuration();
                        }
                        if (userFilter != null) {
                            qb = null;
                            Object var15_14 = null;
                            class DocCollector<T>
                            extends SimpleCollector
                            implements AutoCloseable {
                                private long searchEndTime;
                                boolean terminatedEarly = false;
                                static final int MAX_UNTESTED = 1000;
                                Scorer scorer;
                                float maxScore = 0.0f;
                                int size = 0;
                                MinMaxPriorityQueue<ScoreDoc> topScoreDocs;
                                int docBase = 0;
                                private LeafReader reader;
                                private Map<String, 1DocCollector.Res> untested = new HashMap<String, 1DocCollector.Res>(1000);
                                private final /* synthetic */ IFilter val$userFilter;

                                public DocCollector(int resLimit, long searchEndTime, IFilter iFilter) {
                                    this.val$userFilter = iFilter;
                                    this.searchEndTime = searchEndTime;
                                    this.topScoreDocs = MinMaxPriorityQueue.orderedBy(new Comparator<ScoreDoc>(){

                                        @Override
                                        public int compare(ScoreDoc o1, ScoreDoc o2) {
                                            Float score1 = Float.valueOf(o1.score);
                                            Float score2 = Float.valueOf(o2.score);
                                            return score1.compareTo(score2);
                                        }
                                    }.reversed()).maximumSize(resLimit).create();
                                }

                                public void collect(int doc) throws IOException {
                                    BinaryDocValues bdv = DocValues.getBinary((LeafReader)this.reader, (String)"_docId");
                                    String v = bdv.get(doc).utf8ToString();
                                    1DocCollector.Res r = new 1DocCollector.Res();
                                    r.docId = this.docBase + doc;
                                    r.score = this.scorer.score();
                                    this.untested.put(v, r);
                                    if (this.untested.size() == 1000) {
                                        if (System.currentTimeMillis() > this.searchEndTime) {
                                            throw new CollectionTerminatedException();
                                        }
                                        this.ensureResultsFlushed();
                                    }
                                }

                                void ensureResultsFlushed() {
                                    if (!this.untested.isEmpty()) {
                                        Set<String> filtered;
                                        if (this.val$userFilter != null) {
                                            try {
                                                filtered = this.val$userFilter.filter(this.untested.keySet());
                                            }
                                            catch (Exception e) {
                                                filtered = this.untested.keySet();
                                            }
                                        } else {
                                            filtered = this.untested.keySet();
                                        }
                                        for (String sel : filtered) {
                                            1DocCollector.Res r = this.untested.get(sel);
                                            int docId = r.docId;
                                            if (r.score > this.maxScore) {
                                                this.maxScore = r.score;
                                            }
                                            this.topScoreDocs.add((Object)new ScoreDoc(docId, r.score));
                                        }
                                        this.size = this.topScoreDocs.size();
                                        this.untested.clear();
                                    }
                                }

                                protected void doSetNextReader(LeafReaderContext context) throws IOException {
                                    super.doSetNextReader(context);
                                    this.docBase = context.docBase;
                                    this.reader = context.reader();
                                }

                                public boolean needsScores() {
                                    return true;
                                }

                                public void setScorer(Scorer scorer) throws IOException {
                                    this.scorer = scorer;
                                }

                                ScoreDoc[] getScoreDocs() {
                                    this.ensureResultsFlushed();
                                    return (ScoreDoc[])this.topScoreDocs.toArray((Object[])new ScoreDoc[0]);
                                }

                                @Override
                                public void close() {
                                    this.untested.clear();
                                }

                                class 1DocCollector.Res {
                                    public int docId;
                                    public float score;

                                    1DocCollector.Res() {
                                    }
                                }
                            }
                            try (DocCollector collector = new DocCollector(finalResultLimit, System.currentTimeMillis() + (long)(searchDuration * 1000), userFilter);){
                                searcher.search(query, collector);
                                if (collector.terminatedEarly) {
                                    throw new FulltextException(Messages.getString("IndexManagerImpl.ERROR_SEARCH_TIMEOUT"));
                                }
                                resultDocs = collector.getScoreDocs();
                                resultLength = collector.size;
                                maxScore = collector.maxScore;
                                break block19;
                            }
                            catch (Throwable throwable) {
                                if (qb == null) {
                                    qb = throwable;
                                } else if (qb != throwable) {
                                    ((Throwable)qb).addSuppressed(throwable);
                                }
                                throw qb;
                            }
                        }
                        TopDocs topDocs = searcher.search(query, finalResultLimit);
                        resultDocs = topDocs.scoreDocs;
                        resultLength = topDocs.scoreDocs.length;
                        maxScore = topDocs.getMaxScore();
                    }
                    float cutOffScore = minScoreFactor > 0.0f ? maxScore * minScoreFactor : 0.0f;
                    float scoreNorm = maxScore <= 1.0f ? 1.0f : 1.0f / maxScore;
                    int i = 0;
                    while (i < resultLength) {
                        float score = resultDocs[i].score;
                        if (!(score < cutOffScore)) {
                            Document document = searcher.doc(resultDocs[i].doc);
                            results.add(QueryUtils.Pair.create(document, Float.valueOf(score * scoreNorm)));
                        }
                        ++i;
                    }
                    ArrayList<QueryUtils.Pair<Document, Float>> arrayList = results;
                    return arrayList;
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }

            @Override
            public PostingsEnum postings(String type, Term term) throws IOException {
                RefCountIndexSearcher searcher = IndexManagerImpl.this.internalGetIndexSearcher(type);
                try {
                    PostingsEnum postingsEnum = MultiFields.getTermDocsEnum((IndexReader)searcher.getIndexReader(), (String)term.field(), (BytesRef)term.bytes());
                    return postingsEnum;
                }
                finally {
                    this.closeSearcher(searcher);
                }
            }

            private void closeSearcher(IndexSearcher searcher) throws IOException {
                if (searcher instanceof RefCountIndexSearcher) {
                    ((RefCountIndexSearcher)searcher).close();
                } else {
                    searcher.getIndexReader().close();
                }
            }
        };
    }

    private synchronized IndexSearcher internalGetIndexSearcher(String[] types) throws IOException {
        RefCountIndexSearcher searcher = null;
        if (!IndexConfig.useMultipleIndexes()) {
            types = new String[]{SINGLE_INDEX_TYPE};
        }
        if (types == null || types.length == 0) {
            Set<String> indexNames = this.getIndexNames();
            types = indexNames.toArray(new String[indexNames.size()]);
        }
        if (types.length > 1) {
            IndexReader[] readers = new IndexReader[types.length];
            int i = 0;
            while (i < types.length) {
                RefCountIndexSearcher s = this.internalGetIndexSearcher(types[i]);
                readers[i] = s.getIndexReader();
                ++i;
            }
            MultiReader multiReader = new MultiReader(readers, false);
            searcher = new IndexSearcher((IndexReader)SlowCompositeReaderWrapper.wrap((IndexReader)multiReader));
            int i2 = 0;
            while (i2 < types.length) {
                readers[i2].decRef();
                ++i2;
            }
        } else if (types.length == 1) {
            searcher = this.internalGetIndexSearcher(types[0]);
        }
        return searcher;
    }

    private synchronized RefCountIndexSearcher internalGetIndexSearcher(String type) throws IOException {
        Assert.isNotNull((Object)type, (String)Messages.getString("IndexManagerImpl.ERROR_TYPE_NULL"));
        RefCountIndexSearcher searcher = null;
        boolean flushed = false;
        if (this.fIsFlushRequired.containsKey(type) && this.fIsFlushRequired.get(type).booleanValue()) {
            this.fCachedIndexWriters.get(type).commit();
            this.fIsFlushRequired.put(type, false);
            flushed = true;
        }
        if (!this.fCachedIndexSearchers.containsKey(type)) {
            this.createIndexDirectoryAndWriterIfRequired(type);
            searcher = new RefCountIndexSearcher(this.fCachedDirectories.get(type));
            this.fCachedIndexSearchers.put(type, searcher);
        } else if (flushed) {
            this.fCachedIndexSearchers.get(type).close();
            searcher = new RefCountIndexSearcher(this.fCachedDirectories.get(type));
            this.fCachedIndexSearchers.put(type, searcher);
        } else {
            searcher = this.fCachedIndexSearchers.get(type);
        }
        searcher.incRef();
        return searcher;
    }

    public Analyzer getAnalyzer() {
        return this.fDelegatingAnalyzer;
    }

    private void createShutDownMarkerIfNeeded(File indexLocationFile) {
        File lock = new File(indexLocationFile, SHUTDOWN_MARKER_FILE);
        if (!lock.exists()) {
            try {
                lock.createNewFile();
            }
            catch (IOException e) {
                LogFactory.getLog((String)"com.ibm.team.fulltext.common").warn((Object)e);
            }
        }
    }

    private void createIndexDirectoryAndWriterIfRequired(String type) throws IOException {
        if (!this.fCachedDirectories.containsKey(type)) {
            boolean create;
            String location = IndexConfig.getIndexLocation(type, this.fullTextIndexName, true);
            LogFactory.getLog((String)"com.ibm.team.fulltext.common").info((Object)("Fulltext:: Server location: " + location));
            NativeFSLockFactory lockFactory = NativeFSLockFactory.INSTANCE;
            FSDirectory directory = null;
            String useNios = System.getProperty("com.ibm.team.fulltext.common.lucenemmapnotsupported");
            if (useNios != null && useNios.compareToIgnoreCase("true") == 0) {
                logger.debug((Object)"Use NIOFSDirectory to index");
                directory = new NIOFSDirectory(FileSystems.getDefault().getPath(location, new String[0]), (LockFactory)lockFactory);
            } else {
                logger.debug((Object)"Use Mmap to index");
                directory = FSDirectory.open((java.nio.file.Path)FileSystems.getDefault().getPath(location, new String[0]), (LockFactory)lockFactory);
            }
            boolean bl = create = !DirectoryReader.indexExists((Directory)directory);
            if (!create) {
                IndexWriter.isLocked((Directory)directory);
            }
            IndexWriter writer = null;
            SnapshotDeletionPolicy snapshotDeletionPolicy = null;
            try {
                snapshotDeletionPolicy = new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
                LimitTokenCountAnalyzer analyzer = new LimitTokenCountAnalyzer((Analyzer)this.fDelegatingAnalyzer, 100000);
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
                config.setOpenMode(DirectoryReader.indexExists((Directory)directory) ? IndexWriterConfig.OpenMode.APPEND : IndexWriterConfig.OpenMode.CREATE);
                config.setIndexDeletionPolicy((IndexDeletionPolicy)snapshotDeletionPolicy);
                config.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                config.setMergePolicy((MergePolicy)new LogDocMergePolicy());
                config.setMaxBufferedDocs(10);
                config.setCommitOnClose(true);
                writer = new IndexWriter((Directory)directory, config);
                writer.commit();
            }
            catch (IOException e) {
                if (writer != null && writer.isOpen()) {
                    try {
                        writer.close();
                    }
                    catch (AlreadyClosedException alreadyClosedException) {
                        // empty catch block
                    }
                }
                directory.close();
                throw e;
            }
            this.fCachedDirectories.put(type, (Directory)directory);
            this.fCachedIndexWriters.put(type, writer);
            this.fCachedSnapshots.put(type, snapshotDeletionPolicy);
            if (!this.getIndexNames().contains(type)) {
                this.fCachedIndexNames.add(type);
            }
            if (this.createMarker) {
                File indexLocationFile = new File(IndexConfig.getIndexLocation(null, this.getFullTextIndexName(), true));
                if (indexLocationFile.exists()) {
                    this.createShutDownMarkerIfNeeded(indexLocationFile);
                }
                this.createMarker = false;
            }
        }
    }

    public synchronized boolean renameLegacyIndicesIfExists() {
        File legacyDir;
        String baseLocation = IndexConfig.getIndexLocation(null, this.fullTextIndexName, false);
        File indexBaseDir = new File(baseLocation);
        if (!indexBaseDir.exists() && (legacyDir = new File(IndexConfig.getIndexLocation(null, null, true))).exists()) {
            boolean success = legacyDir.renameTo(indexBaseDir);
            if (success) {
                LogFactory.getLog((String)"com.ibm.team.fulltext.common").info((Object)NLS.bind((String)Messages.getString("IndexManagerImpl.RENAME_SUCCESS"), (Object)legacyDir.getAbsolutePath(), (Object[])new Object[]{indexBaseDir.getAbsolutePath()}));
            } else {
                LogFactory.getLog((String)"com.ibm.team.fulltext.common").info((Object)NLS.bind((String)Messages.getString("IndexManagerImpl.RENAME_FAIL"), (Object)legacyDir.getAbsolutePath(), (Object[])new Object[]{indexBaseDir.getAbsolutePath()}));
            }
            return success;
        }
        return false;
    }

    private synchronized Set<String> getIndexNames() {
        if (this.fCachedIndexNames != null) {
            return this.fCachedIndexNames;
        }
        this.fCachedIndexNames = Collections.synchronizedSet(new HashSet());
        File indexLocation = new File(IndexConfig.getIndexLocation(null, this.fullTextIndexName, true));
        File[] files = indexLocation.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.fCachedIndexNames.add(file.getName());
                }
                ++n2;
            }
        }
        return this.fCachedIndexNames;
    }

    private String getLogDetails(Object cause) {
        if (cause instanceof URIReference) {
            URIReference ref = (URIReference)cause;
            return "URI: " + ref.getURI() + ", Type: " + ref.getType() + ", Name: " + ref.getName();
        }
        if (cause instanceof Document) {
            Document doc = (Document)cause;
            return "URI: " + doc.get("_id") + ", Type: " + doc.get("_artifactType") + ", Name: " + doc.get("_artifactName");
        }
        if (cause instanceof List) {
            List causes = (List)cause;
            StringBuilder str = new StringBuilder();
            for (Object obj : causes) {
                if (!(obj instanceof Document)) continue;
                str.append("[").append(this.getLogDetails(obj)).append("] ");
            }
            return str.toString();
        }
        if (cause instanceof String) {
            return "URI: " + (String)cause;
        }
        return "Unknown Cause";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() throws FulltextException {
        try {
            Set<String> types;
            Set<String> set = types = this.getIndexNames();
            synchronized (set) {
                for (String type : types) {
                    this.getIndexWriter(type).deleteDocuments(new Query[]{new MatchAllDocsQuery()});
                    this.fIsFlushRequired.put(type, true);
                }
            }
            this.optimizeIndex();
        }
        catch (IOException e) {
            throw new FulltextException(Messages.getString("IndexManagerImpl.ERROR_CLEARING_INDEX"), e);
        }
    }

    @Override
    public void startup() throws FulltextException {
        File lock;
        this.clearCaches();
        this.readTimes(this.fMapTypeToLastIndexTime, LAST_INDEX_TIME_STORE);
        File indexLocationFile = new File(IndexConfig.getIndexLocation(null, this.getFullTextIndexName(), true));
        if (indexLocationFile.exists() && (lock = new File(indexLocationFile, SHUTDOWN_MARKER_FILE)).exists()) {
            this.potentiallyCorruptedIndexes = true;
            LogFactory.getLog((String)"com.ibm.team.fulltext.common").warn((Object)NLS.bind((String)Messages.getString("IndexManagerImpl.DiagnosticServerNotGracefullyShutdown"), (Object)IndexConfig.getIndexLocation(null, this.getFullTextIndexName(), true), (Object[])new Object[0]));
        }
    }

    private void readTimes(Map<String, Long> map, String fileName) throws FulltextException {
        File timestampFile;
        String location = IndexConfig.getIndexLocation(null, this.fullTextIndexName, true);
        File indexRoot = new File(location);
        if (indexRoot.exists() && (timestampFile = new File(indexRoot, fileName)).exists()) {
            ObjectInputStream inS = null;
            try {
                try {
                    inS = new ObjectInputStream(new FileInputStream(timestampFile));
                    Object obj = inS.readObject();
                    if (obj instanceof Map) {
                        map.putAll((Map)obj);
                    }
                }
                catch (FileNotFoundException e) {
                    throw new FulltextException(e);
                }
                catch (IOException e) {
                    throw new FulltextException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new FulltextException(e);
                }
            }
            finally {
                if (inS != null) {
                    try {
                        inS.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void shutdown() throws FulltextException {
        this.writeTimes();
        File lock = new File(String.valueOf(IndexConfig.getIndexLocation(null, this.fullTextIndexName, true)) + File.separator + SHUTDOWN_MARKER_FILE);
        if (lock.exists()) {
            lock.delete();
        }
        this.createMarker = true;
        this.clearCaches();
    }

    private void writeTimes() throws FulltextException {
        this.writeTimes(this.fMapTypeToLastIndexTime, LAST_INDEX_TIME_STORE);
    }

    private void writeTimes(Map<String, Long> map, String fileName) throws FulltextException {
        String location = IndexConfig.getIndexLocation(null, this.fullTextIndexName, true);
        File indexRoot = new File(location);
        if (indexRoot.exists()) {
            File timestampFile = new File(indexRoot, fileName);
            if (timestampFile.exists() && !timestampFile.delete()) {
                throw new FulltextException(NLS.bind((String)Messages.getString("IndexManagerImpl.UNABLE_DELETE"), (Object)timestampFile, (Object[])new Object[0]));
            }
            if (map.isEmpty()) {
                return;
            }
            ObjectOutputStream outS = null;
            try {
                try {
                    outS = new ObjectOutputStream(new FileOutputStream(timestampFile));
                    outS.writeObject(map);
                }
                catch (FileNotFoundException e) {
                    throw new FulltextException(e);
                }
                catch (IOException e) {
                    throw new FulltextException(e);
                }
            }
            finally {
                if (outS != null) {
                    try {
                        outS.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void storeLastIndexedTime(String type, long timestamp) {
        this.storeTime(this.fMapTypeToLastIndexTime, type, timestamp);
    }

    @Override
    public void storeLastIndexedTime(Map<String, Long> mapTypeToModifed) {
        if (mapTypeToModifed == null) {
            return;
        }
        for (Map.Entry<String, Long> entry : mapTypeToModifed.entrySet()) {
            this.storeLastIndexedTime(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTime(Map<String, Long> map, String type, long timestamp) {
        Map<String, Long> map2 = map;
        synchronized (map2) {
            Long existing = map.get(type);
            if ((existing == null || existing < timestamp) && timestamp > 0L) {
                map.put(type, timestamp);
                if (type.equals(LAST_CLEANUP_PROCESSED_TIME) || this.fTimeStoreAccessCounter.incrementAndGet() > 100) {
                    try {
                        this.writeTimes();
                    }
                    catch (FulltextException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    this.fTimeStoreAccessCounter.set(0);
                }
            }
        }
    }

    @Override
    public long getLastIndexedTimestamp(String type) {
        Long lastIndexTime = this.fMapTypeToLastIndexTime.get(type);
        if (lastIndexTime != null) {
            return lastIndexTime;
        }
        return -1L;
    }

    private void logException(String messagePrefix, Exception ex) {
        logger.error((Object)(String.valueOf(messagePrefix) + ex.getMessage()), (Throwable)ex);
    }

    private void logException(Document document, Exception ex) {
        String artifactName = document.get("_artifactName");
        String containerName = document.get("_containerName");
        if (containerName == null) {
            String message = NLS.bind((String)Messages.getString("IndexManagerImpl.ERROR_INDEXING_ARTIFACT"), (Object)artifactName, (Object[])new Object[]{ex.getMessage()});
            logger.error((Object)message, (Throwable)ex);
        } else {
            String message = NLS.bind((String)Messages.getString("IndexManagerImpl.ERROR_INDEXING_DOCUMENT"), (Object)artifactName, (Object[])new Object[]{containerName, ex.getMessage()});
            logger.error((Object)message, (Throwable)ex);
        }
    }

    private synchronized void clearCaches() {
        for (IndexWriter writer : this.fCachedIndexWriters.values()) {
            try {
                writer.close();
            }
            catch (CorruptIndexException ex) {
                this.logException("Problem while closing index writer: ", (Exception)((Object)ex));
            }
            catch (IOException ex) {
                this.logException("Problem while closing index writer: ", (Exception)ex);
            }
        }
        for (RefCountIndexSearcher searcher : this.fCachedIndexSearchers.values()) {
            try {
                searcher.close();
            }
            catch (IOException ex) {
                this.logException("Problem while closing index searcher: ", (Exception)ex);
            }
        }
        for (Directory directory : this.fCachedDirectories.values()) {
            try {
                directory.close();
            }
            catch (IOException ex) {
                this.logException("Problem while closing index directory: ", (Exception)ex);
            }
        }
        this.fCachedDirectories.clear();
        this.fCachedSnapshots.clear();
        this.fCachedIndexWriters.clear();
        this.fCachedIndexSearchers.clear();
        this.fIsFlushRequired.clear();
        this.fMapTypeToLastIndexTime.clear();
        if (this.fCachedIndexNames != null) {
            this.fCachedIndexNames.clear();
        }
    }

    public WordSpliter.Options getOptions(boolean stemming) {
        return this.fDelegatingAnalyzer.getOptions(stemming);
    }

    public void setIndexingLanguage(IIndexingLanguage language) {
        this.fDelegatingAnalyzer.setIndexingLanguage(language);
    }

    public Analyzer getCJKAnalyzer() {
        return this.fDelegatingAnalyzer.getCJKAnalyzer();
    }

    public void setCJKAnalyzer(Analyzer cjkAnalyzer) {
        this.fDelegatingAnalyzer.setCJKAnalyzer(cjkAnalyzer);
    }

    public boolean isSpecialHandling() {
        return this.fDelegatingAnalyzer.isSpecialHandling();
    }

    public void setSpecialHandling(boolean isSpecialHandling) {
        this.fDelegatingAnalyzer.setSpecialHandling(isSpecialHandling);
    }

    public void setUseLanguageStemmer(WordSpliter.Stemmer useLanguageStemmer) {
        this.fDelegatingAnalyzer.setUseLanguageStemmer(useLanguageStemmer);
    }

    public WordSpliter.Stemmer getUseLanguageStemmer() {
        return this.fDelegatingAnalyzer.getUseLanguageStemmer();
    }

    public void setFullTextIndexName(String indexName) {
        this.fullTextIndexName = indexName;
    }

    public String getFullTextIndexName() {
        return this.fullTextIndexName;
    }

    public void setMaxSearchDuration(int maxSearchDuration) {
        this.maxSearchDuration = maxSearchDuration;
    }

    public int getMaxSearchDuration() {
        return this.maxSearchDuration;
    }

    public void setMaxResultLimit(int maxResultLimit) {
        this.maxResultLimit = maxResultLimit;
    }

    public void setMaxClauseInQuery(Integer maxClauseInQuery) {
        this.maxClauseInQuery = maxClauseInQuery;
    }

    @Override
    public int getMaxClauseInQuery() {
        return this.maxClauseInQuery;
    }

    public int getMaxResultLimit() {
        return this.maxResultLimit;
    }

    private void backupIndexingTime(ZipOutputStream zipOut, String fileName, Map<String, Long> storedTime, String backupId, Map<String, Long> backupIndexProgressMap, Map<String, Long> indexFileSizeCacheMap) throws IOException {
        String rootLocation = IndexConfig.getIndexLocation(null, this.fullTextIndexName, true);
        File timestampFile = new File(rootLocation, fileName);
        if (timestampFile.exists()) {
            ZipEntry timeEntry = new ZipEntry(Path.fromOSString((String)fileName).toPortableString());
            timeEntry.setComment(this.fullTextIndexName);
            zipOut.putNextEntry(timeEntry);
            Throwable throwable = null;
            Object var11_14 = null;
            try (ObjectOutputStream outS = new ObjectOutputStream(new FileOutputStream(timestampFile));){
                outS.writeObject(storedTime);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var11_14 = null;
            try (FileInputStream fis = new FileInputStream(timestampFile);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zipOut.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            if (backupId != null) {
                long fileLen = timestampFile.length();
                if (indexFileSizeCacheMap.get(timestampFile.getAbsolutePath()) != null && indexFileSizeCacheMap.get(timestampFile.getAbsolutePath()) != fileLen) {
                    fileLen = indexFileSizeCacheMap.get(timestampFile.getAbsolutePath());
                }
                if (backupIndexProgressMap.get(backupId) == null) {
                    backupIndexProgressMap.put(backupId, fileLen);
                } else {
                    backupIndexProgressMap.put(backupId, backupIndexProgressMap.get(backupId) + fileLen);
                }
            }
        }
    }

    public void backup(ZipOutputStream zipOut, String backupId, Map<String, Long> backupIndexProgressMap) throws IOException {
        try (FileInputStream inFile = null;){
            Map<String, Long> fileSizeCacheMap = this.indexFileSizeCacheMaps.get(backupId);
            Map<String, IndexCommitPair> indexCommitMap = this.indexCommitMaps.get(backupId);
            this.backupIndexingTime(zipOut, LAST_INDEX_TIME_STORE, this.fMapTypeToLastIndexTime, backupId, backupIndexProgressMap, fileSizeCacheMap);
            String rootLocation = IndexConfig.getIndexLocation(null, this.fullTextIndexName, true);
            File rootDir = new File(rootLocation);
            if (rootDir.exists() && rootDir.isDirectory()) {
                File[] allFiles = rootDir.listFiles();
                if (allFiles == null) {
                    return;
                }
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File oneFile = fileArray[n2];
                    if (oneFile.isDirectory()) {
                        String type = oneFile.getName();
                        this.createIndexDirectoryAndWriterIfRequired(oneFile.getName());
                        IndexCommitPair snapshot = indexCommitMap.get(type);
                        IndexCommit commit = snapshot.getIndexCommit();
                        Collection files = commit.getFileNames();
                        long initSize = backupIndexProgressMap.get(backupId) == null ? 0L : backupIndexProgressMap.get(backupId);
                        for (String fileName : files) {
                            File oneIndexFile = new File(fileName);
                            String entyName = String.valueOf(type) + File.separator + oneIndexFile.getName();
                            ZipEntry entry = new ZipEntry(Path.fromOSString((String)entyName).toPortableString());
                            entry.setComment(this.fullTextIndexName);
                            zipOut.putNextEntry(entry);
                            inFile = new FileInputStream(String.valueOf(IndexConfig.getIndexLocation(type, this.fullTextIndexName, true)) + File.separator + oneIndexFile.getName());
                            byte[] b = new byte[256];
                            int len = 0;
                            long totalLen = 0L;
                            int i = 1;
                            while ((len = inFile.read(b)) > 0) {
                                zipOut.write(b, 0, len);
                                if ((totalLen += (long)len) / ((long)i * 0x100000L) <= 0L) continue;
                                backupIndexProgressMap.put(backupId, initSize + totalLen);
                                ++i;
                            }
                            inFile.close();
                            if (fileSizeCacheMap.get(oneIndexFile.getAbsolutePath()) != null && fileSizeCacheMap.get(oneIndexFile.getAbsolutePath()) != totalLen) {
                                totalLen = fileSizeCacheMap.get(oneIndexFile.getAbsolutePath());
                            }
                            backupIndexProgressMap.put(backupId, initSize + totalLen);
                            initSize += totalLen;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public synchronized long getBackupIndexSize(String backupId) throws IOException {
        String rootLocation;
        File rootDir;
        Map<String, Long> fileSizeCacheMap;
        long totolBackupSize = 0L;
        String id = UUID.generate().getUuidValue();
        Map<String, IndexCommitPair> indexCommitMap = this.indexCommitMaps.get(backupId);
        if (indexCommitMap == null) {
            indexCommitMap = new ConcurrentHashMap<String, IndexCommitPair>();
        }
        if ((fileSizeCacheMap = this.indexFileSizeCacheMaps.get(backupId)) == null) {
            fileSizeCacheMap = new ConcurrentHashMap<String, Long>();
        }
        if ((rootDir = new File(rootLocation = IndexConfig.getIndexLocation(null, this.fullTextIndexName, true))).exists() && rootDir.isDirectory()) {
            File[] allFiles = rootDir.listFiles();
            if (allFiles != null) {
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File oneFile = fileArray[n2];
                    if (!oneFile.isDirectory()) {
                        totolBackupSize += oneFile.length();
                        fileSizeCacheMap.put(oneFile.getAbsolutePath(), oneFile.length());
                    } else {
                        String type = oneFile.getName();
                        this.createIndexDirectoryAndWriterIfRequired(type);
                        IndexCommit commit = this.fCachedSnapshots.get(type).snapshot();
                        Collection files = commit.getFileNames();
                        File[] childFiles = oneFile.listFiles();
                        if (childFiles != null) {
                            File[] fileArray2 = childFiles;
                            int n3 = childFiles.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                File indexFile = fileArray2[n4];
                                if (files.contains(indexFile.getName())) {
                                    totolBackupSize += indexFile.length();
                                    fileSizeCacheMap.put(indexFile.getAbsolutePath(), indexFile.length());
                                }
                                ++n4;
                            }
                        }
                        indexCommitMap.put(type, new IndexCommitPair(id, commit));
                    }
                    ++n2;
                }
            }
            this.indexCommitMaps.put(backupId, indexCommitMap);
            this.indexFileSizeCacheMaps.put(backupId, fileSizeCacheMap);
        }
        return totolBackupSize;
    }

    public synchronized long getDiskSpace() {
        File[] allFiles;
        long totolBackupSize = 0L;
        String rootLocation = IndexConfig.getIndexLocation(null, this.fullTextIndexName, true);
        File rootDir = new File(rootLocation);
        if (rootDir.exists() && rootDir.isDirectory() && (allFiles = rootDir.listFiles()) != null) {
            File[] fileArray = allFiles;
            int n = allFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File oneFile = fileArray[n2];
                if (!oneFile.isDirectory()) {
                    totolBackupSize += oneFile.length();
                } else {
                    File[] files = oneFile.listFiles();
                    if (files != null) {
                        File[] fileArray2 = files;
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File indexFile = fileArray2[n4];
                            totolBackupSize += indexFile.length();
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
        }
        return totolBackupSize;
    }

    public void clearBackup(String backupId) throws IOException {
        Map<String, IndexCommitPair> indexCommitMap;
        if (this.indexFileSizeCacheMaps.get(backupId) != null) {
            this.indexFileSizeCacheMaps.remove(backupId);
        }
        if ((indexCommitMap = this.indexCommitMaps.get(backupId)) != null) {
            for (Map.Entry<String, IndexCommitPair> entry : indexCommitMap.entrySet()) {
                IndexCommitPair indexCommitPair = entry.getValue();
                this.fCachedSnapshots.get(entry.getKey()).release(indexCommitPair.getIndexCommit());
            }
            this.indexCommitMaps.remove(backupId);
        }
    }

    public void setIndexingTimeCounter(IIndexingCounter indexingCounter) {
        this.indexCounter = indexingCounter;
    }

    public boolean corruptedIndexes() {
        return this.potentiallyCorruptedIndexes;
    }

    public IStatus deleteFulltextDirectory(String pluginId) {
        this.clearCaches();
        String indexBaseLocation = IndexConfig.getIndexLocation(null, this.fullTextIndexName, true);
        File indexBaseDir = new File(indexBaseLocation);
        if (!indexBaseDir.exists() || !indexBaseDir.isDirectory()) {
            return this.createStatus(NLS.bind((String)Messages.getString("FulltextMigrationHandler.INDEX_DIR_NOT_FOUND"), (Object)indexBaseDir.getAbsolutePath(), (Object[])new Object[0]), 2, pluginId);
        }
        File[] indexDirectories = indexBaseDir.listFiles();
        if (indexDirectories != null) {
            File[] fileArray = indexDirectories;
            int n = indexDirectories.length;
            int n2 = 0;
            while (n2 < n) {
                File indexDirectory = fileArray[n2];
                if (this.isLuceneDirectory(indexDirectory)) {
                    File[] files = indexDirectory.listFiles();
                    if (files != null) {
                        File[] fileArray2 = files;
                        int n3 = files.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File file = fileArray2[n4];
                            if (!file.delete()) {
                                return this.createStatus(NLS.bind((String)Messages.getString("FulltextMigrationHandler.UNABLE_DELETE_FILE"), (Object)file.getAbsolutePath(), (Object[])new Object[0]), 4, pluginId);
                            }
                            ++n4;
                        }
                    }
                    if (!indexDirectory.delete()) {
                        return this.createStatus(NLS.bind((String)Messages.getString("FulltextMigrationHandler.UNABLE_DELETE_DIR"), (Object)indexDirectory.getAbsolutePath(), (Object[])new Object[0]), 4, pluginId);
                    }
                }
                ++n2;
            }
        }
        return this.createStatus(Messages.getString("FulltextMigrationHandler.SUCCESS_DELETE_DIR"), 0, pluginId);
    }

    private boolean isLuceneDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    return false;
                }
                String name = file.getName();
                if (name.contains(LUCENE_SEGMENTS) || name.contains(LUCENE_CFS)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private IStatus createStatus(String msg, int severity, String pluginId) {
        return new Status(severity, pluginId, msg);
    }

    static class IndexCommitPair {
        String snapshotId;
        IndexCommit indexCommit;

        IndexCommitPair(String snapshotId, IndexCommit indexCommit) {
            this.snapshotId = snapshotId;
            this.indexCommit = indexCommit;
        }

        public String getSnapshotId() {
            return this.snapshotId;
        }

        public IndexCommit getIndexCommit() {
            return this.indexCommit;
        }
    }
}

