/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.internal.analysis.CamelCaseFilter;
import com.ibm.team.fulltext.common.internal.analysis.ChineseTokenizerWorkaroundFilter;
import com.ibm.team.fulltext.common.internal.analysis.LegacyPorterStemFilter;
import com.ibm.team.fulltext.common.internal.analysis.LowerCaseFilter;
import com.ibm.team.fulltext.common.internal.analysis.MultiCharacterFilter;
import com.ibm.team.fulltext.common.internal.analysis.NonAlphaNumSplitFilter;
import com.ibm.team.fulltext.common.internal.analysis.PorterStemFilter;
import com.ibm.team.fulltext.common.internal.analysis.SplitTokenFilter;
import com.ibm.team.fulltext.common.internal.analysis.StopFilter;
import com.ibm.team.fulltext.common.internal.analysis.WhiteSpaceSplitFilter;
import com.ibm.team.repository.common.transport.InsecureProtocolException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.EnglishStemmer;
import org.tartarus.snowball.ext.FrenchStemmer;
import org.tartarus.snowball.ext.German2Stemmer;
import org.tartarus.snowball.ext.HungarianStemmer;
import org.tartarus.snowball.ext.PortugueseStemmer;
import org.tartarus.snowball.ext.RussianStemmer;
import org.tartarus.snowball.ext.SpanishStemmer;
import org.tartarus.snowball.ext.TurkishStemmer;

public class WordSpliter {
    private static Map<String, Language> Languages = new HashMap<String, Language>();

    static {
        Languages.put(Locale.CHINESE.getLanguage(), Language.CHINESE);
        Languages.put(Locale.ENGLISH.getLanguage(), Language.ENGLISH);
        Languages.put(Locale.FRENCH.getLanguage(), Language.FRENCH);
        Languages.put(Locale.GERMAN.getLanguage(), Language.GERMAN);
        Languages.put("hu", Language.HUNGARIAN);
        Languages.put(Locale.JAPANESE.getLanguage(), Language.JAPANESE);
        Languages.put(Locale.KOREAN.getLanguage(), Language.KOREAN);
        Languages.put("pl", Language.POLISH);
        Languages.put("pt", Language.PORTUGUESE);
        Languages.put("ru", Language.RUSSIAN);
        Languages.put("es", Language.SPANISH);
        Languages.put("tr", Language.TURKISH);
    }

    public static Language languageFrom(String language) {
        Language result = Languages.get(language);
        if (result == null) {
            return Language.UNKNOWN;
        }
        return result;
    }

    public static TokenStream newSimpleWordSpliter(Reader reader, Options options) {
        switch (options.language) {
            case CHINESE: {
                if (options.cjkAnalyzer != null) {
                    return WordSpliter.jfsCJKTokenizer(reader, options.cjkAnalyzer);
                }
                return WordSpliter.chineseTokenizer(reader);
            }
            case JAPANESE: {
                if (options.cjkAnalyzer != null) {
                    return WordSpliter.jfsCJKTokenizer(reader, options.cjkAnalyzer);
                }
                return WordSpliter.japaneseTokenizer(reader);
            }
        }
        WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer();
        return analyzer.tokenStream(null, reader);
    }

    public static TokenStream newWordSpliter(TokenStream input, Options options) {
        switch (options.language) {
            case CHINESE: {
                if (options.cjkAnalyzer != null) {
                    return WordSpliter.jfsCJKTokenizer(input, options.cjkAnalyzer);
                }
                return WordSpliter.chineseTokenizer(input);
            }
            case JAPANESE: {
                if (options.cjkAnalyzer != null) {
                    return WordSpliter.jfsCJKTokenizer(input, options.cjkAnalyzer);
                }
                return WordSpliter.japaneseTokenizer(input);
            }
        }
        return WordSpliter.defaultTokenizer(input, options);
    }

    private static TokenStream jfsCJKTokenizer(TokenStream input, Analyzer cjkAnalyzer) {
        return WordSpliter.jfsCJKTokenizer(new TokenStreamReader(input), cjkAnalyzer);
    }

    private static TokenStream jfsCJKTokenizer(Reader reader, Analyzer cjkAnalyzer) {
        return cjkAnalyzer.tokenStream(null, reader);
    }

    public static TokenStream defaultTokenizer(TokenStream input, Options options) {
        MultiCharacterFilter multiCharacterFilter;
        WhiteSpaceSplitFilter whiteSpaceFilter = new WhiteSpaceSplitFilter(input);
        NonAlphaNumSplitFilter splitFilter = new NonAlphaNumSplitFilter((TokenStream)whiteSpaceFilter, options.wildcardAware);
        SplitTokenFilter camelCaseFilter = multiCharacterFilter = new MultiCharacterFilter((TokenStream)splitFilter, options.isQueryAnalyser);
        if (options.useCamelCase) {
            camelCaseFilter = new CamelCaseFilter((TokenStream)multiCharacterFilter, options.expandCamelCaseTokens);
        }
        LowerCaseFilter lowerCaseFilter = new LowerCaseFilter((TokenStream)camelCaseFilter);
        StopFilter stopFilter = new StopFilter((TokenStream)lowerCaseFilter);
        switch (options.useLanguageStemmer) {
            case LEGACY: {
                return new LegacyPorterStemFilter((TokenStream)stopFilter);
            }
            case ON: {
                EnglishStemmer stemmer = null;
                switch (options.language) {
                    case CHINESE: {
                        break;
                    }
                    case ENGLISH: {
                        stemmer = new EnglishStemmer();
                        break;
                    }
                    case FRENCH: {
                        stemmer = new FrenchStemmer();
                        break;
                    }
                    case GERMAN: {
                        stemmer = new German2Stemmer();
                        break;
                    }
                    case HUNGARIAN: {
                        stemmer = new HungarianStemmer();
                        break;
                    }
                    case JAPANESE: {
                        break;
                    }
                    case KOREAN: {
                        break;
                    }
                    case POLISH: {
                        break;
                    }
                    case PORTUGUESE: {
                        stemmer = new PortugueseStemmer();
                        break;
                    }
                    case RUSSIAN: {
                        stemmer = new RussianStemmer();
                        break;
                    }
                    case SPANISH: {
                        stemmer = new SpanishStemmer();
                        break;
                    }
                    case TURKISH: {
                        stemmer = new TurkishStemmer();
                        break;
                    }
                }
                if (stemmer == null) {
                    return stopFilter;
                }
                return new PorterStemFilter((TokenStream)stopFilter, (SnowballProgram)stemmer);
            }
        }
        return stopFilter;
    }

    private static TokenStream japaneseTokenizer(TokenStream input) {
        TokenStreamReader reader = new TokenStreamReader(input);
        return WordSpliter.japaneseTokenizer(reader);
    }

    private static TokenStream japaneseTokenizer(Reader reader) {
        JapaneseAnalyzer analyzer = new JapaneseAnalyzer(null, JapaneseTokenizer.Mode.SEARCH, JapaneseAnalyzer.getDefaultStopSet(), Collections.EMPTY_SET);
        TokenStream stream = analyzer.tokenStream(null, reader);
        TokenStreamReaderFilter filter = new TokenStreamReaderFilter(stream, (Analyzer)analyzer, reader);
        return filter;
    }

    private static TokenStream chineseTokenizer(TokenStream input) {
        TokenStreamReader reader = new TokenStreamReader(input);
        return WordSpliter.chineseTokenizer(reader);
    }

    private static TokenStream chineseTokenizer(Reader reader) {
        SmartChineseAnalyzer analyzer = new SmartChineseAnalyzer();
        TokenStream stream = analyzer.tokenStream(null, reader);
        TokenStreamReaderFilter filter = new TokenStreamReaderFilter(stream, (Analyzer)analyzer, reader);
        return new ChineseTokenizerWorkaroundFilter((TokenStream)filter);
    }

    public static enum Language {
        CHINESE,
        ENGLISH,
        FRENCH,
        GERMAN,
        HUNGARIAN,
        JAPANESE,
        KOREAN,
        POLISH,
        PORTUGUESE,
        RUSSIAN,
        SPANISH,
        TURKISH,
        UNKNOWN;

    }

    public static class Options {
        boolean wildcardAware;
        boolean useCamelCase;
        boolean expandCamelCaseTokens;
        Stemmer useLanguageStemmer = Stemmer.OFF;
        boolean isQueryAnalyser = false;
        Language language = Language.UNKNOWN;
        private Analyzer cjkAnalyzer;

        public void setWildcardAware(boolean wildcardAware) {
            this.wildcardAware = wildcardAware;
        }

        public void setUseCamelCase(boolean useCamelCase) {
            this.useCamelCase = useCamelCase;
        }

        public void setExpandCamelCaseTokens(boolean expandCamelCaseTokens) {
            this.expandCamelCaseTokens = expandCamelCaseTokens;
        }

        public void setUseLanguageStemmer(Stemmer useLanguageStemmer) {
            this.useLanguageStemmer = useLanguageStemmer;
        }

        public void setLanguage(Language language) {
            this.language = language;
        }

        public void setLanguage(String language) {
            this.language = WordSpliter.languageFrom(language);
        }

        public void setCJKAnalyzer(Analyzer cjkAnalyzer) {
            this.cjkAnalyzer = cjkAnalyzer;
        }

        public void setIsQueryAnalyser(boolean isQueryAnalyser) {
            this.isQueryAnalyser = isQueryAnalyser;
        }

        public void useNewCJKAnalyzer() throws Exception {
            if (this.cjkAnalyzer != null) {
                Class<?> analyzerClass = this.cjkAnalyzer.getClass();
                Constructor<?> constructor = null;
                try {
                    constructor = analyzerClass.getConstructor(Set.class);
                    Analyzer analyzer = (Analyzer)constructor.newInstance(Collections.emptySet());
                    this.setCJKAnalyzer(analyzer);
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodException(e.getMessage());
                }
                catch (SecurityException e) {
                    throw new SecurityException(e.getMessage(), e.getCause());
                }
                catch (InstantiationException e) {
                    throw new InsecureProtocolException(e.getMessage(), e.getCause());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessException(e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(e.getMessage(), e.getCause());
                }
                catch (InvocationTargetException e) {
                    throw new InvocationTargetException(e, e.getMessage());
                }
            }
        }
    }

    public static enum Stemmer {
        ON,
        OFF,
        LEGACY;

    }

    private static class TokenStreamReader
    extends Reader {
        TokenStream input;
        int tokenIndex = -1;
        CharTermAttribute termAtt;
        boolean resetCompleted;

        public TokenStreamReader(TokenStream input) {
            this.input = input;
            this.termAtt = (CharTermAttribute)input.getAttribute(CharTermAttribute.class);
        }

        @Override
        public int read() throws IOException {
            return this.nextChar();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int read = 0;
            int end = off + len;
            this.reset();
            int i = off;
            while (i < end) {
                int c = this.nextChar();
                if (c == -1) {
                    if (read != 0) break;
                    return -1;
                }
                cbuf[i] = (char)c;
                ++read;
                ++i;
            }
            return read;
        }

        private int nextChar() throws IOException {
            if (this.tokenIndex == -1) {
                if (!this.input.incrementToken()) {
                    return -1;
                }
            } else if (this.tokenIndex == this.termAtt.length() - 1) {
                this.tokenIndex = -1;
                return 32;
            }
            return this.termAtt.charAt(++this.tokenIndex);
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        public TokenStream getInput() {
            return this.input;
        }

        @Override
        public void reset() throws IOException {
            if (!this.resetCompleted) {
                this.input.reset();
                this.resetCompleted = true;
            }
        }
    }

    private static class TokenStreamReaderFilter
    extends TokenFilter {
        private final Analyzer analyzer;
        private final Reader reader;

        protected TokenStreamReaderFilter(TokenStream stream, Analyzer analyzer, Reader reader) {
            super(stream);
            this.analyzer = analyzer;
            this.reader = reader;
        }

        public boolean incrementToken() throws IOException {
            return this.input.incrementToken();
        }

        public void end() throws IOException {
            this.input.end();
            if (this.reader instanceof TokenStreamReader) {
                ((TokenStreamReader)this.reader).getInput().end();
            }
        }

        public void close() throws IOException {
            this.input.close();
            this.analyzer.close();
            if (this.reader instanceof TokenStreamReader) {
                ((TokenStreamReader)this.reader).close();
            }
        }

        public void reset() throws IOException {
            this.input.reset();
            if (this.reader instanceof TokenStreamReader) {
                ((TokenStreamReader)this.reader).reset();
            }
        }
    }
}

