/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import com.ibm.team.fulltext.common.internal.analysis.SplitTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class WhiteSpaceSplitFilter
extends SplitTokenFilter {
    public WhiteSpaceSplitFilter(TokenStream stream) {
        super(stream);
    }

    @Override
    protected void splitToken(ArtifactAttribute token) {
        if (token.isArtifact() && !token.applies(TokenizerTypes.SPLIT_WHITESPACE)) {
            this.addToQueue(token);
            return;
        }
        String[] splited = token.term().split("\\s+");
        int offset = 0;
        String[] stringArray = splited;
        int n = splited.length;
        int n2 = 0;
        while (n2 < n) {
            String split = stringArray[n2];
            this.addToQueue((CharTermAttribute)this.createToken(split, offset, offset + split.length(), token));
            offset = split.length() + 1;
            ++n2;
        }
    }

    private ArtifactToken createToken(String value, int start, int end, ArtifactAttribute initial) {
        if (initial instanceof ArtifactToken) {
            return ((ArtifactToken)((Object)initial)).clone(value, start, end);
        }
        if (initial instanceof ArtifactAttributeImpl) {
            return ((ArtifactAttributeImpl)initial).toToken(value, start, end);
        }
        return new ArtifactToken(value, start, end);
    }
}

