/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.ILineTokenizer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class TokenizerPool {
    private static final String TOKENIZER_CLASS_ATTRIBUTE = "class";
    private static final int POOL_SIZE = 10;
    private final BlockingQueue<ILineTokenizer> fTokenizerPool = new LinkedBlockingQueue<ILineTokenizer>(10);
    private final IConfigurationElement fConfigurationElement;

    public TokenizerPool(IConfigurationElement configurationElement) throws CoreException {
        this.fConfigurationElement = configurationElement;
        int i = 0;
        while (i < 10) {
            ILineTokenizer tokenizer = (ILineTokenizer)configurationElement.createExecutableExtension(TOKENIZER_CLASS_ATTRIBUTE);
            if (tokenizer != null) {
                this.fTokenizerPool.offer(tokenizer);
            }
            ++i;
        }
    }

    public ILineTokenizer getTokenizer() throws CoreException {
        ILineTokenizer tokenizer = (ILineTokenizer)this.fTokenizerPool.poll();
        if (tokenizer == null) {
            return (ILineTokenizer)this.fConfigurationElement.createExecutableExtension(TOKENIZER_CLASS_ATTRIBUTE);
        }
        return tokenizer;
    }

    public void returnTokenizer(ILineTokenizer tokenizer) {
        this.fTokenizerPool.offer(tokenizer);
    }
}

