/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import com.ibm.team.fulltext.common.internal.util.QueryUtils;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.AttributeImpl;

public abstract class SplitTokenFilter
extends TokenFilter {
    private final LinkedList<CharTermAttribute> fTokenQueue = new LinkedList();
    private ArtifactAttribute attribute = ArtifactAttributeImpl.addAttributeToStream((TokenStream)this);

    protected SplitTokenFilter(TokenStream stream) {
        super(stream);
    }

    public boolean incrementToken() throws IOException {
        while (this.fTokenQueue.isEmpty()) {
            if (!this.input.incrementToken()) {
                return false;
            }
            this.splitToken(this.attribute);
        }
        CharTermAttribute first = this.fTokenQueue.removeFirst();
        if (first != this.attribute) {
            ((AttributeImpl)first).copyTo((AttributeImpl)this.attribute);
        }
        return true;
    }

    protected abstract void splitToken(ArtifactAttribute var1) throws IOException;

    protected void addToQueue(CharTermAttribute token) {
        if (token != null && QueryUtils.termText(token).length() > 0) {
            this.fTokenQueue.add(token);
        }
    }
}

