/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.internal.analysis.SplitLinesTokenizer;
import com.ibm.team.fulltext.common.internal.analysis.WordSpliter;
import com.ibm.team.fulltext.common.internal.index.IndexManagerImpl;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;

public final class QuoteAnalyzer
extends Analyzer {
    public QuoteAnalyzer() {
        super(PER_FIELD_REUSE_STRATEGY);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        if ("_tags".equals(fieldName)) {
            return this.createStreamTokenizer(false);
        }
        return this.createStreamTokenizer(true);
    }

    private Analyzer.TokenStreamComponents createStreamTokenizer(boolean stemming) {
        SplitLinesTokenizer lineTokenizer = new SplitLinesTokenizer();
        WordSpliter.Options options = IndexManagerImpl.getInstance().getOptions(stemming);
        options.setUseCamelCase(true);
        TokenStream tokenStream = WordSpliter.newWordSpliter((TokenStream)lineTokenizer, options);
        return new Analyzer.TokenStreamComponents((Tokenizer)lineTokenizer, tokenStream);
    }
}

