/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.ITokenGroup;
import com.ibm.team.fulltext.common.internal.Messages;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import com.ibm.team.fulltext.common.internal.util.QueryUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.eclipse.core.runtime.Assert;

public class TokenGroup
implements ITokenGroup {
    private final String fField;
    private final LinkedList<ArtifactToken> fTokens = new LinkedList();
    private final Set<String> fTokenTypes = new HashSet<String>();

    public static ITokenGroup createTokenGroup(Analyzer analyzer, String field, Reader contentReader) throws IOException {
        TokenGroup group = new TokenGroup(field);
        TokenStream stream = analyzer.tokenStream(field, contentReader);
        stream.reset();
        ArtifactAttributeImpl attribute = ArtifactAttributeImpl.addAttributeToStream(stream);
        try {
            while (stream.incrementToken()) {
                group.add(attribute.toToken());
            }
            stream.end();
        }
        finally {
            stream.close();
        }
        return group;
    }

    private TokenGroup(String field) {
        this.fField = field;
    }

    private void add(ArtifactToken token) {
        this.fTokens.add(token);
        this.fTokenTypes.add(token.type());
    }

    @Override
    public ITokenGroup getSubGroup(String type) {
        Assert.isNotNull((Object)type, (String)Messages.getString("TokenGroup.ERROR_TYPE_NULL"));
        TokenGroup group = new TokenGroup(this.fField);
        for (ArtifactToken token : this.fTokens) {
            if (!type.equals(token.type())) continue;
            group.add(token);
        }
        return group;
    }

    @Override
    public ITokenGroup getSubGroup(ArtifactToken parent, List<String> includeTypes) {
        int offset;
        Assert.isNotNull((Object)((Object)parent));
        Assert.isNotNull(includeTypes);
        TokenGroup group = new TokenGroup(this.fField);
        group.add(parent);
        int i = offset = this.fTokens.indexOf((Object)parent) + 1;
        while (i < this.fTokens.size()) {
            ArtifactToken token = this.fTokens.get(i);
            if (includeTypes.contains(token.type()) && parent.equals((Object)token.getCreatedFrom())) {
                group.add(token);
            }
            ++i;
        }
        return group;
    }

    @Override
    public Set<String> getTokenTypes() {
        return Collections.unmodifiableSet(this.fTokenTypes);
    }

    @Override
    public Iterator<ArtifactToken> iterator() {
        return this.fTokens.iterator();
    }

    @Override
    public BooleanQuery toBooleanQuery(BooleanClause.Occur occur, boolean usePrefixQuery) {
        return this.toBooleanQuery(this.fField, occur, usePrefixQuery);
    }

    @Override
    public BooleanQuery toBooleanQuery(String field, BooleanClause.Occur occur, boolean usePrefixQuery) {
        Assert.isNotNull((Object)field);
        Assert.isNotNull((Object)occur);
        BooleanQuery.Builder qb = new BooleanQuery.Builder();
        for (ArtifactToken token : this.fTokens) {
            Term term = new Term(field, token.term());
            PrefixQuery subQuery = usePrefixQuery ? new PrefixQuery(term) : new TermQuery(term);
            qb = QueryUtils.conditionalAdd(qb, (Query)subQuery, occur);
        }
        return qb.build();
    }
}

