/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common;

import com.ibm.team.fulltext.common.Messages;
import com.ibm.team.repository.common.util.JazzLog;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class IndexConfig {
    private static Log LOGGER = JazzLog.getLog(IndexConfig.class);
    public static final String TEST_PROPERTY_DEFAULT_PATH_HAS_FILES = String.valueOf(IndexConfig.class.getName()) + ".testProp.defaultPathHasFiles";
    public static final String FULLTEXT_INDEX_NAME = "fulltext_index";
    private static boolean useMultipleIndexes = true;
    public static final int OPTIMIZE_INTERVAL = 300;
    public static final int MAX_TOKENS_PER_FIELD = 100000;
    public static final int MAX_TOKEN_LENGTH = 30000;
    private static String fgIndexLocation = null;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final char FILE_SEPARATOR_ESCAPE_CHAR = '_';
    private static String locationDiagnosticMessage = null;
    private static int locationProblemFlag = 0;

    public static synchronized void setIndexBaseLocation(String indexBaseLocation) {
        if (indexBaseLocation == null || System.getProperty("JAZZ_HOME") == null || new File(indexBaseLocation).isAbsolute()) {
            LOGGER.debug((Object)String.format("No need to calculate an absolute path. indexBaseLocation: %s. JAZZ_HOME: %s. isAbsolute: %s", indexBaseLocation, System.getProperty("JAZZ_HOME"), indexBaseLocation != null ? Boolean.valueOf(new File(indexBaseLocation).isAbsolute()) : null));
            fgIndexLocation = indexBaseLocation;
        } else {
            fgIndexLocation = IndexConfig.calculateCorrectAbsolutePath(indexBaseLocation);
        }
        LOGGER.debug((Object)String.format("Set fgIndexLocation to %s", fgIndexLocation));
    }

    public static boolean useMultipleIndexes() {
        return useMultipleIndexes;
    }

    public static void setUseMultipleIndexes(boolean useMultipleIndexes) {
        IndexConfig.useMultipleIndexes = useMultipleIndexes;
    }

    private static String calculateCorrectAbsolutePath(String relativeIndexBaseLocation) {
        boolean useExpectedPath;
        LOGGER.debug((Object)String.format("Calculating an absolute path. relativeIndexBaseLocation: %s", relativeIndexBaseLocation));
        boolean defaultPathIsExpectedPath = IndexConfig.pathsAreSame(IndexConfig.getDefaultPath(relativeIndexBaseLocation), IndexConfig.getExpectedPath(relativeIndexBaseLocation));
        boolean bl = useExpectedPath = defaultPathIsExpectedPath || !IndexConfig.hasFiles(IndexConfig.getDefaultPath(relativeIndexBaseLocation)) && !Boolean.getBoolean(TEST_PROPERTY_DEFAULT_PATH_HAS_FILES);
        if (useExpectedPath) {
            return IndexConfig.getExpectedPath(relativeIndexBaseLocation);
        }
        LOGGER.warn((Object)NLS.bind((String)Messages.getString("IndexConfig.UsingUnexpectedPath"), (Object)IndexConfig.getDefaultPath(relativeIndexBaseLocation), (Object[])new Object[]{IndexConfig.getExpectedPath(relativeIndexBaseLocation)}));
        return IndexConfig.getDefaultPath(relativeIndexBaseLocation);
    }

    private static String getDefaultPath(String relativeIndexBaseLocation) {
        return new File(relativeIndexBaseLocation).getAbsolutePath();
    }

    private static boolean hasFiles(String path) {
        File file = new File(path);
        boolean hasFiles = false;
        File[] files = null;
        if (file.exists() && file.isDirectory()) {
            files = file.listFiles();
            hasFiles = files == null ? false : files.length != 0;
        }
        LOGGER.debug((Object)String.format("hasFiles: %s. path: %s. exists: %s. isDirectory: %s. listFiles: %s", hasFiles, path, file.exists(), file.isDirectory(), files == null ? null : Arrays.asList(files)));
        return hasFiles;
    }

    private static boolean pathsAreSame(String pathString1, String pathString2) {
        String p1 = IndexConfig.getPath(pathString1).toString();
        String p2 = IndexConfig.getPath(pathString2).toString();
        return p1.equals(p2);
    }

    private static IPath getPath(String pathString) {
        String device;
        Path path = new Path(pathString);
        if (IndexConfig.isWindows() && (device = path.getDevice()) != null) {
            path = path.setDevice(path.getDevice().toUpperCase());
        }
        return path;
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    private static String getExpectedPath(String relativeIndexBaseLocation) {
        String jazzHome = System.getProperty("JAZZ_HOME");
        try {
            jazzHome = new File(new URL(jazzHome).toURI()).getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.trace((Object)String.format("Failed to url-decode the value of JAZZ_HOME=\"%s\" - %s", jazzHome, e.getMessage()), (Throwable)e);
        }
        Path jhPath = new Path(jazzHome);
        if (jhPath.lastSegment().equalsIgnoreCase("conf")) {
            String jazzServerPath = jhPath.removeLastSegments(1).toOSString();
            LOGGER.trace((Object)String.format("Removed 'conf' from JAZZ_HOME %s. Result: %s", jazzHome, jazzServerPath));
            LOGGER.trace((Object)String.format("Adding relativeIndexBaseLocation %s to jazzServerPath %s", relativeIndexBaseLocation, jazzServerPath));
            return String.valueOf(jazzServerPath) + FILE_SEPARATOR + relativeIndexBaseLocation;
        }
        LOGGER.error((Object)String.format("JAZZ_HOME is set to an unexpected value. It should be of the form 'JazzInstallDir/server/conf' but it is '%s'", jazzHome));
        return String.valueOf(jazzHome) + FILE_SEPARATOR + relativeIndexBaseLocation;
    }

    public static String getIndexLocation(String type, String indexName, boolean reuseLegacy) {
        Path path;
        String rootIndexLocation;
        locationProblemFlag = 0;
        locationDiagnosticMessage = null;
        String legacyRootIndexLocation = rootIndexLocation = fgIndexLocation;
        String fullTextIndexName = indexName;
        if (fullTextIndexName == null) {
            fullTextIndexName = FULLTEXT_INDEX_NAME;
        }
        if (rootIndexLocation != null) {
            path = new Path(rootIndexLocation);
            rootIndexLocation = path.append(String.valueOf(fullTextIndexName) + "/").toOSString();
        } else {
            legacyRootIndexLocation = rootIndexLocation = System.getProperty("com.ibm.team.repository.db.jdbc.location");
            if (rootIndexLocation != null && new File(rootIndexLocation).isDirectory()) {
                path = new Path(rootIndexLocation);
                path = path.removeTrailingSeparator().removeLastSegments(1);
                rootIndexLocation = path.append(String.valueOf(fullTextIndexName) + "/").toOSString();
            } else {
                legacyRootIndexLocation = rootIndexLocation = System.getProperty("java.io.tmpdir");
                path = new Path(rootIndexLocation);
                rootIndexLocation = path.append(String.valueOf(fullTextIndexName) + "/").toOSString();
            }
        }
        if (!fullTextIndexName.equals(FULLTEXT_INDEX_NAME) && reuseLegacy) {
            File indexBaseDir = new File(rootIndexLocation);
            legacyRootIndexLocation = String.valueOf(legacyRootIndexLocation) + FILE_SEPARATOR + FULLTEXT_INDEX_NAME;
            File legacyIndexBaseDir = new File(legacyRootIndexLocation);
            if (!indexBaseDir.exists() && legacyIndexBaseDir.exists()) {
                locationDiagnosticMessage = NLS.bind((String)Messages.getString("IndexConfig.UsingUnexpectedFullTextIndicesPath"), (Object)legacyRootIndexLocation, (Object[])new Object[]{rootIndexLocation});
                LOGGER.warn((Object)locationDiagnosticMessage);
                rootIndexLocation = legacyRootIndexLocation;
                locationProblemFlag |= 4;
            } else if (indexBaseDir.exists() && legacyIndexBaseDir.exists()) {
                locationDiagnosticMessage = NLS.bind((String)Messages.getString("IndexConfig.MultipleFullTextIndicesFoldersExist"), (Object)legacyRootIndexLocation, (Object[])new Object[]{rootIndexLocation});
                LOGGER.warn((Object)locationDiagnosticMessage);
                locationProblemFlag |= 2;
            }
        }
        if (type != null) {
            if (!useMultipleIndexes) {
                type = "com.ibm.team.fulltext.service.internal.index.SingleIndexType";
            }
            Path rootIndexPath = new Path(rootIndexLocation);
            String indexLocation = rootIndexPath.append(IndexConfig.escape(type)).toOSString();
            LOGGER.debug((Object)String.format("Returning indexLocation %s", indexLocation));
            return indexLocation;
        }
        LOGGER.debug((Object)String.format("Returning rootIndexLocation %s", rootIndexLocation));
        return rootIndexLocation;
    }

    private static String escape(String str) {
        if (str.contains(FILE_SEPARATOR)) {
            int i = 0;
            while (i < FILE_SEPARATOR.length()) {
                str = str.replace(FILE_SEPARATOR.charAt(i), '_');
                ++i;
            }
        }
        return str;
    }

    public static String diagnoseLocation(String indexName) {
        String indexLocation = IndexConfig.getIndexLocation(null, indexName, true);
        File fullPathLocation = new File(indexLocation);
        boolean created = true;
        try {
            if (!fullPathLocation.exists()) {
                created = fullPathLocation.mkdirs();
                File[] list = fullPathLocation.listFiles();
                if (created && list != null && list.length == 0) {
                    fullPathLocation.delete();
                }
            }
        }
        catch (Exception e) {
            locationProblemFlag |= 1;
        }
        if (!created) {
            locationProblemFlag |= 1;
        }
        if ((locationProblemFlag & 1) != 0) {
            return NLS.bind((String)Messages.getString("IndexConfig.FullTextDiagnosticServerInvalidLocation"), (Object)indexLocation, (Object[])new Object[0]);
        }
        if ((locationProblemFlag & 6) != 0) {
            return locationDiagnosticMessage;
        }
        return null;
    }

    public static int getLocationProblemFlag() {
        return locationProblemFlag;
    }
}

