/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common;

import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.StandardTokenTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttributeImpl;
import java.util.EnumSet;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;
import org.apache.lucene.util.BytesRef;
import org.eclipse.core.runtime.Assert;

public class ArtifactToken
extends PackedTokenAttributeImpl
implements FlagsAttribute,
PayloadAttribute {
    private final EnumSet<TokenizerTypes> fTokenizers;
    private int flags;
    private BytesRef payload;
    private final ArtifactToken fCreatedFrom;

    public ArtifactToken() {
        this.fTokenizers = ArtifactAttributeImpl.DEFAULT_TOKENIZER;
        this.fCreatedFrom = null;
    }

    public ArtifactToken(String text, int start, int end) {
        this(text, start, end, null, ArtifactAttributeImpl.DEFAULT_TOKENIZER, null);
    }

    public ArtifactToken(String text, int start, int end, String type) {
        this(text, start, end, type, ArtifactAttributeImpl.DEFAULT_TOKENIZER, null);
    }

    public ArtifactToken(String text, int start, int end, String type, ArtifactToken createdFrom) {
        this(text, start, end, type, ArtifactAttributeImpl.DEFAULT_TOKENIZER, createdFrom);
    }

    public ArtifactToken(String text, int start, int end, String type, EnumSet<TokenizerTypes> tokenizers) {
        this(text, start, end, type, tokenizers, null);
    }

    public ArtifactToken(String text, int start, int end, String type, EnumSet<TokenizerTypes> tokenizers, ArtifactToken createdFrom) {
        this.append(text);
        this.setOffset(start, end);
        if (type == null) {
            this.setType(StandardTokenTypes.WORD.getId());
        } else {
            this.setType(type);
        }
        Assert.isNotNull((Object)text, (String)"The text of the token must not be null!");
        Assert.isNotNull(tokenizers);
        this.fTokenizers = tokenizers;
        this.fCreatedFrom = createdFrom;
    }

    public ArtifactToken getCreatedFrom() {
        return this.fCreatedFrom;
    }

    public boolean applies(TokenizerTypes tokenizer) {
        return this.fTokenizers.contains((Object)tokenizer);
    }

    public ArtifactToken clone(String text, int start, int end) {
        ArtifactToken t = new ArtifactToken(text, start, end, this.type(), this.fTokenizers);
        t.flags = this.flags;
        if (this.payload != null) {
            t.payload = this.payload.clone();
        }
        return t;
    }

    public void copyTo(AttributeImpl target) {
        super.copyTo(target);
        if (target instanceof ArtifactAttributeImpl) {
            ((ArtifactAttributeImpl)target).setTokenizers((EnumSet<TokenizerTypes>)this.fTokenizers.clone());
            ArtifactToken cloneCreatedFrom = this.fCreatedFrom == null ? null : (ArtifactToken)this.fCreatedFrom.clone();
            ((ArtifactAttributeImpl)target).setCreatedFrom(cloneCreatedFrom);
            ((FlagsAttribute)target).setFlags(this.flags);
            ((PayloadAttribute)target).setPayload(this.payload == null ? null : this.payload.clone());
        }
    }

    public void reflectWith(AttributeReflector reflector) {
        super.reflectWith(reflector);
        reflector.reflect(FlagsAttribute.class, "flags", (Object)this.flags);
        reflector.reflect(PayloadAttribute.class, "payload", (Object)this.payload);
    }

    public String term() {
        return super.toString();
    }

    public BytesRef getPayload() {
        return this.payload;
    }

    public void setPayload(BytesRef payload) {
        this.payload = payload;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void clear() {
        super.clear();
        this.flags = 0;
        this.payload = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ArtifactToken) {
            ArtifactToken other = (ArtifactToken)((Object)obj);
            return this.flags == other.flags && (this.payload == null ? other.payload == null : this.payload.equals((Object)other.payload)) && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        int code = super.hashCode();
        code = code * 31 + this.flags;
        if (this.payload != null) {
            code = code * 31 + this.payload.hashCode();
        }
        return code;
    }
}

