/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.client.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.fulltext.client.IClientFullText;
import com.ibm.team.fulltext.client.internal.ArtifactFactoryContribution;
import com.ibm.team.fulltext.client.internal.ArtifactHistoryProvider;
import com.ibm.team.fulltext.client.internal.ClientFullTextImpl;
import com.ibm.team.fulltext.common.IndexConfig;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class FullTextClientPlugin
extends Plugin
implements ExtensionRegistryReaderListener<Object> {
    public static final String ID = "com.ibm.team.fulltext.client";
    private static final String ARTIFACT_FACTORY_EXTENSION_POINT = "artifactFactory";
    private static final String ARTIFACT_FACTORY_ID_ATTRIBUTE = "id";
    static final String ARTIFACT_FACTORY_CLASS_ATTRIBUTE = "class";
    private static FullTextClientPlugin fgPlugin;
    private ExtensionRegistryReader<Object> fExtensionReader;
    private Map<String, ArtifactHistoryProvider> fArtifactProviders = new ConcurrentHashMap<String, ArtifactHistoryProvider>();
    private Map<String, ArtifactFactoryContribution> fArtifactFactories = new ConcurrentHashMap<String, ArtifactFactoryContribution>();
    private ITeamRepositoryService.IRepositoryServiceListener fRepositoryServiceListener;

    public FullTextClientPlugin() {
        fgPlugin = this;
    }

    public static FullTextClientPlugin getDefault() {
        return fgPlugin;
    }

    public static boolean isStopped() {
        return fgPlugin == null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IndexConfig.setIndexBaseLocation((String)this.getStateLocation().makeAbsolute().toOSString());
        this.fExtensionReader = new ExtensionRegistryReader<Object>(ID, ARTIFACT_FACTORY_EXTENSION_POINT){};
        this.fExtensionReader.addListener((ExtensionRegistryReaderListener)this);
        this.fExtensionReader.start();
        FoundationJob job = new FoundationJob(""){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                FullTextClientPlugin.this.hookAllArtifactHistoryProviders();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        this.fExtensionReader.stop();
        this.unhookAllArtifactProviders();
        super.stop(context);
        fgPlugin = null;
    }

    public IClientFullText getClientFullText() {
        return ClientFullTextImpl.fgInstance;
    }

    public void restartFullTextIndexing() {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FullTextClientPlugin.this.unhookAllArtifactProviders();
                FullTextClientPlugin.this.hookAllArtifactHistoryProviders();
            }
        };
        if (Job.getJobManager().currentJob() == null) {
            FoundationJob job = new FoundationJob(""){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    runnable.run();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.schedule();
        } else {
            runnable.run();
        }
    }

    public void handleExtensionAdded(IConfigurationElement element, Object descriptor) throws Exception {
        String id = element.getAttribute(ARTIFACT_FACTORY_ID_ATTRIBUTE);
        this.fArtifactFactories.put(id, new ArtifactFactoryContribution(element));
    }

    public void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
        String id = element.getAttribute(ARTIFACT_FACTORY_ID_ATTRIBUTE);
        this.fArtifactFactories.remove(id);
    }

    private void hookAllArtifactHistoryProviders() {
        ITeamRepository[] repositories;
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.hookArtifactProvider(repository);
            ++n2;
        }
        this.fRepositoryServiceListener = new ITeamRepositoryService.IRepositoryServiceListener(){

            public void addedRepository(ITeamRepository repository) {
                FullTextClientPlugin.this.hookArtifactProvider(repository);
            }

            public void removedRepository(ITeamRepository repository) {
                FullTextClientPlugin.this.unhookArtifactProvider(repository);
            }
        };
        service.addRepositoryServiceListener(this.fRepositoryServiceListener);
    }

    private void hookArtifactProvider(ITeamRepository repository) {
        String repositoryId = repository.getId() != null ? repository.getId().getUuidValue() : null;
        String repositoryURI = repository.getRepositoryURI();
        if (repositoryId == null && repositoryURI == null || repositoryId != null && this.fArtifactProviders.containsKey(repositoryId) || repositoryURI != null && this.fArtifactProviders.containsKey(repositoryURI)) {
            return;
        }
        ArtifactHistoryProvider instance = new ArtifactHistoryProvider(repository, this.getClientFullText(), this.fArtifactFactories);
        if (repositoryId != null) {
            this.fArtifactProviders.put(repositoryId, instance);
        } else {
            this.fArtifactProviders.put(repositoryURI, instance);
        }
    }

    private void unhookArtifactProvider(ITeamRepository repository) {
        String repositoryId = repository.getId() != null ? repository.getId().getUuidValue() : null;
        String repositoryUri = repository.getRepositoryURI();
        if (repositoryId == null && repositoryUri == null) {
            return;
        }
        ArtifactHistoryProvider instance = repositoryId != null ? this.fArtifactProviders.remove(repositoryId) : this.fArtifactProviders.remove(repositoryUri);
        if (instance != null) {
            instance.stop();
        }
    }

    private void unhookAllArtifactProviders() {
        ITeamRepository[] repositories;
        ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
        if (this.fRepositoryServiceListener != null) {
            service.removeRepositoryServiceListener(this.fRepositoryServiceListener);
        }
        ITeamRepository[] iTeamRepositoryArray = repositories = service.getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            this.unhookArtifactProvider(repository);
            ++n2;
        }
    }

    public void log(Throwable e) {
        this.getLog().log((IStatus)new Status(4, ID, e.getLocalizedMessage(), e));
    }

    public void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    public void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }
}

