/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.client.internal;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.client.IClientFullText;
import com.ibm.team.fulltext.client.internal.NoOpContextManagerService;
import com.ibm.team.fulltext.common.FulltextException;
import com.ibm.team.fulltext.common.internal.index.IndexManagerImpl;
import com.ibm.team.fulltext.common.internal.query.IQueryManager;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IContextManagerService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClientFullTextImpl
implements IClientFullText {
    static final IClientFullText fgInstance = new ClientFullTextImpl();
    private static final IContextManagerService NO_OP_CONTEXT_MGR = new NoOpContextManagerService();
    private static final ReentrantReadWriteLock indexRebuildLock = new ReentrantReadWriteLock();

    private ClientFullTextImpl() {
    }

    @Override
    public void index(final Collection<IInformationArtifact> artifacts, final IProgressMonitor monitor) throws FulltextException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
                HashMap mapTypeToModified = new HashMap();
                indexManager.index(artifacts, true, NO_OP_CONTEXT_MGR, mapTypeToModified, monitor);
                indexManager.storeLastIndexedTime(mapTypeToModified);
                return null;
            }
        };
        try {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.runWithIndexRebuild(callable, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void delete(final URIReference reference, final URIReference container, final IProgressMonitor monitor) throws FulltextException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
                indexManager.delete(reference, container, NO_OP_CONTEXT_MGR, monitor);
                indexManager.storeLastIndexedTime(reference.getType(), System.currentTimeMillis());
                return null;
            }
        };
        try {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.runWithIndexRebuild(callable, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public List<IScoredResult> find(String text, String[] scopes, String constrainType, UUID[] owners, boolean sortByDate, IProgressMonitor monitor) throws FulltextException {
        return this.find(text, null, scopes, constrainType, owners, sortByDate, monitor);
    }

    @Override
    public List<IScoredResult> find(String text, String language, String[] scopes, String constrainType, UUID[] owners, boolean sortByDate, IProgressMonitor monitor) throws FulltextException {
        return this.find(text, language, scopes, constrainType, owners, null, sortByDate, monitor);
    }

    @Override
    public List<IScoredResult> find(final String text, final String language, final String[] scopes, final String constrainType, final UUID[] owners, final String[] frontSideUris, final boolean sortByDate, IProgressMonitor monitor) throws FulltextException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return IQueryManager.INSTANCE.find((Collection)Collections.EMPTY_LIST, owners, frontSideUris, text, language, scopes, constrainType, 0, 0, sortByDate, null);
            }
        };
        try {
            Assert.isNotNull((Object)text);
            if (monitor != null && monitor.isCanceled()) {
                List<IScoredResult> list = Collections.emptyList();
                return list;
            }
            List results = (List)this.runWithIndexRebuild(callable, monitor);
            if (results == null) {
                List<IScoredResult> list = Collections.emptyList();
                return list;
            }
            List list = results;
            return list;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public void clear(IProgressMonitor monitor) throws FulltextException {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                IndexManagerImpl.getInstance().clear();
                return null;
            }
        };
        try {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.runWithIndexRebuild(callable, monitor);
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <V> V runWithIndexRebuild(Callable<V> callable, IProgressMonitor monitor) throws FulltextException {
        indexRebuildLock.readLock().lock();
        try {
            block12: {
                int i = 0;
                {
                    if (i <= true) break block12;
                    return null;
                }
            }
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            V v = callable.call();
            return v;
        }
        finally {
            if (indexRebuildLock.isWriteLockedByCurrentThread()) {
                indexRebuildLock.writeLock().unlock();
            } else if (indexRebuildLock.getReadHoldCount() > 0) {
                indexRebuildLock.readLock().unlock();
            }
        }
    }
}

