/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.client.internal;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.fulltext.client.IClientFullText;
import com.ibm.team.fulltext.client.IInformationArtifactFactory;
import com.ibm.team.fulltext.client.internal.ArtifactFactoryContribution;
import com.ibm.team.fulltext.client.internal.FullTextClientPlugin;
import com.ibm.team.fulltext.common.FulltextException;
import com.ibm.team.fulltext.common.model.IInformationArtifact;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.SharedItemChangeEvent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ArtifactHistoryProvider
implements ISharedItemChangeListener {
    public static final Object INDEX_JOB_FAMILY = ArtifactHistoryProvider.class;
    private final IClientFullText fPersonalFullText;
    private final ITeamRepository fRepository;
    private final IndexSubmissionJob fIndexJob;
    private final Map<String, ArtifactFactoryContribution> fArtifactFactories;
    private boolean fIsStopped = false;

    public ArtifactHistoryProvider(ITeamRepository repository, IClientFullText support, Map<String, ArtifactFactoryContribution> artifactFactories) {
        this.fRepository = repository;
        this.fPersonalFullText = support;
        this.fArtifactFactories = artifactFactories;
        this.fIndexJob = new IndexSubmissionJob();
        this.init();
    }

    private void init() {
        IItemType[] itemTypes;
        IItemManager itemManager = this.fRepository.itemManager();
        IItemType[] iItemTypeArray = itemTypes = IItemType.IRegistry.INSTANCE.getAllItemTypes(false);
        int n = itemTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IItemType itemType = iItemTypeArray[n2];
            if (this.shouldIndex(itemType)) {
                List items = itemManager.getKnownSharedItems(itemType);
                if (!items.isEmpty()) {
                    ArrayList<IndexTask> indexTasks = new ArrayList<IndexTask>(items.size());
                    for (IItem item : items) {
                        indexTasks.add(new IndexTask(item, false));
                    }
                    this.fIndexJob.submit(indexTasks);
                }
                itemManager.addItemChangeListener(itemType, (ISharedItemChangeListener)this);
            }
            ++n2;
        }
    }

    public void stop() {
        this.fIsStopped = true;
        Job.getJobManager().cancel(INDEX_JOB_FAMILY);
    }

    public void itemsChanged(List events) {
        if (this.fIsStopped) {
            return;
        }
        ArrayList<IndexTask> items = new ArrayList<IndexTask>(events.size());
        Iterator iter = events.iterator();
        while (iter.hasNext()) {
            if (this.fIsStopped) {
                return;
            }
            SharedItemChangeEvent event = (SharedItemChangeEvent)iter.next();
            IItem item = event.getSharedItem();
            if (!this.shouldIndex(item)) continue;
            if (event.getAfterState() != null) {
                items.add(new IndexTask(item, false));
                continue;
            }
            items.add(new IndexTask(item, true));
        }
        if (!this.fIsStopped) {
            this.fIndexJob.submit(items);
        }
    }

    private boolean shouldIndex(IItem item) {
        return this.shouldIndex(item.getItemType());
    }

    private boolean shouldIndex(IItemType type) {
        return this.shouldIndex(this.toArtifactTypeId(type));
    }

    private boolean shouldIndex(String id) {
        return id != null && this.fArtifactFactories.containsKey(id);
    }

    private String toArtifactTypeId(IItemType type) {
        return String.valueOf(type.getNamespaceURI()) + "." + type.getName();
    }

    private IInformationArtifactFactory getFactory(String id) {
        ArtifactFactoryContribution factory;
        if (id != null && (factory = this.fArtifactFactories.get(id)) != null) {
            return factory.getFactory();
        }
        return null;
    }

    private class IndexSubmissionJob
    extends FoundationJob {
        private ReadWriteLock fQueueLock;
        private List<IndexTask> fIndexingQueue;

        IndexSubmissionJob() {
            super("");
            this.fQueueLock = new ReentrantReadWriteLock();
            this.fIndexingQueue = new LinkedList<IndexTask>();
            this.setUser(false);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return INDEX_JOB_FAMILY.equals(family);
        }

        void submit(List<IndexTask> items) {
            Lock writeLock = this.fQueueLock.writeLock();
            writeLock.lock();
            try {
                this.fIndexingQueue.addAll(items);
                if (!ArtifactHistoryProvider.this.fIsStopped) {
                    this.schedule();
                }
            }
            finally {
                writeLock.unlock();
            }
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            if (this.isCanceled(monitor)) {
                return Status.CANCEL_STATUS;
            }
            ArrayList<IndexTask> tasks = new ArrayList<IndexTask>();
            Lock readLock = this.fQueueLock.readLock();
            readLock.lock();
            try {
                tasks.addAll(this.fIndexingQueue);
            }
            finally {
                readLock.unlock();
            }
            if (this.isCanceled(monitor)) {
                return Status.CANCEL_STATUS;
            }
            ArrayList<IInformationArtifact> submissions = new ArrayList<IInformationArtifact>();
            ArrayList<IInformationArtifact> deletions = new ArrayList<IInformationArtifact>();
            for (IndexTask task : tasks) {
                if (this.isCanceled(monitor)) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    IInformationArtifact artifact;
                    IInformationArtifactFactory factory = ArtifactHistoryProvider.this.getFactory(ArtifactHistoryProvider.this.toArtifactTypeId(task.getItem().getItemType()));
                    if (factory == null || (artifact = factory.create(task.getItem(), task.isDelete(), monitor)) == null) continue;
                    if (task.isDelete()) {
                        deletions.add(artifact);
                        continue;
                    }
                    submissions.add(artifact);
                }
                catch (Exception e) {
                    FullTextClientPlugin.getDefault().log(e);
                }
            }
            if (this.isCanceled(monitor)) {
                return Status.CANCEL_STATUS;
            }
            if (!submissions.isEmpty()) {
                try {
                    ArtifactHistoryProvider.this.fPersonalFullText.index(submissions, monitor);
                }
                catch (FulltextException e) {
                    FullTextClientPlugin.getDefault().log(e);
                    ArtifactHistoryProvider.this.fIsStopped = true;
                }
            }
            if (this.isCanceled(monitor)) {
                return Status.CANCEL_STATUS;
            }
            for (IInformationArtifact artifactToDelete : deletions) {
                try {
                    ArtifactHistoryProvider.this.fPersonalFullText.delete(artifactToDelete.getId(), artifactToDelete.getContainerId(), monitor);
                }
                catch (FulltextException e) {
                    FullTextClientPlugin.getDefault().log(e);
                    ArtifactHistoryProvider.this.fIsStopped = true;
                }
            }
            Lock writeLock = this.fQueueLock.writeLock();
            writeLock.lock();
            try {
                this.fIndexingQueue.removeAll(tasks);
            }
            finally {
                writeLock.unlock();
            }
            return Status.OK_STATUS;
        }

        private boolean isCanceled(IProgressMonitor monitor) {
            return monitor.isCanceled() || FullTextClientPlugin.isStopped() || ArtifactHistoryProvider.this.fIsStopped;
        }
    }

    private class IndexTask {
        private boolean fIsDelete;
        private IItem fItem;

        IndexTask(IItem item, boolean isDelete) {
            this.fItem = item;
            this.fIsDelete = isDelete;
        }

        IItem getItem() {
            return this.fItem;
        }

        boolean isDelete() {
            return this.fIsDelete;
        }
    }
}

