/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.setup.client.internal.registry;

import com.ibm.team.foundation.setup.client.IProjectSetupContribution;
import com.ibm.team.foundation.setup.client.IProjectSetupDelegate;
import com.ibm.team.foundation.setup.client.internal.SetupClientPlugin;
import com.ibm.team.foundation.setup.client.internal.registry.ProjectSetupDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.Status;

public class ProjectSetupDefinitionRegistry {
    private static final String SETUPDEFINITION_EXTENSION_POINT_ID = String.valueOf(SetupClientPlugin.getPluginId()) + ".projectSetupDefinition";
    private static final String SETUPDEFINITION_EXTENSION_NAME = "setupDefinition";
    private static final String SETUPCONTRIBUTION_EXTENSION_POINT_ID = String.valueOf(SetupClientPlugin.getPluginId()) + ".projectSetupContribution";
    private static final String SETUPCONTRIBUTION_EXTENSION_NAME = "setupContribution";
    private static Map<String, DefinitionProxy> fgSetupDefinitions;
    private static final String DEFINITION_ID_ATTRIBUTE = "id";
    private static final String DEFINITION_NAME_ATTRIBUTE = "name";
    private static final String DEFINITION_DESCRIPTION_ATTRIBUTE = "description";
    private static final String DEFINITION_GETTINGSTARTEDHELPHREF_ATTRIBUTE = "gettingStartedHelpHref";
    private static final String DEFINITION_FACTORY_ATTRIBUTE = "factory";
    private static final String CONTRIBUTION_ID_ATTRIBUTE = "id";
    private static final String CONTRIBUTION_DEFINITIONID_ATTRIBUTE = "setupDefinitionId";
    private static final String CONTRIBUTION_FACTORY_ATTRIBUTE = "factory";
    private static final String CONTRIBUTION_SEQUENCENUMBER_ATTRIBUTE = "sequenceNumber";

    public static Collection<String> getAvailableSetupDefinitions() {
        ProjectSetupDefinitionRegistry.initialize();
        return new ArrayList<String>(fgSetupDefinitions.keySet());
    }

    public static ProjectSetupDefinition getSetupDefinition(String id) {
        ProjectSetupDefinitionRegistry.initialize();
        DefinitionProxy proxy = fgSetupDefinitions.get(id);
        if (proxy != null) {
            try {
                return proxy.getSetupDefinition();
            }
            catch (CoreException e) {
                SetupClientPlugin.log(e);
            }
        }
        return null;
    }

    private static synchronized void initialize() {
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IExtension extension;
        int n3;
        int n4;
        IExtension[] iExtensionArray;
        if (fgSetupDefinitions != null) {
            return;
        }
        fgSetupDefinitions = new HashMap<String, DefinitionProxy>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(SETUPDEFINITION_EXTENSION_POINT_ID);
        if (extensionPoint != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    String setupDefinitionId;
                    DefinitionProxy proxy;
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(SETUPDEFINITION_EXTENSION_NAME) && (proxy = fgSetupDefinitions.get(setupDefinitionId = element.getAttribute("id"))) == null) {
                        proxy = new DefinitionProxy(element);
                        fgSetupDefinitions.put(setupDefinitionId, proxy);
                    }
                    ++n;
                }
                ++n3;
            }
        }
        if ((extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(SETUPCONTRIBUTION_EXTENSION_POINT_ID)) != null) {
            iExtensionArray = extensionPoint.getExtensions();
            n4 = iExtensionArray.length;
            n3 = 0;
            while (n3 < n4) {
                extension = iExtensionArray[n3];
                iConfigurationElementArray = extension.getConfigurationElements();
                n2 = iConfigurationElementArray.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().equals(SETUPCONTRIBUTION_EXTENSION_NAME)) {
                        String contributionId = element.getAttribute("id");
                        String setupDefinitionId = element.getAttribute(CONTRIBUTION_DEFINITIONID_ATTRIBUTE);
                        DefinitionProxy proxy = fgSetupDefinitions.get(setupDefinitionId);
                        if (proxy != null) {
                            proxy.addSetupContribution(element);
                        } else {
                            SetupClientPlugin.log((IStatus)new Status(2, SetupClientPlugin.getPluginId(), String.format("Repository setup contribution %s references unknown setup definition %s", contributionId, setupDefinitionId)));
                        }
                    }
                    ++n;
                }
                ++n3;
            }
        }
    }

    private static class DefinitionProxy {
        private final IConfigurationElement fSetupDefinition;
        private final List<IConfigurationElement> fSetupContributionConfigs = new ArrayList<IConfigurationElement>();
        private ProjectSetupDefinition fInstantiatedDefinition;

        public DefinitionProxy(IConfigurationElement setupDefinition) {
            this.fSetupDefinition = setupDefinition;
        }

        public void addSetupContribution(IConfigurationElement element) {
            if (this.fInstantiatedDefinition != null) {
                throw new IllegalStateException("Cant add setup contributions after creation");
            }
            this.fSetupContributionConfigs.add(element);
        }

        public ProjectSetupDefinition getSetupDefinition() throws CoreException {
            if (this.fInstantiatedDefinition == null) {
                String id = this.fSetupDefinition.getAttribute("id");
                String name = this.fSetupDefinition.getAttribute(ProjectSetupDefinitionRegistry.DEFINITION_NAME_ATTRIBUTE);
                String description = this.fSetupDefinition.getAttribute(ProjectSetupDefinitionRegistry.DEFINITION_DESCRIPTION_ATTRIBUTE);
                String gettingStartedHelpHref = this.fSetupDefinition.getAttribute(ProjectSetupDefinitionRegistry.DEFINITION_GETTINGSTARTEDHELPHREF_ATTRIBUTE);
                IProjectSetupDelegate setupDelegate = (IProjectSetupDelegate)this.fSetupDefinition.createExecutableExtension("factory");
                Collections.sort(this.fSetupContributionConfigs, new Comparator<IConfigurationElement>(){

                    @Override
                    public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                        return Integer.parseInt(o1.getAttribute(ProjectSetupDefinitionRegistry.CONTRIBUTION_SEQUENCENUMBER_ATTRIBUTE)) - Integer.parseInt(o2.getAttribute(ProjectSetupDefinitionRegistry.CONTRIBUTION_SEQUENCENUMBER_ATTRIBUTE));
                    }
                });
                LinkedHashMap<String, IProjectSetupContribution> setupContributions = new LinkedHashMap<String, IProjectSetupContribution>();
                for (IConfigurationElement setupContributionConfig : this.fSetupContributionConfigs) {
                    String contributionId = setupContributionConfig.getAttribute("id");
                    IProjectSetupContribution contribution = (IProjectSetupContribution)setupContributionConfig.createExecutableExtension("factory");
                    setupContributions.put(contributionId, contribution);
                }
                this.fInstantiatedDefinition = new ProjectSetupDefinition(id, name, description, gettingStartedHelpHref, setupDelegate, setupContributions);
            }
            return this.fInstantiatedDefinition;
        }
    }
}

