/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.setup.client.internal.registry;

import com.ibm.team.foundation.setup.client.IProjectSetupContribution;
import com.ibm.team.foundation.setup.client.IProjectSetupDelegate;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.core.runtime.Assert;

public class ProjectSetupDefinition {
    private final String fId;
    private final String fName;
    private final String fDescription;
    private final String fGettingStartedHelpHref;
    private final IProjectSetupDelegate fSetupDelegate;
    private final LinkedHashMap<String, IProjectSetupContribution> fSetupContributions;

    public ProjectSetupDefinition(String id, String name, String description, String gettingStartedHelpHref, IProjectSetupDelegate setupDelegate, LinkedHashMap<String, IProjectSetupContribution> setupContributions) {
        Assert.isTrue((id != null && id.trim().length() > 0 ? 1 : 0) != 0);
        Assert.isTrue((name != null && name.trim().length() > 0 ? 1 : 0) != 0);
        this.fId = id;
        this.fName = name;
        this.fDescription = description != null ? description : "";
        this.fGettingStartedHelpHref = gettingStartedHelpHref;
        this.fSetupDelegate = setupDelegate;
        this.fSetupContributions = setupContributions;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getGettingStartedHelpHref() {
        return this.fGettingStartedHelpHref;
    }

    public IProjectSetupDelegate getRepositorySetupDelegate() {
        return this.fSetupDelegate;
    }

    public Collection<IProjectSetupContribution> getRepositorySetupContributions() {
        return Collections.unmodifiableCollection(this.fSetupContributions.values());
    }

    public Collection<String> getRepositorySetupContributionIds() {
        return Collections.unmodifiableCollection(this.fSetupContributions.keySet());
    }
}

