/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.setup.client.builder;

import com.ibm.team.foundation.setup.client.builder.IItemBuilder;
import com.ibm.team.foundation.setup.client.builder.IItemBuilderExtension;
import com.ibm.team.foundation.setup.client.builder.IItemBuiltListener;
import com.ibm.team.foundation.setup.client.builder.Messages;
import com.ibm.team.foundation.setup.client.repository.IPredefinedArtifact;
import com.ibm.team.foundation.setup.client.repository.ISetupContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractItemBuilder<T extends IItem>
implements IItemBuilder<T> {
    private ISetupContext fProjectSetupContext;
    private final ListenerList fBuiltListeners = new ListenerList();
    private Map<Class<? extends IItemBuilderExtension<T>>, IItemBuilderExtension<T>> fBuilderExtensions;
    private IPredefinedArtifact<T> fItemDescriptor;

    public AbstractItemBuilder(ISetupContext projectSetupContext) {
        this.fProjectSetupContext = projectSetupContext;
    }

    @Override
    public <E extends IItemBuilderExtension<T>> E extension(Class<E> extensionClass) {
        IItemBuilderExtension<Object> result;
        if (this.fBuilderExtensions == null) {
            this.fBuilderExtensions = new LinkedHashMap<Class<? extends IItemBuilderExtension<T>>, IItemBuilderExtension<T>>();
        }
        if ((result = this.fBuilderExtensions.get(extensionClass)) == null && (result = this.fProjectSetupContext.createBuilderExtension(extensionClass)) != null) {
            this.fBuilderExtensions.put(extensionClass, result);
        }
        return (E)result;
    }

    @Override
    public void addItemBuiltListener(IItemBuiltListener<T> listener) {
        this.fBuiltListeners.add(listener);
    }

    @Override
    public final T build(IProgressMonitor monitor) throws TeamRepositoryException {
        T result = this.doBuild(monitor);
        this.doPostBuild(result);
        return result;
    }

    protected IItemBuilder<T> setPredefined(IPredefinedArtifact<T> descriptor) {
        this.fItemDescriptor = descriptor;
        return this;
    }

    protected <A> A resolve(IPredefinedArtifact<A> predefinedArtifact) {
        return this.fProjectSetupContext.getArtifact(predefinedArtifact);
    }

    protected void doPostBuild(T result) {
        if (this.fItemDescriptor != null) {
            this.fProjectSetupContext.registerArtifact(this.fItemDescriptor, result);
        }
        this.doNotifyItemBuilt(result);
    }

    protected ISetupContext getProjectSetupContext() {
        return this.fProjectSetupContext;
    }

    protected abstract T doBuild(IProgressMonitor var1) throws TeamRepositoryException;

    protected boolean doApplyExtensions(T item, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            boolean hasExtensions = false;
            if (this.fBuilderExtensions != null) {
                monitor.beginTask(Messages.AbstractItemBuilder_RUNNING_BUILDER_EXTENSIONS, this.fBuilderExtensions.size());
                for (IItemBuilderExtension<T> modifier : this.fBuilderExtensions.values()) {
                    modifier.applyTo(item, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    hasExtensions = true;
                }
            }
            boolean bl = hasExtensions;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    protected String decorateForTVT(String input) {
        if (!this.fProjectSetupContext.createForTVTUse()) {
            return input;
        }
        StringBuilder builder = new StringBuilder("<<");
        return builder.append(input).append(">>").toString();
    }

    protected String decorateHTMLForTVT(String input) {
        if (!this.fProjectSetupContext.createForTVTUse()) {
            return input;
        }
        StringBuilder builder = new StringBuilder("&lt;&lt;");
        return builder.append(input).append("&gt;&gt;").toString();
    }

    private void doNotifyItemBuilt(T item) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fBuiltListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IItemBuiltListener)listener).built(item);
            ++n2;
        }
    }
}

