/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.util;

import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class AccessibleUtils {
    public static void initAccessible(Control controlToInit) {
        final Control control = controlToInit;
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                String name = null;
                Label label = AccessibleUtils.getAssociatedLabel(control);
                if (label != null) {
                    name = AccessibleUtils.stripMnemonic(label.getText());
                }
                event.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent event) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = AccessibleUtils.getAssociatedLabel(control);
                if (label != null && (text = label.getText()) != null && (mnemonic = AccessibleUtils.findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                event.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = control.getToolTipText();
            }
        };
        control.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
    }

    private static Label getAssociatedLabel(Control control) {
        Label label = null;
        Control[] children = control.getParent().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].equals(control) && i > 0) {
                Control sibling = children[i - 1];
                if (!(sibling instanceof Label)) break;
                label = (Label)sibling;
                break;
            }
            ++i;
        }
        return label;
    }

    private static String stripMnemonic(String label) {
        StringBuffer stringBuffer = new StringBuffer(label);
        String labelMinusMnemonic = label;
        int length = label.length();
        int i = 0;
        while (i < length) {
            char currChar = stringBuffer.charAt(i);
            if (currChar == '&') {
                stringBuffer.deleteCharAt(i);
                labelMinusMnemonic = stringBuffer.toString();
                break;
            }
            ++i;
        }
        return labelMinusMnemonic;
    }

    private static char findMnemonic(String label) {
        char mnemonic = '\u0000';
        int length = label.length();
        int i = 0;
        while (i < length) {
            char currChar = label.charAt(i);
            if (currChar == '&') {
                mnemonic = Character.toLowerCase(label.charAt(i + 1));
                break;
            }
            ++i;
        }
        return mnemonic;
    }
}

