/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.dnd;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;

public class URLTransferDragSourceListener
extends DragSourceAdapter
implements TransferDragSourceListener {
    private CreateURLReferencesJob fJob;
    private final ISelectionProvider fProvider;

    public URLTransferDragSourceListener(ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = provider;
    }

    protected ISelection convertSelection(ISelection selection) {
        return selection;
    }

    protected String[] createURLReferences(Object[] elements) {
        Assert.isNotNull((Object)elements);
        ArrayList<String> collection = new ArrayList<String>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)new NullProgressMonitor());
            if (reference != null) {
                collection.add(reference.getURI().toString());
            }
            ++n2;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public void dragFinished(DragSourceEvent event) {
        this.fJob = null;
    }

    public void dragSetData(DragSourceEvent event) {
        if (URLTransfer.getInstance().isSupportedType(event.dataType) && this.fJob != null) {
            try {
                this.fJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String[] references = this.fJob.fetchURLReferences();
            if (references != null && references.length > 0) {
                StringBuilder str = new StringBuilder();
                String[] stringArray = references;
                int n = references.length;
                int n2 = 0;
                while (n2 < n) {
                    String reference = stringArray[n2];
                    str.append(reference).append("\n");
                    ++n2;
                }
                event.data = str.toString();
            } else {
                event.doit = false;
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fProvider.getSelection();
        if (selection != null) {
            boolean result = this.validateSelection(selection);
            if (result) {
                if (!(selection = this.convertSelection(selection)).isEmpty()) {
                    this.fJob = new CreateURLReferencesJob(selection);
                    this.fJob.setSystem(true);
                    this.fJob.setPriority(20);
                    this.fJob.schedule();
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        } else {
            event.doit = false;
        }
    }

    public Transfer getTransfer() {
        return URLTransfer.getInstance();
    }

    protected boolean validateSelection(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        return selection instanceof IStructuredSelection;
    }

    private class CreateURLReferencesJob
    extends FoundationJob {
        private String[] fURLReferences;
        private ISelection fSelection;

        public CreateURLReferencesJob(ISelection selection) {
            super("");
            this.fURLReferences = null;
            this.fSelection = null;
            this.fSelection = selection;
        }

        private String[] computeURLReferences(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                return URLTransferDragSourceListener.this.createURLReferences(((IStructuredSelection)selection).toArray());
            }
            return null;
        }

        public String[] fetchURLReferences() {
            return this.fURLReferences;
        }

        protected IStatus runProtected(IProgressMonitor monitor) {
            this.fURLReferences = this.computeURLReferences(this.fSelection);
            return Status.OK_STATUS;
        }
    }
}

