/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

public class LocalSelectionTransferDragSourceListener
extends DragSourceAdapter
implements TransferDragSourceListener {
    private final ISelectionProvider fProvider;

    public LocalSelectionTransferDragSourceListener(ISelectionProvider provider) {
        Assert.isNotNull((Object)provider);
        this.fProvider = provider;
    }

    protected ISelection convertSelection(ISelection selection) {
        return selection;
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getTransfer().setSelection(null);
    }

    public void dragSetData(DragSourceEvent event) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        if (transfer.isSupportedType(event.dataType)) {
            event.data = transfer.getSelection();
        }
    }

    public void dragStart(DragSourceEvent event) {
        ISelection selection = this.fProvider.getSelection();
        if (selection != null) {
            boolean result = this.validateSelection(selection);
            if (result) {
                if (!(selection = this.convertSelection(selection)).isEmpty()) {
                    LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
                    transfer.setSelection(selection);
                    transfer.setSelectionSetTime((long)(event.time & 0xFFFF));
                } else {
                    event.doit = false;
                }
            } else {
                event.doit = false;
            }
        } else {
            event.doit = false;
        }
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getTransfer();
    }

    protected boolean validateSelection(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        return selection instanceof IStructuredSelection;
    }
}

