/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.internal;

import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.foundation.rcp.core.internal.HyperlinkHandlerRegistry;
import com.ibm.team.repository.common.Location;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenArtifactFromClipboardAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        List<URI> clipboard = this.getClipboardContents();
        if (clipboard.isEmpty()) {
            return;
        }
        StandardContextProvider contextProvider = new StandardContextProvider(null);
        if (this.fWindow != null) {
            contextProvider.setUIContext((Object)this.fWindow.getActivePage());
        }
        for (URI uri : clipboard) {
            boolean hasCustomOpenHandler = HyperlinkHandlerRegistry.getDefault().hasCustomOpenHandler(uri);
            if (hasCustomOpenHandler) {
                Hyperlinks.open((URI)uri, (ContextProvider)contextProvider);
                continue;
            }
            Location location = HyperlinkHandlerRegistry.getDefault().getLocation(uri);
            if (location == null) continue;
            Hyperlinks.open((URI)location.toAbsoluteUri(), (ContextProvider)contextProvider);
        }
    }

    private List<URI> getClipboardContents() {
        TextTransfer transfer;
        if (this.fWindow == null) {
            return Collections.EMPTY_LIST;
        }
        Clipboard cb = new Clipboard(this.fWindow.getShell().getDisplay());
        String data = (String)cb.getContents((Transfer)(transfer = TextTransfer.getInstance()));
        data = data != null ? data.trim() : null;
        cb.dispose();
        if (data == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        StringTokenizer tokenizer = new StringTokenizer(data);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                URL url = new URL(token);
                uris.add(url.toURI());
            }
            catch (MalformedURLException e) {
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uris;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }
}

