/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.dnd;

import com.ibm.team.foundation.common.URIReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class URIReferenceTransfer
extends ByteArrayTransfer {
    private static URIReferenceTransfer fgInstance = new com.ibm.team.foundation.ui.URIReferenceTransfer();
    private static final String REFERENCE_FORMAT = "uri-reference-transfer-format";
    private static final int REFERENCE_FORMAT_ID = URIReferenceTransfer.registerType((String)"uri-reference-transfer-format");
    private static final String TYPE_UNTYPED = "<untyped>";

    public static URIReferenceTransfer getInstance() {
        return fgInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{REFERENCE_FORMAT_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{REFERENCE_FORMAT};
    }

    protected void javaToNative(Object object, TransferData data) {
        if (!(object instanceof URIReference[])) {
            return;
        }
        if (this.isSupportedType(data)) {
            URIReference[] references = (URIReference[])object;
            try {
                byte[] bytes = new byte[]{};
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                try (DataOutputStream dataStream = new DataOutputStream(byteStream);){
                    int index = 0;
                    while (index < references.length) {
                        URIReference reference = references[index];
                        dataStream.writeUTF(reference.getName());
                        dataStream.writeUTF(reference.getDetails());
                        dataStream.writeUTF(reference.getURI().toString());
                        String type = reference.getType();
                        if (type != null) {
                            dataStream.writeUTF(type);
                        } else {
                            dataStream.writeUTF(TYPE_UNTYPED);
                        }
                        ++index;
                    }
                    bytes = byteStream.toByteArray();
                }
                super.javaToNative((Object)bytes, data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Object nativeToJava(TransferData data) {
        URIReference[] result = new URIReference[]{};
        if (this.isSupportedType(data)) {
            byte[] bytes = (byte[])super.nativeToJava(data);
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
            DataInputStream dataStream = new DataInputStream(byteStream);
            try {
                try {
                    ArrayList<URIReference> collection = new ArrayList<URIReference>(4);
                    while (dataStream.available() > 0) {
                        String name = dataStream.readUTF();
                        String details = dataStream.readUTF();
                        String uri = dataStream.readUTF();
                        String type = dataStream.readUTF();
                        boolean untyped = TYPE_UNTYPED.equals(type);
                        if (untyped) {
                            collection.add(new URIReference(name, details, new URI(uri)));
                            continue;
                        }
                        collection.add(new URIReference(name, details, type, new URI(uri)));
                    }
                    result = collection.toArray(new URIReference[collection.size()]);
                }
                catch (IOException iOException) {
                    try {
                        dataStream.close();
                    }
                    catch (IOException iOException2) {
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    try {
                        dataStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                try {
                    dataStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

