/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.rcp.ui.dnd;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.dnd.StandardDelegatingDragAdapter;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DragSupport {
    private final StandardDelegatingDragAdapter fDragAdapter;
    private final DragSource fSource;

    public DragSupport(Control control) {
        this(control, 7);
    }

    public DragSupport(Control control, int operations) {
        Assert.isNotNull((Object)control);
        this.fDragAdapter = new StandardDelegatingDragAdapter(new DragSupportSelectionProvider()){

            @Override
            protected ISelection convertSelection(ISelection selection) {
                return DragSupport.this.convertSelection(selection);
            }

            @Override
            protected URIReference[] createReferences(Object[] elements) {
                return DragSupport.this.createReferences(elements);
            }

            public void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
                DragSupport.this.dragFinished(event);
            }

            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                DragSupport.this.dragStarting(event);
            }

            @Override
            protected boolean validateSelection(ISelection selection) {
                return DragSupport.this.validateSelection(selection);
            }
        };
        this.fSource = new DragSource(control, operations);
        this.fSource.addDragListener((DragSourceListener)this.fDragAdapter);
        this.fSource.setTransfer(this.fDragAdapter.getTransfers());
    }

    protected ISelection convertSelection(ISelection selection) {
        return selection;
    }

    protected URIReference[] createReferences(Object[] elements) {
        Assert.isNotNull((Object)elements);
        ArrayList<URIReference> collection = new ArrayList<URIReference>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            URIReference reference = Hyperlinks.create((Object)element, (IProgressMonitor)new NullProgressMonitor());
            if (reference != null) {
                collection.add(reference);
            }
            ++n2;
        }
        return collection.toArray(new URIReference[collection.size()]);
    }

    protected void dragFinished() {
    }

    protected void dragFinished(DragSourceEvent event) {
        Assert.isNotNull((Object)event);
        this.dragFinished();
    }

    protected void dragStarting() {
    }

    protected void dragStarting(DragSourceEvent event) {
        Assert.isNotNull((Object)event);
        this.dragStarting();
    }

    public final Control getControl() {
        return this.fSource.getControl();
    }

    public final DragSource getDragSource() {
        return this.fSource;
    }

    public ISelection getSelection() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            return page.getSelection();
        }
        return null;
    }

    protected boolean validateSelection(ISelection selection) {
        if (selection == null) {
            return false;
        }
        if (selection.isEmpty()) {
            return false;
        }
        return selection instanceof IStructuredSelection;
    }

    private class DragSupportSelectionProvider
    implements ISelectionProvider {
        private DragSupportSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return DragSupport.this.getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }
}

