/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class StyledDocumentInsertionStrategy
extends ReferenceInsertionStrategy {
    private static StyledDocumentInsertionStrategy fInstance;

    public static StyledDocumentInsertionStrategy getInstance() {
        if (fInstance == null) {
            fInstance = new StyledDocumentInsertionStrategy();
        }
        return fInstance;
    }

    @Override
    public int insert(final URIReference reference, Object element, final IDocument document, final int offset, String replacement) throws CoreException {
        try {
            final String label = reference.getName();
            final int prefixLength = replacement.length();
            if (document instanceof IStyledDocument) {
                document.addPrenotifiedDocumentListener(new IDocumentListener(){

                    public void documentAboutToBeChanged(DocumentEvent event) {
                    }

                    public void documentChanged(DocumentEvent event) {
                        try {
                            document.removePrenotifiedDocumentListener((IDocumentListener)this);
                            ((IStyledDocument)document).setReferencePosition(new ReferencePosition(offset - prefixLength, label.length(), ClientURIUtils.toPublicRepositoryURI((URI)reference.getURI()), false));
                        }
                        catch (BadLocationException x) {
                            FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
                        }
                    }
                });
            }
            document.replace(offset - prefixLength, prefixLength, label);
            return offset - prefixLength + label.length();
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.foundation.ide.ui", e.getLocalizedMessage(), (Throwable)e));
        }
    }
}

