/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationControl;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationInput;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.CompletionProposal;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistMessages;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class ResolvableProposal
extends CompletionProposal {
    private final Object fElement;
    private final ReferenceInsertionStrategy fInsertionStrategy;
    int fNewOffset;

    public ResolvableProposal(String displayString, Image image, Object element, ReferenceInsertionStrategy insertionStrategy) {
        super(displayString, image);
        this.fElement = element;
        this.fInsertionStrategy = insertionStrategy;
    }

    protected void setNewOffset(int newOffset) {
        this.fNewOffset = newOffset;
    }

    protected abstract Object resolve(Object var1, IProgressMonitor var2) throws CoreException;

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        try {
            URIReference[] references = new URIReference[1];
            Object[] elements = new Object[1];
            boolean canceled = false;
            try {
                canceled = this.resolveReferenceFromElement(references, elements);
            }
            catch (InvocationTargetException x) {
                FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
                return;
            }
            catch (InterruptedException x) {
                FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
                return;
            }
            if (canceled) {
                return;
            }
            if (references[0] == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)ContentAssistMessages.ResolvableProposal_ResolvingError_title, (Object)this.getDisplayString()), (String)NLS.bind((String)ContentAssistMessages.ResolvableProposal_ResolvingError_message, (Object)this.getDisplayString()));
                return;
            }
            this.fNewOffset = this.fInsertionStrategy.insert(references[0], elements[0], document, offset, ResolvableProposal.getPrefix(document, offset));
        }
        catch (BadLocationException e) {
            FoundationIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
        catch (CoreException e) {
            FoundationIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
    }

    protected boolean resolveReferenceFromElement(final URIReference[] references, final Object[] elements) throws InvocationTargetException, InterruptedException {
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        final boolean[] canceled = new boolean[1];
        service.busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(NLS.bind((String)ContentAssistMessages.ResolvableProposal_Resloving_progressLabel, (Object)ResolvableProposal.this.getDisplayString()), -1);
                try {
                    Object resolved;
                    elements[0] = resolved = ResolvableProposal.this.resolve(ResolvableProposal.this.fElement, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (monitor.isCanceled()) {
                        canceled[0] = true;
                        return;
                    }
                    references[0] = Hyperlinks.create((Object)resolved, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                    if (monitor.isCanceled()) {
                        canceled[0] = true;
                        return;
                    }
                }
                catch (CoreException x) {
                    FoundationIDEUIPlugin.getDefault().log(x.getMessage(), x);
                }
                finally {
                    monitor.done();
                }
            }
        });
        return canceled[0];
    }

    @Override
    public Point getSelection(IDocument document) {
        return new Point(this.fNewOffset, 0);
    }

    @Override
    public boolean isValidFor(IDocument document, int offset) {
        try {
            String prefix = ResolvableProposal.getPrefix(document, offset);
            String displayString = this.getDisplayString();
            return prefix != null && displayString != null && displayString.toLowerCase().contains(prefix.toLowerCase());
        }
        catch (BadLocationException e) {
            FoundationIDEUIPlugin.getDefault().log(e.getMessage(), e);
            return false;
        }
    }

    @Override
    protected AdditionalInformationInput getAdditionaInformationInput(IProgressMonitor monitor) {
        monitor.beginTask(ContentAssistMessages.ResolvableProposal_AdditionalInfo_progressLabel, -1);
        try {
            Object resolved;
            try {
                resolved = this.resolve(this.fElement, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
            catch (CoreException e) {
                FoundationIDEUIPlugin.getDefault().log(e.getMessage(), e);
                monitor.done();
                return null;
            }
            IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter((Object)resolved);
            if (adapter == null) {
                return null;
            }
            IDomainAdapter.Info info = new IDomainAdapter.Info();
            info.isHoverTooltip = true;
            info.isFocusTooltip = false;
            info.isEmbeddeble = false;
            String hoverText = DomainAdapterUtils.generateContentAsHTML((IDomainAdapter)adapter, (Object)resolved, (IDomainAdapter.Info)info, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            info.isHoverTooltip = false;
            info.isFocusTooltip = true;
            String focusText = DomainAdapterUtils.generateContentAsHTML((IDomainAdapter)adapter, (Object)resolved, (IDomainAdapter.Info)info, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            URIReference reference = Hyperlinks.create((Object)resolved, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            AdditionalInformationControl.ResolvedAdditionalInformationControlInput resolvedAdditionalInformationControlInput = new AdditionalInformationControl.ResolvedAdditionalInformationControlInput(resolved, reference, hoverText, focusText);
            return resolvedAdditionalInformationControlInput;
        }
        finally {
            monitor.done();
        }
    }

    private static String getPrefix(IDocument doc, int offset) throws BadLocationException {
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && !Character.isWhitespace(doc.getChar(offset))) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

