/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AbstractContentAssistProposalComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ResolvableProposal;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesManager;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesNode;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.foundation.rcp.ui.internal.favorites.FavoritesLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class FavoritesProposalComputer
extends AbstractContentAssistProposalComputer {
    private StandardLabelProvider fStandardLabelProvider;
    private final ReferenceInsertionStrategy fInsertionStrategy;

    public FavoritesProposalComputer(ReferenceInsertionStrategy insertionStrategy) {
        this.fInsertionStrategy = insertionStrategy;
    }

    @Override
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        this.collectFavoriteProposals(FavoritesManager.getInstance().getFavorites(), result);
        return this.filter(context, result);
    }

    private void collectFavoriteProposals(FavoritesNode node, ArrayList<ICompletionProposal> result) {
        ViewerLabel label = new ViewerLabel(node.getText(), null);
        this.fStandardLabelProvider.updateLabel(label, (Object)node);
        if (node instanceof FavoritesFolder) {
            List children = ((FavoritesFolder)node).getChildren();
            for (Object object : children) {
                this.collectFavoriteProposals((FavoritesNode)object, result);
            }
        } else {
            try {
                URI uri = FavoritesProposalComputer.getURI(node);
                ITeamRepository teamRepository = ClientURIUtils.findTeamRepository((URI)uri);
                if (teamRepository == null || !teamRepository.loggedIn()) {
                    return;
                }
            }
            catch (CoreException e) {
                FoundationIDEUIPlugin.getDefault().log(e.getLocalizedMessage(), e);
                return;
            }
            result.add(new FavoritesProposal(label.getText(), label.getImage(), node, this.fInsertionStrategy));
        }
    }

    @Override
    public void sessionStarted() {
        super.sessionStarted();
        this.fStandardLabelProvider = new StandardLabelProvider((ILabelProvider)new FavoritesLabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl()){

            public void updateLabel(ViewerLabel label, Object element) {
                URIFavorite favorite;
                super.updateLabel(label, element);
                if (element instanceof URIFavorite && ((favorite = (URIFavorite)element).getText() == null || !favorite.getText().equals(label.getText()))) {
                    favorite.setText(label.getText());
                    FavoritesManager.getInstance().deferredStore();
                }
            }
        };
    }

    @Override
    public void sessionEnded() {
        if (this.fStandardLabelProvider != null) {
            this.fStandardLabelProvider.dispose();
            this.fStandardLabelProvider = null;
        }
        super.sessionEnded();
    }

    private static URI getURI(Object element) throws CoreException {
        if (element instanceof URIFavorite) {
            try {
                return new URI(((URIFavorite)element).getUri());
            }
            catch (URISyntaxException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.foundation.ide.ui", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        IItemHandle handle = ((Favorite)element).getItem();
        Location location = Location.itemLocation((IItemHandle)handle, (String)((String)handle.getOrigin()));
        return location.toAbsoluteUri();
    }

    private static final class FavoritesProposal
    extends ResolvableProposal {
        public FavoritesProposal(String displayString, Image image, Object element, ReferenceInsertionStrategy insertionStrategy) {
            super(displayString, image, element, insertionStrategy);
        }

        @Override
        protected Object resolve(Object element, IProgressMonitor monitor) throws CoreException {
            URI uri = FavoritesProposalComputer.getURI(element);
            return Hyperlinks.resolve((URI)uri, null, (IProgressMonitor)monitor);
        }
    }
}

