/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.IContentAssistProposalsComputer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

public final class ContentAssistProposalCategory {
    private final String fName;
    private String fLastError = null;
    private final IContentAssistProposalsComputer[] fComputers;

    public ContentAssistProposalCategory(String name, IContentAssistProposalsComputer[] computers) {
        this.fName = name;
        this.fComputers = computers;
    }

    public String getName() {
        return this.fName;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context, String partition) {
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        this.fLastError = null;
        int i = 0;
        while (i < this.fComputers.length) {
            IContentAssistProposalsComputer computer = this.fComputers[i];
            List<ICompletionProposal> proposals = computer.computeCompletionProposals(context);
            result.addAll(proposals);
            if (this.fLastError == null) {
                this.fLastError = computer.getErrorMessage();
            }
            ++i;
        }
        return result;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistContext context, String partition, SubProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    public void sessionStarted() {
        int i = 0;
        while (i < this.fComputers.length) {
            IContentAssistProposalsComputer computer = this.fComputers[i];
            computer.sessionStarted();
            if (this.fLastError == null) {
                this.fLastError = computer.getErrorMessage();
            }
            ++i;
        }
    }

    public void sessionEnded() {
        int i = 0;
        while (i < this.fComputers.length) {
            IContentAssistProposalsComputer computer = this.fComputers[i];
            computer.sessionEnded();
            if (this.fLastError == null) {
                this.fLastError = computer.getErrorMessage();
            }
            ++i;
        }
    }
}

