/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistMessages;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistProposalCategory;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class ContentAssistProcessor
implements IContentAssistProcessor {
    private final ContentAssistProposalCategory[] fCategories;
    private final String fPartition;
    private final ContentAssistant fAssistant;
    private char[] fCompletionAutoActivationCharacters;
    private int fRepetition = -1;
    private String fIterationGesture = null;
    private int fNumberOfComputedResults = 0;
    private String fErrorMessage;

    public ContentAssistProcessor(ContentAssistProposalCategory[] categories, ContentAssistant assistant, String partition) {
        Assert.isNotNull((Object)partition);
        Assert.isNotNull((Object)assistant);
        this.fPartition = partition;
        this.fCategories = categories;
        this.fAssistant = assistant;
        this.fAssistant.addCompletionListener((ICompletionListener)new CompletionListener());
    }

    public final ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.clearState();
        ContentAssistContext context = this.createContext(viewer, offset);
        List<ICompletionProposal> proposals = this.collectProposals(viewer, offset, context);
        List<ICompletionProposal> result = this.filterAndSortProposals(proposals);
        this.fNumberOfComputedResults = result.size();
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private List<ICompletionProposal> collectProposals(ITextViewer viewer, int offset, ContentAssistContext context) {
        ContentAssistProposalCategory cat = this.getCategorie();
        List<ICompletionProposal> computed = cat.computeCompletionProposals(context, this.fPartition);
        if (this.fErrorMessage == null) {
            this.fErrorMessage = cat.getErrorMessage();
        }
        return computed;
    }

    protected List<ICompletionProposal> filterAndSortProposals(List<ICompletionProposal> proposals) {
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.clearState();
        IProgressMonitor monitor = this.createProgressMonitor();
        monitor.beginTask(ContentAssistMessages.ContentAssistProcessor_ComputingContexts_progressLabel, 100);
        List<IContextInformation> proposals = this.collectContextInformation(viewer, offset, monitor);
        List<IContextInformation> filtered = this.filterAndSortContextInformation(proposals);
        this.fNumberOfComputedResults = filtered.size();
        IContextInformation[] result = filtered.toArray(new IContextInformation[filtered.size()]);
        monitor.done();
        return result;
    }

    private List<IContextInformation> collectContextInformation(ITextViewer viewer, int offset, IProgressMonitor monitor) {
        ContentAssistContext context = this.createContext(viewer, offset);
        ContentAssistProposalCategory cat = this.getCategorie();
        List<IContextInformation> result = cat.computeContextInformation(context, this.fPartition, new SubProgressMonitor(monitor, 100));
        this.fErrorMessage = cat.getErrorMessage();
        return result;
    }

    protected List<IContextInformation> filterAndSortContextInformation(List<IContextInformation> contexts) {
        return contexts;
    }

    private void clearState() {
        this.fErrorMessage = null;
        this.fNumberOfComputedResults = 0;
    }

    public final void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fCompletionAutoActivationCharacters = activationSet;
    }

    public final char[] getCompletionProposalAutoActivationCharacters() {
        return this.fCompletionAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        if (this.fNumberOfComputedResults > 0) {
            return null;
        }
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        return ContentAssistMessages.ContentAssistProcessor_NoCompletions_message;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }

    protected ContentAssistContext createContext(ITextViewer viewer, int offset) {
        return new ContentAssistContext(viewer, offset);
    }

    private ContentAssistProposalCategory getCategorie() {
        int iteration = this.fRepetition % this.fCategories.length;
        this.fAssistant.setStatusMessage(this.createIterationMessage());
        this.fAssistant.setEmptyMessage(this.createEmptyMessage());
        ++this.fRepetition;
        return this.fCategories[iteration];
    }

    private String createEmptyMessage() {
        return NLS.bind((String)ContentAssistMessages.ContentAssistProcessor_NoCategory_label, (Object)this.getCategoryLabel(this.fRepetition));
    }

    private String createIterationMessage() {
        return NLS.bind((String)ContentAssistMessages.ContentAssistProcessor_CycleAffordance_message, (Object)this.fIterationGesture, (Object)this.getCategoryLabel(this.fRepetition + 1));
    }

    private String getCategoryLabel(int repetition) {
        return this.fCategories[repetition % this.fCategories.length].getName();
    }

    private String getIterationGesture() {
        KeySequence binding = this.getIterationBinding();
        return binding != null ? NLS.bind((String)ContentAssistMessages.ContentAssistProcessor_KeyToCycle_message, (Object)binding.format()) : ContentAssistMessages.ContentAssistProcessor_ClickToCycle_message;
    }

    private KeySequence getIterationBinding() {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence binding = bindingSvc.getBestActiveBindingFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (binding instanceof KeySequence) {
            return (KeySequence)binding;
        }
        return null;
    }

    private final class CompletionListener
    implements ICompletionListener {
        private CompletionListener() {
        }

        public void assistSessionStarted(ContentAssistEvent event) {
            if (event.processor != ContentAssistProcessor.this) {
                return;
            }
            ContentAssistProcessor.this.fIterationGesture = ContentAssistProcessor.this.getIterationGesture();
            KeySequence binding = ContentAssistProcessor.this.getIterationBinding();
            ContentAssistProposalCategory[] contentAssistProposalCategoryArray = ContentAssistProcessor.this.fCategories;
            int n = contentAssistProposalCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentAssistProposalCategory category = contentAssistProposalCategoryArray[n2];
                category.sessionStarted();
                ++n2;
            }
            ContentAssistProcessor.this.fRepetition = 0;
            if (event.assistant instanceof IContentAssistantExtension2) {
                IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                if (ContentAssistProcessor.this.fCategories.length == 1) {
                    extension.setRepeatedInvocationMode(false);
                    extension.setShowEmptyList(false);
                } else {
                    extension.setRepeatedInvocationMode(true);
                    extension.setStatusLineVisible(true);
                    extension.setStatusMessage(ContentAssistProcessor.this.createIterationMessage());
                    extension.setShowEmptyList(true);
                    if (extension instanceof IContentAssistantExtension3) {
                        IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                        ((ContentAssistant)ext3).setRepeatedInvocationTrigger(binding);
                    }
                }
            }
        }

        public void assistSessionEnded(ContentAssistEvent event) {
            if (event.processor != ContentAssistProcessor.this) {
                return;
            }
            ContentAssistProposalCategory[] contentAssistProposalCategoryArray = ContentAssistProcessor.this.fCategories;
            int n = contentAssistProposalCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ContentAssistProposalCategory cat = contentAssistProposalCategoryArray[n2];
                cat.sessionEnded();
                ++n2;
            }
            ContentAssistProcessor.this.fRepetition = -1;
            ContentAssistProcessor.this.fIterationGesture = null;
            if (event.assistant instanceof IContentAssistantExtension2) {
                IContentAssistantExtension2 extension = (IContentAssistantExtension2)event.assistant;
                extension.setShowEmptyList(false);
                extension.setRepeatedInvocationMode(false);
                extension.setStatusLineVisible(false);
                if (extension instanceof IContentAssistantExtension3) {
                    IContentAssistantExtension3 ext3 = (IContentAssistantExtension3)extension;
                    ((ContentAssistant)ext3).setRepeatedInvocationTrigger(null);
                }
            }
        }

        public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        }
    }
}

