/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;

public class ContentAssistContext {
    private final ITextViewer fViewer;
    private final int fOffset;

    public ContentAssistContext(ITextViewer viewer, int offset) {
        this.fViewer = viewer;
        this.fOffset = offset;
    }

    public int getOffset() {
        return this.fOffset;
    }

    public ITextViewer getTextViewer() {
        return this.fViewer;
    }

    public IDocument getDocument() {
        return this.getTextViewer().getDocument();
    }

    public String getPrefix() {
        IDocument doc = this.fViewer.getDocument();
        if (doc == null || this.fOffset > doc.getLength()) {
            return null;
        }
        try {
            int offset = this.fOffset;
            int length = 0;
            while (--offset >= 0 && !Character.isWhitespace(doc.getChar(offset))) {
                ++length;
            }
            return doc.get(offset + 1, length);
        }
        catch (BadLocationException e) {
            FoundationIDEUIPlugin.getDefault().log(e.getMessage(), e);
            return "";
        }
    }
}

