/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AbstractInformationControl;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationInput;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import com.ibm.team.jface.BrowserLocationListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AdditionalInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private static final boolean fIsMac = "carbon".equals(SWT.getPlatform());
    private final boolean fHasFocus;
    private final Shell fParentShell;
    private final StandardContextProvider fContextProvider;
    private Browser fBrowser;
    private StyledText fText;

    public AdditionalInformationControl(Shell parentShell, boolean isResizable) {
        super(parentShell);
        this.fParentShell = parentShell;
        this.fHasFocus = isResizable;
        this.fContextProvider = new StandardContextProvider(null);
        this.fContextProvider.setUIContext((Object)this.fParentShell);
        this.create();
    }

    @Override
    protected void createContent(Composite parent) {
        this.fBrowser = this.createBrowser(parent);
        if (this.fBrowser == null) {
            this.fText = this.createStyledText(parent);
        }
    }

    @Override
    public void setInformation(String information) {
    }

    public void setInput(Object input) {
        String overflow;
        String text;
        Assert.isLegal((boolean)(input instanceof AdditionalInformationInput));
        AdditionalInformationInput aInput = (AdditionalInformationInput)input;
        if (this.fHasFocus) {
            text = aInput.getFocusText();
            overflow = "auto";
        } else {
            text = aInput.getHoverText();
            overflow = "hidden";
        }
        if (this.fBrowser != null) {
            StringBuffer html = new StringBuffer();
            String body = "<body style=\"margin: 1; overflow: " + overflow + "; " + this.getFontAsCSS() + this.getBackgroundAsCSS() + "\">\n";
            String BODY_TAG = "<body>";
            int pos = text.indexOf(BODY_TAG);
            if (pos >= 0) {
                String part1 = text.substring(0, pos);
                String part2 = text.substring(pos + BODY_TAG.length());
                html.append(part1);
                html.append(body);
                html.append(part2);
            } else {
                html.append("<html>\n");
                html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
                html.append(body);
                html.append(text);
                html.append("\n</body></html>\n");
            }
            this.fBrowser.setText(html.toString());
        } else {
            String BODY_TAG = "<body>";
            int bodyStart = text.indexOf(BODY_TAG);
            int bodyEnd = text.indexOf("</body>");
            if (bodyStart >= 0 && bodyEnd >= 0) {
                text = text.substring(bodyStart + BODY_TAG.length(), bodyEnd);
            }
            String plainText = XMLString.createFromXMLText((String)text).getPlainText();
            this.fText.setText(plainText);
        }
        if (aInput instanceof ResolvedAdditionalInformationControlInput) {
            this.fContextProvider.setContext(((ResolvedAdditionalInformationControlInput)aInput).fReference);
        }
    }

    public boolean hasContents() {
        return true;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                return new AdditionalInformationControl(parent, true);
            }
        };
    }

    private Browser createBrowser(Composite parent) {
        try {
            Browser browser = new Browser(parent, 0);
            browser.addLocationListener((LocationListener)new BrowserLocationListener((ContextProvider)this.fContextProvider){

                public void changing(LocationEvent event) {
                    if ("about:blank".equals(event.location)) {
                        return;
                    }
                    super.changing(event);
                    if (!event.doit) {
                        AdditionalInformationControl.this.dispose();
                    }
                }
            });
            browser.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u001b') {
                        AdditionalInformationControl.this.dispose();
                    }
                }
            });
            return browser;
        }
        catch (SWTError e) {
            return null;
        }
    }

    private StyledText createStyledText(Composite parent) {
        StyledText result = new StyledText(parent, 74);
        result.setForeground(this.getForeground());
        result.setBackground(this.getBackground());
        return result;
    }

    private String getBackgroundAsCSS() {
        StringBuffer background = new StringBuffer();
        RGB bgColor = this.getBackground().getRGB();
        background.append("background: rgb(").append(bgColor.red);
        background.append(",").append(bgColor.green).append(",").append(bgColor.blue).append(");");
        return background.toString();
    }

    private String getFontAsCSS() {
        StringBuffer font = new StringBuffer();
        Font defFont = JFaceResources.getDefaultFont();
        font.append("font: ").append(defFont.getFontData()[0].getHeight()).append(fIsMac ? "px" : "pt");
        font.append(" ").append(defFont.getFontData()[0].getName()).append(";");
        return font.toString();
    }

    private Color getBackground() {
        return this.fParentShell.getDisplay().getSystemColor(29);
    }

    private Color getForeground() {
        return this.fParentShell.getDisplay().getSystemColor(28);
    }

    static class ResolvedAdditionalInformationControlInput
    extends AdditionalInformationInput {
        private final URIReference fReference;

        public ResolvedAdditionalInformationControlInput(Object element, URIReference reference, String hoverText, String focusText) {
            super(hoverText, focusText);
            this.fReference = reference;
        }
    }
}

