/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractInformationControl
implements IInformationControl {
    private final Shell fShell;
    private final Composite fContentComposite;
    private Listener fShellListener;
    private ListenerList fFocusListeners = new ListenerList(1);
    private Point fSizeConstraints;

    public AbstractInformationControl(Shell parentShell) {
        int shellStyle = 16388;
        this.fShell = new Shell(parentShell, shellStyle);
        Display display = this.fShell.getDisplay();
        Color foreground = display.getSystemColor(28);
        Color background = display.getSystemColor(29);
        this.fShell.setForeground(foreground);
        this.fShell.setBackground(background);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.fShell.setLayout((Layout)layout);
        this.fContentComposite = new Composite((Composite)this.fShell, 0);
        this.fContentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fContentComposite.setLayout((Layout)new FillLayout());
        this.fContentComposite.setForeground(foreground);
        this.fContentComposite.setBackground(background);
    }

    protected final void create() {
        this.createContent(this.fContentComposite);
    }

    protected abstract void createContent(Composite var1);

    public void setInformation(String information) {
    }

    public void setVisible(boolean visible) {
        if (this.fShell.isVisible() == visible) {
            return;
        }
        this.fShell.setVisible(visible);
    }

    public void dispose() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.dispose();
        }
    }

    public void setSize(int width, int height) {
        this.fShell.setSize(width, height);
    }

    public void setLocation(Point location) {
        this.fShell.setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fSizeConstraints = new Point(maxWidth, maxHeight);
    }

    public Point computeSizeHint() {
        if (this.fSizeConstraints == null) {
            return this.fShell.computeSize(-1, -1, true);
        }
        return this.fShell.computeSize(this.fSizeConstraints.x, this.fSizeConstraints.y, true);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fShell.addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fShell.removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fContentComposite.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fContentComposite.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fShell.getDisplay().getActiveShell() == this.fShell;
    }

    public void setFocus() {
        boolean focusTaken = this.fShell.setFocus();
        if (!focusTaken) {
            this.fShell.forceFocus();
        }
    }

    public void addFocusListener(FocusListener listener) {
        if (this.fFocusListeners.isEmpty()) {
            this.fShellListener = new Listener(){

                public void handleEvent(Event event) {
                    Object[] listeners = AbstractInformationControl.this.fFocusListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        FocusListener focusListener = (FocusListener)listeners[i];
                        if (event.type == 26) {
                            focusListener.focusGained(new FocusEvent(event));
                        } else {
                            focusListener.focusLost(new FocusEvent(event));
                        }
                        ++i;
                    }
                }
            };
            this.fShell.addListener(27, this.fShellListener);
            this.fShell.addListener(26, this.fShellListener);
        }
        this.fFocusListeners.add((Object)listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fFocusListeners.remove((Object)listener);
        if (this.fFocusListeners.isEmpty()) {
            this.fShell.removeListener(26, this.fShellListener);
            this.fShell.removeListener(27, this.fShellListener);
            this.fShellListener = null;
        }
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return null;
    }
}

