/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions;

import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.HandlerUpdater;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.Messages;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.StyledEditingAction;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.StylePosition;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StyleAction
extends StyledEditingAction {
    public static final String BOLD = "com.ibm.magnolia.edit.text.bold";
    public static final String ITALIC = "com.ibm.magnolia.edit.text.italic";
    private int fStyle;

    public StyleAction(String text, int style, String cmdId, ImageDescriptor image) {
        super(text, cmdId, image);
        this.fStyle = style;
    }

    public StyleAction(String text, int style, String cmdId, ImageDescriptor image, IWorkbenchPart part) {
        super(text, cmdId, image, part);
        this.fStyle = style;
    }

    public StyleAction(String text, int style, String cmdId, ImageDescriptor image, ISourceViewer sourceViewer) {
        super(text, cmdId, image, sourceViewer);
        this.fStyle = style;
    }

    public void run() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null || !sourceViewer.isEditable() || !(sourceViewer.getDocument() instanceof IStyledDocument)) {
            return;
        }
        this.styleSelection(sourceViewer);
    }

    private void styleSelection(ISourceViewer sourceViewer) {
        try {
            StylePosition position;
            ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
            if (selection.getLength() == 0) {
                return;
            }
            IStyledDocument document = (IStyledDocument)sourceViewer.getDocument();
            StylePosition[] positions = document.getStylePositions(selection.getOffset(), selection.getLength());
            boolean apply = true;
            int i = 0;
            while (i < positions.length) {
                position = positions[i];
                if ((position.getStyle() & this.fStyle) != 0) {
                    apply = false;
                    break;
                }
                ++i;
            }
            if (apply) {
                document.setStylePosition(new StylePosition(selection.getOffset(), selection.getLength(), this.fStyle));
            }
            if (positions.length > 0) {
                i = 0;
                while (i < positions.length) {
                    position = positions[i];
                    int newStyle = apply ? position.getStyle() | this.fStyle : position.getStyle() & ~this.fStyle;
                    StylePosition newPosition = new StylePosition(position.getOffset(), position.getLength(), newStyle);
                    document.setStylePosition(newPosition);
                    ++i;
                }
            }
            document.replace(document.getLength(), 0, "");
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).invalidateTextPresentation(selection.getOffset(), selection.getLength());
            } else {
                sourceViewer.invalidateTextPresentation();
            }
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
    }

    public static void installBold(SourceViewer sourceViewer, HandlerUpdater handlerUpdater) {
        StyleAction action = new StyleAction(Messages.StyleAction_BOLD, 1, BOLD, AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.foundation.ide.ui", (String)"icons/etool16/bold_co.gif"), (ISourceViewer)sourceViewer);
        handlerUpdater.addAction((IAction)action);
        handlerUpdater.updateInputChanged(action);
        handlerUpdater.updateSelectionChanged(action);
    }

    public static void installItalic(SourceViewer sourceViewer, HandlerUpdater handlerUpdater) {
        StyleAction action = new StyleAction(Messages.StyleAction_ITALIC, 2, ITALIC, AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.foundation.ide.ui", (String)"icons/etool16/italic_co.gif"), (ISourceViewer)sourceViewer);
        handlerUpdater.addAction((IAction)action);
        handlerUpdater.updateInputChanged(action);
        handlerUpdater.updateSelectionChanged(action);
    }
}

