/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import com.ibm.team.foundation.ide.ui.internal.FoundationIDEUIPlugin;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.EditorSupport2;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.Messages;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.StandardContextProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;

public class AnnotationHover
implements IAnnotationHover,
IAnnotationHoverExtension {
    public static final AnnotationHoverType OVERVIEW_RULER_HOVER = new AnnotationHoverType();
    public static final AnnotationHoverType TEXT_RULER_HOVER = new AnnotationHoverType();
    public static final AnnotationHoverType VERTICAL_RULER_HOVER = new AnnotationHoverType();
    private IPreferenceStore fStore = EditorsUI.getPreferenceStore();
    private ContextProvider fContextProvider;
    private AnnotationHoverType fType;

    public AnnotationHover(ContextProvider contextProvider, AnnotationHoverType type) {
        Assert.isTrue((OVERVIEW_RULER_HOVER.equals(type) || TEXT_RULER_HOVER.equals(type) || VERTICAL_RULER_HOVER.equals(type) ? 1 : 0) != 0);
        this.fContextProvider = contextProvider;
        this.fType = type;
    }

    private boolean isRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    private boolean isDuplicateAnnotation(Map messagesAtPosition, Position position, String message) {
        if (messagesAtPosition.containsKey(position)) {
            Object value = messagesAtPosition.get(position);
            if (message.equals(value)) {
                return true;
            }
            if (value instanceof List) {
                List messages = (List)value;
                if (messages.contains(message)) {
                    return true;
                }
                messages.add(message);
            } else {
                ArrayList<Object> messages = new ArrayList<Object>();
                messages.add(value);
                messages.add(message);
                messagesAtPosition.put(position, messages);
            }
        } else {
            messagesAtPosition.put(position, message);
        }
        return false;
    }

    private boolean includeAnnotation(Annotation annotation, Position position, HashMap messagesAtPosition) {
        String key;
        AnnotationPreference preference = this.getAnnotationPreference(annotation);
        if (preference == null) {
            return false;
        }
        if (OVERVIEW_RULER_HOVER.equals(this.fType) ? (key = preference.getOverviewRulerPreferenceKey()) == null || !this.fStore.getBoolean(key) : (TEXT_RULER_HOVER.equals(this.fType) ? ((key = preference.getTextPreferenceKey()) != null ? !this.fStore.getBoolean(key) : (key = preference.getHighlightPreferenceKey()) == null || !this.fStore.getBoolean(key)) : VERTICAL_RULER_HOVER.equals(this.fType) && (key = preference.getVerticalRulerPreferenceKey()) != null && !this.fStore.getBoolean(key))) {
            return false;
        }
        String text = annotation.getText();
        return text != null && !this.isDuplicateAnnotation(messagesAtPosition, position, text);
    }

    private List getAnnotationsForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = this.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashMap messagesAtPosition = new HashMap();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation2 = (Annotation)iterator.next();
            Position position = model.getPosition(annotation2);
            if (position == null || !this.isRulerLine(position, document, line)) continue;
            if (annotation2 instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation2;
                for (Annotation annotation2 : bag) {
                    position = model.getPosition(annotation2);
                    if (position == null || !this.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
                    annotations.add(annotation2);
                }
                continue;
            }
            if (!this.includeAnnotation(annotation2, position, messagesAtPosition)) continue;
            annotations.add(annotation2);
        }
        return annotations;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List annotations = this.getAnnotationsForLine(sourceViewer, lineNumber);
        if (annotations != null) {
            if (annotations.size() == 1) {
                Annotation annotation = (Annotation)annotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (Annotation annotation : annotations) {
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }

    private String formatSingleMessage(String message) {
        return message;
    }

    private String formatMultipleMessages(List messages) {
        StringBuffer buffer = new StringBuffer(Messages.AnnotationHover_MULTIPLE_MARKERS);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            buffer.append("\n- ");
            buffer.append((String)e.next());
        }
        return buffer.toString();
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        return FoundationIDEUIPlugin.getDefault().getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                StandardContextProvider provider = new StandardContextProvider(null, AnnotationHover.this.fContextProvider.getContext());
                provider.setUIContext((Object)parent);
                return new EditorSupport2(parent, (ContextProvider)provider, true, false);
            }
        };
    }

    public boolean canHandleMouseCursor() {
        return false;
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
        return this.getHoverInfo(sourceViewer, lineRange.getStartLine());
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }

    private static class AnnotationHoverType {
        private AnnotationHoverType() {
        }
    }
}

