/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ide.ui.internal.styledtextviewer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ActiveControlTracker {
    private Display fDisplay;
    private Composite fContainer;
    private InternalListener fInternalListener;
    private List<ActiveControlListener> fListeners = new ArrayList<ActiveControlListener>();
    private Control fActiveControl;

    public ActiveControlTracker(Composite container) {
        this.fContainer = container;
        this.fDisplay = this.fContainer.getDisplay();
        this.fInternalListener = new InternalListener();
        this.fDisplay.addFilter(15, (Listener)this.fInternalListener);
        this.fContainer.addDisposeListener((DisposeListener)this.fInternalListener);
    }

    public void addListener(ActiveControlListener listener) {
        Assert.isNotNull((Object)listener);
        this.fListeners.add(listener);
    }

    public void removeListener(ActiveControlListener listener) {
        this.fListeners.remove(listener);
    }

    private void updateActiveControl(Event event) {
        if (event == null || !(event.widget instanceof Control)) {
            return;
        }
        Control control = (Control)event.widget;
        while (control != null && control != this.fContainer) {
            control = control.getParent();
        }
        if (control == this.fContainer && event.widget != this.fActiveControl) {
            this.setActiveControl((Control)event.widget);
        }
    }

    private void setActiveControl(Control newActiveControl) {
        if (this.fActiveControl != null) {
            this.fireDeactivate(this.fActiveControl);
        }
        if (this.fActiveControl != null && !this.fActiveControl.isDisposed()) {
            try {
                this.fActiveControl.removeDisposeListener((DisposeListener)this.fInternalListener);
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
        this.fActiveControl = newActiveControl;
        if (this.fActiveControl != null) {
            this.fActiveControl.addDisposeListener((DisposeListener)this.fInternalListener);
            this.fireActivate(this.fActiveControl);
        }
    }

    private void fireDeactivate(Control control) {
        for (ActiveControlListener listener : this.fListeners) {
            listener.deactivate(control);
        }
    }

    private void fireActivate(Control control) {
        for (ActiveControlListener listener : this.fListeners) {
            listener.activate(control);
        }
    }

    private void dispose() {
        if (this.fDisplay != null) {
            if (!this.fDisplay.isDisposed()) {
                this.fDisplay.removeFilter(15, (Listener)this.fInternalListener);
            }
            this.fDisplay = null;
        }
        if (this.fContainer != null) {
            if (!this.fContainer.isDisposed()) {
                this.fContainer.removeDisposeListener((DisposeListener)this.fInternalListener);
            }
            this.fContainer = null;
        }
        if (this.fActiveControl != null) {
            if (!this.fActiveControl.isDisposed()) {
                this.fActiveControl.removeDisposeListener((DisposeListener)this.fInternalListener);
            }
            this.fActiveControl = null;
        }
        this.fInternalListener = null;
        this.fListeners.clear();
    }

    public static class ActiveControlListener {
        public void activate(Control control) {
        }

        public void deactivate(Control control) {
        }
    }

    private class InternalListener
    implements Listener,
    DisposeListener {
        private InternalListener() {
        }

        public void handleEvent(Event event) {
            ActiveControlTracker.this.updateActiveControl(event);
        }

        public void widgetDisposed(DisposeEvent e) {
            if (e.widget == ActiveControlTracker.this.fContainer) {
                ActiveControlTracker.this.dispose();
            }
            if (e.widget == ActiveControlTracker.this.fActiveControl) {
                ActiveControlTracker.this.setActiveControl(null);
            }
        }
    }
}

