/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.util;

import com.ibm.team.repository.common.AdapterManagerFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;

public final class Adapters {
    private Adapters() {
    }

    public static <T> boolean hasAdapter(Object sourceObject, Class<T> adapterType) {
        IAdaptable adaptable;
        if (adapterType.isInstance(sourceObject)) {
            return true;
        }
        if (AdapterManagerFactory.getAdapterManager().hasAdapter(sourceObject, adapterType.getName())) {
            return true;
        }
        return sourceObject instanceof IAdaptable && (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType) != null;
    }

    public static Object getAdapter(Object sourceObject, String adapterId) {
        if (sourceObject instanceof IAdaptable) {
            try {
                Class<?> toLoad = sourceObject.getClass().getClassLoader().loadClass(adapterId);
                if (toLoad != null) {
                    IAdaptable adaptable = (IAdaptable)sourceObject;
                    Object result = adaptable.getAdapter(toLoad);
                    if (result != null) {
                        return result;
                    }
                    if (adaptable instanceof PlatformObject) {
                        return null;
                    }
                }
            }
            catch (ClassNotFoundException toLoad) {
                // empty catch block
            }
        }
        Object adapter = AdapterManagerFactory.getAdapterManager().loadAdapter(sourceObject, adapterId);
        return adapter;
    }

    public static <T> T getAdapter(Object sourceObject, Class<T> adapter) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        if (sourceObject == null || adapter == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return (T)sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            Assert.isTrue((boolean)adapter.isInstance(result2));
            return (T)result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = AdapterManagerFactory.getAdapterManager().loadAdapter(sourceObject, adapter.getName())) != null) {
            Assert.isTrue((boolean)adapter.isInstance(result));
            return (T)result;
        }
        return null;
    }
}

