/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.treedifferencer;

import com.ibm.team.foundation.common.treedifferencer.ITree;
import com.ibm.team.foundation.common.treedifferencer.TreeEdit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TreeDifference {
    private final List<TreeEdit> fEdits;
    private final Map<ITree, ITree> fMapping;
    private final Map<ITree, TreeEdit> fChanged;
    private final Set<ITree> fAdded;
    private final Set<ITree> fRemoved;
    private final int fCost;

    public TreeDifference(int cost, List<TreeEdit> edits, Map<ITree, ITree> mapping, Set<ITree> added, Set<ITree> removed) {
        this.fEdits = edits;
        this.fCost = cost;
        this.fMapping = mapping;
        this.fAdded = added;
        this.fRemoved = removed;
        this.fChanged = new HashMap<ITree, TreeEdit>();
        for (TreeEdit edit : this.fEdits) {
            if (edit.getOperation() != TreeEdit.Operation.CHANGE) continue;
            this.fChanged.put(edit.getOtherNode(), edit);
        }
    }

    public List<TreeEdit> getEdits() {
        return Collections.unmodifiableList(this.fEdits);
    }

    public Map<ITree, ITree> getMapping() {
        return Collections.unmodifiableMap(this.fMapping);
    }

    public Map<ITree, TreeEdit> getChanged() {
        return Collections.unmodifiableMap(this.fChanged);
    }

    public Set<ITree> getAdded() {
        return Collections.unmodifiableSet(this.fAdded);
    }

    public Set<ITree> getRemoved() {
        return Collections.unmodifiableSet(this.fRemoved);
    }

    public int getCost() {
        return this.fCost;
    }
}

