/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.treedifferencer;

import com.ibm.team.foundation.common.treedifferencer.ICost;
import com.ibm.team.foundation.common.treedifferencer.ITree;
import com.ibm.team.foundation.common.treedifferencer.TreeDifference;
import com.ibm.team.foundation.common.treedifferencer.TreeEdit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeComparator {
    private static final Log LOG = LogFactory.getLog(TreeComparator.class);
    public static final String MAX_BYTES_USED_PROPERTY = String.valueOf(TreeComparator.class.getName()) + ".maxBytesUsed";
    private static final int MAX_BYTES_USED_DEFAULT = 0x6400000;
    private static final int MAX_BYTES_USED_MIN = 0x100000;
    private static int MAX_BYTES_USED = TreeComparator.getInitialMaxBytesUsed();
    private static final long BYTES_USED_CHECK_INTERVAL_DEFAULT = 5000L;
    private static long BYTES_USED_CHECK_INTERVAL = 5000L;
    private final int maxBytesUsed;

    private static void debug(String format, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format(format, args));
        }
    }

    private static int getInitialMaxBytesUsed() {
        String value = System.getProperty(MAX_BYTES_USED_PROPERTY);
        if (value == null) {
            return 0x6400000;
        }
        try {
            return TreeComparator.getValidMaxBytesUsed(Integer.parseInt(value));
        }
        catch (Exception e) {
            return 0x6400000;
        }
    }

    public static void reinitialize() {
        MAX_BYTES_USED = TreeComparator.getInitialMaxBytesUsed();
        BYTES_USED_CHECK_INTERVAL = 5000L;
    }

    private static int getValidMaxBytesUsed(int maxBytesUsedCandidate) {
        if (maxBytesUsedCandidate < 0x100000) {
            return 0x100000;
        }
        return maxBytesUsedCandidate;
    }

    public static int getMaxBytesUsed() {
        return MAX_BYTES_USED;
    }

    public static int setMaxBytesUsed(int maxBytesUsed) {
        int previousMaxBytesUsed = MAX_BYTES_USED;
        MAX_BYTES_USED = TreeComparator.getValidMaxBytesUsed(maxBytesUsed);
        return previousMaxBytesUsed;
    }

    public static long setBytesUsedCheckInterval(long intervalMillis) {
        if (intervalMillis < 0L) {
            throw new IllegalArgumentException("intervalMillis must not be negative");
        }
        long previousIntervalMillis = BYTES_USED_CHECK_INTERVAL;
        BYTES_USED_CHECK_INTERVAL = intervalMillis;
        return previousIntervalMillis;
    }

    public TreeComparator(int maxBytesUsed) {
        this.maxBytesUsed = TreeComparator.getValidMaxBytesUsed(maxBytesUsed);
    }

    public TreeComparator() {
        this(MAX_BYTES_USED);
    }

    public TreeDifference findDifferences(ITree t1, ITree t2, ICost cost) {
        long start = System.currentTimeMillis();
        TreeEditChain[][] treedist = null;
        int iterations = 0;
        try {
            TreeData tree1 = this.preProcess(t1);
            TreeData tree2 = this.preProcess(t2);
            treedist = new TreeEditChain[tree1.nodes.length][tree2.nodes.length];
            SizeChecker sizeChecker = new SizeChecker(this.maxBytesUsed);
            this.checkBytesUsed(treedist, sizeChecker, iterations++);
            long nextCheck = System.currentTimeMillis() + BYTES_USED_CHECK_INTERVAL;
            Integer[] integerArray = tree1.lrKeyroot;
            int n = tree1.lrKeyroot.length;
            int n2 = 0;
            while (n2 < n) {
                Integer i = integerArray[n2];
                Integer[] integerArray2 = tree2.lrKeyroot;
                int n3 = tree2.lrKeyroot.length;
                int n4 = 0;
                while (n4 < n3) {
                    Integer j = integerArray2[n4];
                    this.treedist(treedist, tree1, tree2, i, j, cost);
                    if (System.currentTimeMillis() > nextCheck) {
                        this.checkBytesUsed(treedist, sizeChecker, iterations);
                        nextCheck = System.currentTimeMillis() + BYTES_USED_CHECK_INTERVAL;
                    }
                    ++iterations;
                    ++n4;
                }
                ++n2;
            }
            TreeDifference result = this.getResult(tree1, tree2, treedist);
            long millis = System.currentTimeMillis() - start;
            TreeComparator.debug("findDifferences treedist %s SUCCEEDED in %,d iterations / %,d ms", new Object[]{treedist, iterations, millis});
            return result;
        }
        catch (TooManyBytesUsedException e) {
            long millis = System.currentTimeMillis() - start;
            TreeComparator.debug("findDifferences treedist %s FAILED in %,d iterations / %,d ms", new Object[]{treedist, iterations, millis});
            throw e;
        }
    }

    public void checkBytesUsed(TreeEditChain[][] treedist, SizeChecker checker, int iteration) {
        long start = System.currentTimeMillis();
        try {
            int bytesUsed = checker.checkBytesUsed(treedist);
            long millis = System.currentTimeMillis() - start;
            TreeComparator.debug("checkBytesUsed treedist %s iteration %,d: checked OK (%,d <= %,d) in %,d ms", new Object[]{treedist, iteration, bytesUsed, this.maxBytesUsed, millis});
        }
        catch (TooManyBytesUsedException e) {
            long millis = System.currentTimeMillis() - start;
            TreeComparator.debug("checkBytesUsed treedist %s iteration %,d: check FAILED in %,d ms: %s", new Object[]{treedist, iteration, millis, e});
            throw e;
        }
    }

    private TreeData preProcess(ITree t) {
        ArrayList<ITree> nodes = new ArrayList<ITree>();
        ArrayList<Integer> l = new ArrayList<Integer>();
        ArrayList<Integer> lrRoots = new ArrayList<Integer>();
        this.preProcess(t, 0, nodes, l, lrRoots);
        return new TreeData(nodes.toArray(new ITree[nodes.size()]), l.toArray(new Integer[l.size()]), lrRoots.toArray(new Integer[lrRoots.size()]));
    }

    private int preProcess(ITree n, int depth, List<ITree> nodes, List<Integer> l, List<Integer> lrRoots) {
        int leftMost = -1;
        for (ITree c : n.getChildren()) {
            int i = this.preProcess(c, depth + 1, nodes, l, lrRoots);
            if (leftMost < 0) {
                leftMost = l.get(i);
                continue;
            }
            lrRoots.add(i);
        }
        int nodeIndex = nodes.size();
        if (leftMost < 0) {
            leftMost = nodeIndex;
        }
        if (depth == 0) {
            lrRoots.add(nodeIndex);
        }
        nodes.add(n);
        l.add(leftMost);
        return nodeIndex;
    }

    private void treedist(TreeEditChain[][] treedist, TreeData tree1, TreeData tree2, int i, int j, ICost cost) {
        int m = i - tree1.l[i] + 2;
        int n = j - tree2.l[j] + 2;
        int ioff = tree1.l[i] - 1;
        int joff = tree2.l[j] - 1;
        TreeEditChain[][] forestdist = new TreeEditChain[m][n];
        int i1 = 1;
        while (i1 < m) {
            forestdist[i1][0] = this.anEdit(TreeEdit.Operation.DELETION, tree1.nodes[i1 + ioff], null, cost, forestdist[i1 - 1][0]);
            ++i1;
        }
        int j1 = 1;
        while (j1 < n) {
            forestdist[0][j1] = this.anEdit(TreeEdit.Operation.INSERTION, tree2.nodes[j1 + joff], null, cost, forestdist[0][j1 - 1]);
            ++j1;
        }
        i1 = 1;
        while (i1 < m) {
            int j12 = 1;
            while (j12 < n) {
                if (tree1.l[i1 + ioff].equals(tree1.l[i]) && tree2.l[j12 + joff].equals(tree2.l[j])) {
                    forestdist[i1][j12] = this.min(this.anEdit(TreeEdit.Operation.DELETION, tree1.nodes[i1 + ioff], null, cost, forestdist[i1 - 1][j12]), this.anEdit(TreeEdit.Operation.INSERTION, tree2.nodes[j12 + joff], null, cost, forestdist[i1][j12 - 1]), this.anEdit(TreeEdit.Operation.CHANGE, tree1.nodes[i1 + ioff], tree2.nodes[j12 + joff], cost, forestdist[i1 - 1][j12 - 1]));
                    treedist[i1 + ioff][j12 + joff] = forestdist[i1][j12];
                } else {
                    int p = tree1.l[i1 + ioff] - 1 - ioff;
                    int q = tree2.l[j12 + joff] - 1 - joff;
                    forestdist[i1][j12] = this.min(this.anEdit(TreeEdit.Operation.DELETION, tree1.nodes[i1 + ioff], null, cost, forestdist[i1 - 1][j12]), this.anEdit(TreeEdit.Operation.INSERTION, tree2.nodes[j12 + joff], null, cost, forestdist[i1][j12 - 1]), this.anEdit(TreeEdit.Operation.NO_CHANGE, null, null, cost, forestdist[p][q], treedist[i1 + ioff][j12 + joff]));
                }
                ++j12;
            }
            ++i1;
        }
    }

    private TreeDifference getResult(TreeData tree1, TreeData tree2, TreeEditChain[][] treedist) {
        ArrayList<TreeEdit> edits = new ArrayList<TreeEdit>();
        LinkedList<TreeEditChain> queue = new LinkedList<TreeEditChain>();
        HashMap<ITree, ITree> mapping = new HashMap<ITree, ITree>();
        HashSet<ITree> added = new HashSet<ITree>();
        HashSet<ITree> removed = new HashSet<ITree>();
        queue.add(treedist[tree1.nodes.length - 1][tree2.nodes.length - 1]);
        while (!queue.isEmpty()) {
            TreeEditChain editChain = (TreeEditChain)queue.pop();
            TreeEdit edit = editChain.fEdit;
            TreeEdit.Operation operation = edit.getOperation();
            if (operation != TreeEdit.Operation.NO_CHANGE) {
                edits.add(0, edit);
            }
            if (operation == TreeEdit.Operation.INSERTION) {
                added.add(edit.getNode());
            }
            if (operation == TreeEdit.Operation.DELETION) {
                removed.add(edit.getNode());
            }
            if (edit.getNode() != null && edit.getOtherNode() != null) {
                mapping.put(edit.getOtherNode(), edit.getNode());
            }
            TreeEditChain[] treeEditChainArray = editChain.fPredecessors;
            int n = treeEditChainArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeEditChain e = treeEditChainArray[n2];
                if (e != null) {
                    queue.add(0, e);
                }
                ++n2;
            }
        }
        return new TreeDifference(treedist[tree1.nodes.length - 1][tree2.nodes.length - 1].fCost, edits, mapping, added, removed);
    }

    private TreeEditChain min(TreeEditChain ... a) {
        TreeEditChain smallest = a[0];
        int i = 1;
        while (i < a.length) {
            if (smallest.fCost > a[i].fCost) {
                smallest = a[i];
            }
            ++i;
        }
        return smallest;
    }

    private TreeEditChain anEdit(TreeEdit.Operation op, ITree node1, ITree node2, ICost cost, TreeEditChain ... predecessors) {
        int c = 0;
        switch (op) {
            case CHANGE: {
                c = cost.change(node1, node2);
                if (c != 0) break;
                op = TreeEdit.Operation.NO_CHANGE;
                break;
            }
            case DELETION: {
                c = cost.deletion(node1);
                break;
            }
            case INSERTION: {
                c = cost.insertion(node1);
                break;
            }
        }
        return new TreeEditChain(new TreeEdit(op, node1, node2), c, predecessors);
    }

    private static class SizeChecker {
        private static final int BYTES_PER_CHAIN = 60;
        private final int byteCountLimit;
        private int byteCount;
        private Set<TreeEditChain[]> arraysSeen;
        private Set<TreeEditChain> chainsSeen;
        private Queue<TreeEditChain[]> arrayQueue;

        private static int getShallowBytesUsed(Object[] array) {
            return 8 + 8 * array.length;
        }

        public SizeChecker(int byteCountLimit) {
            this.byteCountLimit = byteCountLimit;
        }

        public int checkBytesUsed(TreeEditChain[][] arrays) {
            this.byteCount = 0;
            try {
                this.addBytes(SizeChecker.getShallowBytesUsed((Object[])arrays));
                if (this.arraysSeen == null) {
                    this.arraysSeen = Collections.newSetFromMap(new IdentityHashMap(arrays.length * arrays[0].length));
                    this.chainsSeen = Collections.newSetFromMap(new IdentityHashMap(arrays.length * arrays[0].length));
                    this.arrayQueue = new LinkedList<TreeEditChain[]>();
                }
                TreeEditChain[][] treeEditChainArray = arrays;
                int n = arrays.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeEditChain[] array = treeEditChainArray[n2];
                    this.process(array);
                    while (!this.arrayQueue.isEmpty()) {
                        this.process(this.arrayQueue.remove());
                    }
                    ++n2;
                }
            }
            finally {
                this.arraysSeen = null;
                this.chainsSeen = null;
                this.arrayQueue = null;
            }
            return this.byteCount;
        }

        private void addBytes(int byteCountIncrement) {
            this.byteCount += byteCountIncrement;
            if (this.byteCount > this.byteCountLimit) {
                throw new TooManyBytesUsedException(this.byteCount, this.byteCountLimit);
            }
        }

        private void process(TreeEditChain[] array) {
            if (array != null && this.arraysSeen.add(array)) {
                this.addBytes(SizeChecker.getShallowBytesUsed(array));
                TreeEditChain[] treeEditChainArray = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeEditChain chain = treeEditChainArray[n2];
                    if (chain != null && this.chainsSeen.add(chain)) {
                        this.addBytes(60);
                        if (chain.fPredecessors != null && !this.arraysSeen.contains(chain.fPredecessors)) {
                            this.arrayQueue.add(chain.fPredecessors);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public static class TooManyBytesUsedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public TooManyBytesUsedException(int bytesUsed, int bytesUsedLimit) {
            super(String.format("Bytes used exceeds limit: %,d > %,d", bytesUsed, bytesUsedLimit));
        }
    }

    private static class TreeData {
        public final ITree[] nodes;
        public final Integer[] l;
        public final Integer[] lrKeyroot;

        public TreeData(ITree[] tree, Integer[] l, Integer[] lrKeyroot) {
            this.nodes = tree;
            this.l = l;
            this.lrKeyroot = lrKeyroot;
        }
    }

    private static class TreeEditChain {
        private final TreeEditChain[] fPredecessors;
        private final TreeEdit fEdit;
        private final int fCost;

        public TreeEditChain(TreeEdit edit, int cost, TreeEditChain ... predecessor) {
            this.fPredecessors = predecessor;
            this.fEdit = edit;
            TreeEditChain[] treeEditChainArray = predecessor;
            int n = predecessor.length;
            int n2 = 0;
            while (n2 < n) {
                TreeEditChain p = treeEditChainArray[n2];
                if (p != null) {
                    cost += p.fCost;
                }
                ++n2;
            }
            this.fCost = cost;
        }
    }
}

