/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.text;

import com.ibm.team.foundation.common.internal.text.HTML2TextReader;
import com.ibm.team.foundation.common.internal.text.SubstitutionTextReader;
import java.util.HashSet;
import java.util.Set;

public abstract class HTMLSubstitutionHandler {
    private static final String EMPTY_STRING = "";
    private static final Set<String> fgTags = new HashSet<String>();
    private final boolean fPreserveWhiteSpace;
    private boolean fInParagraph = false;
    private boolean fIsPreformattedText = false;
    private boolean fConvertRichTextToLowerCase = true;
    private long fCurrentIndex = -1L;

    static {
        fgTags.add("b");
        fgTags.add("strong");
        fgTags.add("i");
        fgTags.add("em");
        fgTags.add("br");
        fgTags.add("h5");
        fgTags.add("p");
        fgTags.add("dl");
        fgTags.add("dt");
        fgTags.add("dd");
        fgTags.add("li");
        fgTags.add("ul");
        fgTags.add("pre");
        fgTags.add("a");
        fgTags.add("div");
        fgTags.add("span");
        fgTags.add("table");
        fgTags.add("tr");
        fgTags.add("td");
        fgTags.add("th");
        fgTags.add("caption");
        fgTags.add("hr");
        fgTags.add("img");
    }

    public HTMLSubstitutionHandler(boolean preserveWhiteSpace) {
        this.fPreserveWhiteSpace = preserveWhiteSpace;
    }

    public boolean preserveWhiteSpace() {
        return this.fPreserveWhiteSpace || this.fIsPreformattedText;
    }

    public void setCurrentIndex(long index) {
        this.fCurrentIndex = index;
    }

    public String substituteHtml(String html) {
        boolean start;
        String tag = HTML2TextReader.tagName(html);
        boolean bl = start = !html.equals("/" + tag);
        if (!fgTags.contains(tag)) {
            return EMPTY_STRING;
        }
        if ("pre".equals(tag)) {
            this.fIsPreformattedText = start;
        }
        if (this.fIsPreformattedText) {
            return EMPTY_STRING;
        }
        if ("h5".equals(tag) || "dt".equals(tag)) {
            if (start) {
                return EMPTY_STRING;
            }
            return SubstitutionTextReader.LINE_DELIM;
        }
        if ("br".equals(tag)) {
            if (start) {
                return SubstitutionTextReader.LINE_DELIM;
            }
            return EMPTY_STRING;
        }
        if ("dd".equals(tag)) {
            if (start) {
                return "\t";
            }
            return SubstitutionTextReader.LINE_DELIM;
        }
        if ("li".equals(tag) && start) {
            return String.valueOf(SubstitutionTextReader.LINE_DELIM) + "\t-";
        }
        if ("dl".equals(tag) && start) {
            return SubstitutionTextReader.LINE_DELIM;
        }
        if ("p".equals(tag) || "div".equals(tag)) {
            if (start) {
                this.fInParagraph = true;
                return this.fCurrentIndex == 3L && "p".equals(tag) ? EMPTY_STRING : SubstitutionTextReader.LINE_DELIM;
            }
            boolean inParagraph = this.fInParagraph;
            this.fInParagraph = false;
            return inParagraph ? EMPTY_STRING : SubstitutionTextReader.LINE_DELIM;
        }
        if ((tag.equals("td") || tag.equals("th")) && start) {
            return "\t";
        }
        if ((tag.equals("tr") || tag.equals("caption")) && start) {
            return SubstitutionTextReader.LINE_DELIM;
        }
        if ("table".equals(tag) && !start) {
            return SubstitutionTextReader.LINE_DELIM;
        }
        if ("hr".equals(tag) && start) {
            return SubstitutionTextReader.LINE_DELIM;
        }
        if ("img".equals(tag) && start) {
            String altText = HTML2TextReader.getAttribute(html, "alt");
            return altText == null || altText.isEmpty() ? SubstitutionTextReader.LINE_DELIM : String.valueOf(SubstitutionTextReader.LINE_DELIM) + altText + SubstitutionTextReader.LINE_DELIM;
        }
        return EMPTY_STRING;
    }

    protected boolean isPreformattedText() {
        return this.fIsPreformattedText;
    }

    public boolean allowLowerCaseRichText() {
        return this.fConvertRichTextToLowerCase;
    }
}

