/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal.util;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.IQueryPage;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ItemQueryIterator<T> {
    private final IQueryService fQueryService;
    private IItemQueryPage fCurrentPage;
    private Iterator<T> fResultIterator;

    public ItemQueryIterator(IQueryService queryService, IItemQuery itemQuery, Object[] parameters) throws TeamRepositoryException {
        this(queryService, itemQuery, parameters, 512);
    }

    public ItemQueryIterator(IQueryService queryService, IItemQuery itemQuery, Object[] parameters, int pageSize) throws TeamRepositoryException {
        this.fQueryService = queryService;
        this.fCurrentPage = this.fQueryService.queryItems(itemQuery, parameters, pageSize);
        this.fResultIterator = this.fCurrentPage.getItemHandles().iterator();
    }

    public boolean hasNext() throws TeamRepositoryException {
        return this.fResultIterator != null && this.fResultIterator.hasNext() || this.fetchNextPage();
    }

    public T next() throws TeamRepositoryException {
        return this.hasNext() ? (T)this.fResultIterator.next() : null;
    }

    private boolean fetchNextPage() throws TeamRepositoryException {
        if (this.fCurrentPage == null) {
            return false;
        }
        if (this.fCurrentPage.hasNext()) {
            this.fCurrentPage = (IItemQueryPage)this.fQueryService.fetchNextPage((IQueryPage)this.fCurrentPage);
            this.fResultIterator = this.fCurrentPage.getItemHandles().iterator();
        } else {
            this.fResultIterator = null;
            this.fCurrentPage = null;
        }
        return this.hasNext();
    }

    public List<T> getAllItems() throws TeamRepositoryException {
        ArrayList<T> result = new ArrayList<T>();
        while (this.hasNext()) {
            result.add(this.next());
        }
        return result;
    }
}

