/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal.text;

import com.ibm.team.foundation.common.internal.text.SubstitutionTextReader;
import com.ibm.team.foundation.common.text.HTMLHandler;
import com.ibm.team.foundation.common.text.XMLString;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTML2TextReader
extends SubstitutionTextReader {
    private static final String RGB_PATTERN = "rgb *\\( *([0-9]+), *([0-9]+), *([0-9]+) *\\)";
    public static final boolean PRESERVE_WHITE_SPACE = Boolean.toString(true).equals(System.getProperty("com.ibm.team.foundation.common.behavior.preserveWhitespace"));
    private static final Object FOREGROUND = new Object();
    private static final Object BACKGROUND = new Object();
    private static final Object FOREGROUND_BACKGROUND = new Object();
    private static final Object FONT_FAMILY = new Object();
    private static final Object FONT_SIZE = new Object();
    private static final String EMPTY_STRING = "";
    private static final Map<String, String> fgEntityLookup = new HashMap<String, String>(7);
    private final List<Object> fSpanPropertyKeyStack = new ArrayList<Object>();
    private final List<Object> fSpanPropertyValueStack = new ArrayList<Object>();
    private final HTMLHandler fHandler;
    protected int fCurrentIndex = 0;
    private int fBold = 0;
    private int fItalic = 0;
    private int fHyperlink = 0;
    private StringBuffer fBuffer;
    private static Pattern fgPattern;

    static {
        fgEntityLookup.put("lt", "<");
        fgEntityLookup.put("gt", ">");
        fgEntityLookup.put("nbsp", " ");
        fgEntityLookup.put("amp", "&");
        fgEntityLookup.put("circ", "^");
        fgEntityLookup.put("tilde", "~");
        fgEntityLookup.put("quot", "\"");
        fgEntityLookup.put("apos", "'");
        fgEntityLookup.put("para", "\u00b6");
    }

    protected HTML2TextReader(Reader reader, HTMLHandler handler) {
        super(new PushbackReader(reader));
        this.fHandler = handler;
    }

    protected void startBold() {
        ++this.fBold;
        if (this.fBold == 1) {
            this.styleChanged(1);
        }
    }

    protected void stopBold() {
        if (this.fBold == 1) {
            this.styleAboutToChange(1);
        }
        --this.fBold;
    }

    protected void startItalic() {
        ++this.fItalic;
        if (this.fItalic == 1) {
            this.styleChanged(2);
        }
    }

    protected void stopItalic() {
        if (this.fItalic == 1) {
            this.styleAboutToChange(2);
        }
        --this.fItalic;
    }

    protected void startSpan(Object foregroundColor, Object backgroundColor) {
        this.startSpan(foregroundColor, backgroundColor, null, null);
    }

    protected void startSpan(Object foregroundColor, Object backgroundColor, String fontFamily, String fontSize) {
        this.styleAboutToChange(0);
        if (foregroundColor != null && backgroundColor != null) {
            this.fSpanPropertyKeyStack.add(FOREGROUND_BACKGROUND);
            this.fSpanPropertyValueStack.add(new Object[]{foregroundColor, backgroundColor});
        } else {
            if (foregroundColor != null) {
                this.fSpanPropertyKeyStack.add(FOREGROUND);
                this.fSpanPropertyValueStack.add(foregroundColor);
            }
            if (backgroundColor != null) {
                this.fSpanPropertyKeyStack.add(BACKGROUND);
                this.fSpanPropertyValueStack.add(backgroundColor);
            }
        }
        if (fontFamily != null) {
            this.fSpanPropertyKeyStack.add(FONT_FAMILY);
            this.fSpanPropertyValueStack.add(fontFamily);
        }
        if (fontSize != null) {
            this.fSpanPropertyKeyStack.add(FONT_SIZE);
            this.fSpanPropertyValueStack.add(fontSize);
        }
        this.styleChanged(0);
    }

    protected void stopSpan() {
        this.styleAboutToChange(0);
        this.flushTextBuffer();
        this.fSpanPropertyKeyStack.clear();
        this.fSpanPropertyValueStack.clear();
        this.styleChanged(0);
    }

    private void styleAboutToChange(int currentStyle) {
        this.styleChange(true, currentStyle);
    }

    private void styleChanged(int newStyle) {
        this.styleChange(false, newStyle);
    }

    private void styleChange(boolean aboutToChange, int fontStyle) {
        int[] foreground = null;
        int[] background = null;
        String fontFamily = null;
        String fontSize = null;
        int i = 0;
        int n = this.fSpanPropertyKeyStack.size();
        while (i < n) {
            if (this.fSpanPropertyKeyStack.get(i) == FOREGROUND) {
                foreground = (int[])this.fSpanPropertyValueStack.get(i);
            } else if (this.fSpanPropertyKeyStack.get(i) == BACKGROUND) {
                background = (int[])this.fSpanPropertyValueStack.get(i);
            } else if (this.fSpanPropertyKeyStack.get(i) == FOREGROUND_BACKGROUND) {
                Object[] combined = (Object[])this.fSpanPropertyValueStack.get(i);
                foreground = (int[])combined[0];
                background = (int[])combined[1];
            } else if (this.fSpanPropertyKeyStack.get(i) == FONT_FAMILY) {
                fontFamily = (String)this.fSpanPropertyValueStack.get(i);
            } else if (this.fSpanPropertyKeyStack.get(i) == FONT_SIZE) {
                fontSize = (String)this.fSpanPropertyValueStack.get(i);
            }
            ++i;
        }
        if (foreground != null || background != null || fontStyle != 0 || fontFamily != null || fontSize != null) {
            this.flushTextBuffer();
            if (aboutToChange) {
                this.fHandler.endStyle();
            } else {
                this.fHandler.beginStyle(foreground, background, fontStyle, fontFamily, fontSize);
            }
        }
    }

    protected void startHyperlink(String reference) {
        if (this.fHyperlink == 0) {
            this.flushTextBuffer();
            this.hyperlinkStarted(reference);
        }
        ++this.fHyperlink;
    }

    protected void stopHyperlink() {
        if (this.fHyperlink == 1) {
            this.flushTextBuffer();
            this.hyperlinkEnded();
        }
        --this.fHyperlink;
    }

    protected void hyperlinkStarted(String reference) {
        this.fHandler.beginReference(reference);
    }

    protected void hyperlinkEnded() {
        this.fHandler.endReference();
    }

    @Override
    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processHTMLTag();
        }
        if (c == 38) {
            return this.processEntity();
        }
        if (Character.isWhitespace((char)c) && !this.fHandler.preserveWhiteSpace()) {
            while (Character.isWhitespace((char)c)) {
                c = this.nextChar();
            }
            if (c != -1) {
                this.unread(c);
            }
            return " ";
        }
        return null;
    }

    private String html2Text(String html) {
        String orig = html;
        if ((html = orig.toLowerCase()) == null || html.length() == 0) {
            return EMPTY_STRING;
        }
        String tag = HTML2TextReader.tagName(html);
        if ("img".equals(tag) && !this.fHandler.allowLowerCaseRichText()) {
            String altReference = HTML2TextReader.getAttribute(orig, "alt");
            String srcReference = HTML2TextReader.getAttribute(orig, "src");
            String onerrorValue = HTML2TextReader.getAttribute(orig, "onerror");
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("img alt=\"");
            strBuf.append(altReference != null ? altReference : EMPTY_STRING);
            strBuf.append("\" src=\"");
            strBuf.append(srcReference);
            strBuf.append("\"");
            if (onerrorValue != null) {
                strBuf.append(" onerror=\"");
                strBuf.append(onerrorValue);
                strBuf.append("\"");
            }
            strBuf.append(" /");
            html = strBuf.toString();
            this.flushTextBuffer();
            this.fHandler.setCurrentIndex(this.fCurrentIndex);
            return this.fHandler.substituteHtml(html);
        }
        if ("a".equals(tag) && html.charAt(0) != '/' && html.charAt(html.length() - 1) != '/') {
            String reference = HTML2TextReader.getAttribute(orig, "href");
            this.startHyperlink(reference != null ? reference : EMPTY_STRING);
            return this.fHandler.substituteHtml(html);
        }
        if ("/a".equals(html)) {
            this.stopHyperlink();
            return this.fHandler.substituteHtml(html);
        }
        if ("span".equals(tag) && html.charAt(0) != '/' && html.charAt(html.length() - 1) != '/') {
            int[] foregroundColor = null;
            int[] backgroundColor = null;
            String fontFamily = null;
            String fontSize = null;
            Map<String, String> styleMap = HTML2TextReader.parseStyles(html);
            String styleString = styleMap.get("color");
            if (styleString != null) {
                foregroundColor = this.parseRGB(styleString);
            }
            if ((styleString = styleMap.get("background-color")) != null) {
                backgroundColor = this.parseRGB(styleString);
            }
            if ((styleString = styleMap.get("font-family")) != null) {
                fontFamily = styleString;
            }
            if ((styleString = styleMap.get("font-size")) != null) {
                fontSize = styleString;
            }
            if (foregroundColor != null || backgroundColor != null || fontFamily != null || fontSize != null) {
                this.startSpan(foregroundColor, backgroundColor, fontFamily, fontSize);
            }
            this.flushTextBuffer();
            return this.fHandler.substituteHtml(html);
        }
        if ("/span".equals(html)) {
            this.stopSpan();
            return this.fHandler.substituteHtml(html);
        }
        if ("b".equals(html) || "strong".equals(html)) {
            this.startBold();
            return this.fHandler.substituteHtml(html);
        }
        if ("/b".equals(html) || "/strong".equals(html)) {
            this.stopBold();
            return this.fHandler.substituteHtml(html);
        }
        if ("i".equals(html) || "em".equals(html)) {
            this.startItalic();
            return this.fHandler.substituteHtml(html);
        }
        if ("/i".equals(html) || "/em".equals(html)) {
            this.stopItalic();
            return this.fHandler.substituteHtml(html);
        }
        if ("h5".equals(html) || "dt".equals(html)) {
            this.startBold();
            return this.fHandler.substituteHtml(html);
        }
        if ("/h5".equals(html) || "/dt".equals(html)) {
            this.stopBold();
            return this.fHandler.substituteHtml(html);
        }
        this.flushTextBuffer();
        this.fHandler.setCurrentIndex(this.fCurrentIndex);
        return this.fHandler.substituteHtml(html);
    }

    private int[] parseRGB(String colorString) {
        int start;
        if (colorString.startsWith("rgb(") && colorString.endsWith(")")) {
            Matcher matcher;
            if (fgPattern == null) {
                fgPattern = Pattern.compile(RGB_PATTERN);
            }
            if ((matcher = fgPattern.matcher(colorString)).matches()) {
                return new int[]{Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))};
            }
        }
        if ((start = colorString.indexOf(35)) >= 0) {
            colorString = colorString.substring(start + 1);
        }
        if (colorString.length() < 6) {
            return null;
        }
        int[] rgb = new int[3];
        try {
            rgb[0] = Integer.parseInt(colorString.substring(0, 2), 16);
            rgb[1] = Integer.parseInt(colorString.substring(2, 4), 16);
            rgb[2] = Integer.parseInt(colorString.substring(4, 6), 16);
        }
        catch (NumberFormatException x) {
            return null;
        }
        return rgb;
    }

    public static String tagName(String html) {
        String tag = html;
        if ('/' == tag.charAt(0)) {
            tag = tag.substring(1);
        } else if ('/' == tag.charAt(tag.length() - 1)) {
            tag = tag.substring(0, tag.length() - 1);
        }
        int index = tag.indexOf(32);
        if (index != -1) {
            tag = tag.substring(0, index);
        }
        return tag;
    }

    public static Map<String, String> parseStyles(String html) {
        Map<String, String> styleMap = Collections.emptyMap();
        String styleString = HTML2TextReader.getAttribute(html, "style");
        if (styleString == null) {
            return styleMap;
        }
        String[] styles = styleString.split(";");
        if (styles.length > 0) {
            styleMap = new HashMap<String, String>();
            String[] stringArray = styles;
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                String style = stringArray[n2];
                String[] nameValue = style.split(":");
                if (nameValue.length == 2) {
                    styleMap.put(nameValue[0].trim(), nameValue[1].trim());
                }
                ++n2;
            }
        }
        return styleMap;
    }

    public static String getAttribute(String html, String attributeName) {
        int endIndex;
        char quoteChar;
        char nextChar;
        String original = html;
        html = original.toLowerCase();
        boolean foundStartOfAttributeName = false;
        int index = 0;
        while (!foundStartOfAttributeName) {
            index = html.indexOf(attributeName);
            if (index < 0 || index + attributeName.length() == html.length()) {
                return null;
            }
            if (index > 0 && !Character.isWhitespace(html.charAt(index - 1))) {
                html = html.substring(index + attributeName.length());
                original = original.substring(index + attributeName.length());
                continue;
            }
            foundStartOfAttributeName = true;
        }
        index += attributeName.length();
        do {
            nextChar = html.charAt(index++);
        } while (index < html.length() && Character.isWhitespace(nextChar));
        if (nextChar != '=') {
            return HTML2TextReader.getAttribute(original.substring(index), attributeName);
        }
        String attributeValue = original.substring(index);
        if (attributeValue.length() == 0) {
            return null;
        }
        index = 0;
        do {
            quoteChar = attributeValue.charAt(index++);
        } while (index < attributeValue.length() && quoteChar != '\"' && quoteChar != '\'');
        if (index < attributeValue.length()) {
            endIndex = attributeValue.indexOf(quoteChar, index);
            if (endIndex <= index) {
                return null;
            }
        } else {
            return null;
        }
        attributeValue = attributeValue.substring(index, endIndex);
        return XMLString.createFromXMLText(attributeValue).getPlainText();
    }

    private String processHTMLTag() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (ch != -1 && ch != 62) {
            buf.append((char)ch);
            ch = this.nextChar();
            if (ch == 34) {
                buf.append((char)ch);
                ch = this.nextChar();
                while (ch != -1 && ch != 34) {
                    buf.append((char)ch);
                    ch = this.nextChar();
                }
            }
            if (ch != 60) continue;
            this.unread(ch);
            return String.valueOf('<') + buf.toString();
        }
        if (ch == -1) {
            return EMPTY_STRING;
        }
        return this.html2Text(buf.toString());
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
        this.fCurrentIndex -= 2;
    }

    @Override
    protected int nextChar() throws IOException {
        int nextChar = super.nextChar();
        ++this.fCurrentIndex;
        return nextChar;
    }

    protected String entity2Text(String symbol) {
        if (symbol.length() > 1 && symbol.charAt(0) == '#') {
            try {
                int ch = symbol.charAt(1) == 'x' ? Integer.parseInt(symbol.substring(2), 16) : Integer.parseInt(symbol.substring(1), 10);
                return EMPTY_STRING + (char)ch;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String str = fgEntityLookup.get(symbol);
            if (str != null) {
                return str;
            }
        }
        return "&" + symbol;
    }

    private String processEntity() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (Character.isLetterOrDigit((char)ch) || ch == 35) {
            buf.append((char)ch);
            ch = this.nextChar();
        }
        if (ch == 59) {
            return this.entity2Text(buf.toString());
        }
        buf.insert(0, '&');
        if (ch != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }

    protected void parse() {
        try {
            this.fHandler.beginDocument();
            this.fBuffer = new StringBuffer();
            int read = this.read();
            while (read > -1) {
                this.fBuffer.append((char)read);
                read = this.read();
            }
            this.flushTextBuffer();
            this.fHandler.endDocument();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void flushTextBuffer() {
        if (this.fBuffer != null && this.fBuffer.length() > 0) {
            this.fHandler.text(this.fBuffer);
            this.fBuffer.setLength(0);
        }
    }

    public static void parse(XMLString content, HTMLHandler handler) {
        new HTML2TextReader(new StringReader(content.getXMLText()), handler).parse();
    }

    public static Reader getHTML2TextReader(Reader reader, HTMLHandler handler) {
        return new HTML2TextReader(reader, handler);
    }
}

