/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.TextLinkDetector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URILinkDetector
extends TextLinkDetector {
    private static final String protocol = "[\\w\\.]";
    private static final String end = "[\\p{L}\\p{Digit}/_=$~\\-*()]";
    private static final String any = "[\\p{L}\\p{Digit}-%=\\./?#&:()|\\{}\\[\\]@+~!$;,_\\^]";
    private static final Pattern PATTERN = Pattern.compile("((([\\w\\.])*://([\\p{L}\\p{Digit}-%=\\./?#&:()|\\{}\\[\\]@+~!$;,_\\^])*([\\p{L}\\p{Digit}/_=$~\\-*()]))|(www\\.([\\p{L}\\p{Digit}-%=\\./?#&:()|\\{}\\[\\]@+~!$;,_\\^])*\\.([\\p{L}\\p{Digit}-%=\\./?#&:()|\\{}\\[\\]@+~!$;,_\\^])*([\\p{L}\\p{Digit}/_=$~\\-*()])))", 66);
    private static final int COMPLETE_URL_GROUP = 2;
    private static final int WWW_URL_GROUP = 6;
    private static final char CLOSING_BRACKET = ')';
    private static final char OPENING_BRACKET = '(';

    @Override
    public DetectedTextLink createDetectedLink(Matcher matcher) {
        String url;
        int length;
        int offset;
        String complete = matcher.group(2);
        if (complete != null) {
            offset = matcher.start(2);
            length = matcher.end(2) - offset;
            url = matcher.group(2);
            if (url == null) {
                return null;
            }
        } else {
            offset = matcher.start(6);
            length = matcher.end(6) - offset;
            url = matcher.group(6);
            if (url == null) {
                return null;
            }
            url = "http://" + url;
        }
        if (url.contains(String.valueOf('(')) || url.contains(String.valueOf(')'))) {
            url = URILinkDetector.matchURLParentheses(url);
            length = url.length();
        }
        return new DetectedURITextLink(offset, length, url);
    }

    @Override
    protected Pattern getPattern() {
        return PATTERN;
    }

    private static String replaceCriticalCharacters(String input) {
        input = input.replace("{", "%7B");
        input = input.replace("}", "%7D");
        input = input.replace("[", "%5B");
        input = input.replace("]", "%5D");
        input = input.replace("^", "%5E");
        input = input.replace("|", "%7C");
        return input;
    }

    public static String matchURLParentheses(String text) {
        int count = 0;
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == '(') {
                ++count;
            } else if (ch == ')') {
                --count;
            }
            ++i;
        }
        if (count < 0) {
            boolean matchEndParentheses = true;
            int i2 = text.length() + count;
            while (i2 < text.length()) {
                if (text.charAt(i2) != ')') {
                    matchEndParentheses = false;
                    break;
                }
                ++i2;
            }
            if (matchEndParentheses) {
                text = text.substring(0, text.length() + count);
            }
        }
        return text;
    }

    public static class DetectedURITextLink
    extends DetectedTextLink {
        private String fURL;

        public DetectedURITextLink(int offset, int length, String url) {
            super(offset, length);
            this.fURL = url;
        }

        @Override
        public List<URI> createURIs() {
            ArrayList<URI> uris = new ArrayList<URI>(1);
            try {
                URI uri;
                try {
                    uri = new URI(this.fURL);
                }
                catch (URISyntaxException x) {
                    uri = new URI(URILinkDetector.replaceCriticalCharacters(this.fURL));
                }
                uris.add(uri);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return uris;
        }

        public String getURL() {
            return this.fURL;
        }
    }
}

