/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common;

import java.net.URI;
import java.util.List;

public abstract class DetectedTextLink {
    private int fOffset;
    private int fLength;
    private boolean fInStructuredLink;
    private int fLinkIndex;

    public DetectedTextLink(int offset, int length) {
        this.fOffset = offset;
        this.fLength = length;
    }

    public URI createURI() {
        List uris = this.createURIs();
        if (uris.size() == 1) {
            return (URI)uris.get(0);
        }
        return null;
    }

    public abstract List createURIs();

    public int getOffset() {
        return this.fOffset;
    }

    protected void setLinkIndex(int index) {
        this.fLinkIndex = index;
    }

    protected int getLinkIndex() {
        return this.fLinkIndex;
    }

    public boolean isInStructuredLink() {
        return this.fInStructuredLink;
    }

    void internalSetInStructuredLink(boolean fInStructredLink) {
        this.fInStructuredLink = fInStructredLink;
    }

    void internalSetOffSet(int offset) {
        this.fOffset = offset;
    }

    void internalSetLength(int length) {
        this.fLength = length;
    }

    public int getLength() {
        return this.fLength;
    }

    public boolean equals(Object obj) {
        DetectedTextLink link;
        return obj instanceof DetectedTextLink && (link = (DetectedTextLink)obj).getLength() == this.getLength() && link.createURI().equals(this.createURI()) && link.getLinkIndex() == this.getLinkIndex();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        URI uri = this.createURI();
        if (uri != null) {
            result = 31 * result + uri.hashCode();
        }
        result = 31 * result + this.fLength;
        result = 31 * result + this.fLinkIndex;
        return result;
    }
}

