/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.reviews.common;

import com.ibm.team.filesystem.reviews.common.ICodeReview;
import com.ibm.team.filesystem.reviews.common.ICodeReviewHandle;
import com.ibm.team.filesystem.reviews.common.ICodeReviewSearchCriteria;
import com.ibm.team.filesystem.reviews.common.IIssue;
import com.ibm.team.filesystem.reviews.common.internal.IssueEvent;
import com.ibm.team.filesystem.reviews.common.internal.VersionableIssueGroup;
import com.ibm.team.filesystem.reviews.common.internal.dto.CodeReviewSaveResult;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IRepositoryProgressMonitorHandle;
import com.ibm.team.scm.common.IScmItemQueryResult;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IConsolidatedChangesReport;
import com.ibm.team.scm.common.dto.IQueryPageDescriptor;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface ICodeReviewService {
    public static final String CODE_REVIEW_MODIFIED_IN_CLOSED_STATE = "modifiedInClosedState";
    public static final String WORKITEM_RESOLUTION_STATE_UNRESOLVED = "com.ibm.team.filesystem.codeReview.workItemResolutionState.unresolved";
    public static final String WORKITEM_RESOLUTION_STATE_RESOLVED = "com.ibm.team.filesystem.codeReview.workItemResolutionState.resolved";
    public static final String WORKITEM_RESOLUTION_STATE_ANY = "com.ibm.team.filesystem.codeReview.workItemResolutionState.any";

    public CodeReviewSaveResult saveReview(ICodeReview var1, IRepositoryProgressMonitorHandle var2) throws TeamRepositoryException;

    public ICodeReview fetchReview(ICodeReviewHandle var1, IRepositoryProgressMonitorHandle var2) throws TeamRepositoryException;

    @Deprecated
    public ICodeReview findReviewByWorkItem(IWorkItemHandle var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public ICodeReview[] findReviewByWorkItems(IWorkItemHandle[] var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public ICodeReview[] findReviewsByWorkItems(IWorkItemHandle[] var1, String var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public IScmItemQueryResult findReviewsByReviewer(IContributorHandle var1, String[] var2, Timestamp var3, IQueryPageDescriptor var4, IRepositoryProgressMonitor var5) throws TeamRepositoryException;

    public IScmItemQueryResult findReviews(ICodeReviewSearchCriteria var1, IQueryPageDescriptor var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult updateReviewWithCollisionCheck(ICodeReview var1, UUID var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult updateReviewWithCollisionCheck2(ICodeReview var1, UUID var2, int var3, IRepositoryProgressMonitor var4) throws TeamRepositoryException;

    public IConsolidatedChangesReport getConsolidatedChangesReports(IChangeSetHandle[] var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public Map<UUID, String> getParentPaths(IWorkspaceHandle var1, IChangeSetHandle[] var2, IConsolidatedChangesReport var3, IRepositoryProgressMonitor var4) throws TeamRepositoryException;

    public VersionableIssueGroup[] createCsFilesFromChangeSets(IChangeSetHandle[] var1, IConsolidatedChangesReport var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public void getLineChangeBlame(UUID var1, IChangeSetHandle[] var2, IConsolidatedChangesReport var3, UUID var4, List<Integer> var5, UUID var6, List<Integer> var7, boolean var8, IRepositoryProgressMonitor var9) throws TeamRepositoryException;

    public void relocateIssueMarkers(ICodeReview var1, IChangeSetHandle[] var2, IChangeSetHandle[] var3, IConsolidatedChangesReport var4, IConsolidatedChangesReport var5, IRepositoryProgressMonitor var6) throws TeamRepositoryException;

    public IVersionableHandle[] getFileVersionableStateHandlesFromChangeSets(IChangeSetHandle[] var1, IConsolidatedChangesReport var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public boolean checkChangeSetsForGaps(IChangeSetHandle[] var1, IConsolidatedChangesReport var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public IChangeSetHandle[] getChangeSetsFromWorkItem(IItemHandle var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public IWorkspaceHandle[] findCommonWorkspacesForChangesets(List<IChangeSet> var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public CodeReviewSaveResult removeIssue(ICodeReviewHandle var1, UUID var2, UUID var3, IRepositoryProgressMonitor var4) throws TeamRepositoryException;

    public CodeReviewSaveResult setTargetStream(IWorkItemHandle var1, IWorkspaceHandle var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public void refreshCodeReview(IWorkItemHandle[] var1, int var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult submitForReview(ICodeReviewHandle var1, String var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult closeReview(ICodeReviewHandle var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public CodeReviewSaveResult reopenCodeReview(ICodeReviewHandle var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public CodeReviewSaveResult startReview(ICodeReviewHandle var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public CodeReviewSaveResult restartReview(ICodeReviewHandle var1, IRepositoryProgressMonitor var2) throws TeamRepositoryException;

    public CodeReviewSaveResult approveReview(ICodeReviewHandle var1, String var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult approveReviewWithCustomDuration(ICodeReviewHandle var1, String var2, int var3, IRepositoryProgressMonitor var4) throws TeamRepositoryException;

    public CodeReviewSaveResult returnReview(ICodeReviewHandle var1, String var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult returnReviewWithCustomDuration(ICodeReviewHandle var1, String var2, int var3, IRepositoryProgressMonitor var4) throws TeamRepositoryException;

    public CodeReviewSaveResult addReviewers(ICodeReviewHandle var1, IContributorHandle[] var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult removeReviewers(ICodeReviewHandle var1, IContributorHandle[] var2, IRepositoryProgressMonitor var3) throws TeamRepositoryException;

    public CodeReviewSaveResult createCodeReview(IWorkItemHandle var1, IWorkspaceHandle var2, IContributorHandle[] var3, boolean var4, String var5, IRepositoryProgressMonitor var6) throws TeamRepositoryException;

    public static interface IAddedComment {
        public int getFileIndex();

        public int getIssueIndex();

        public IssueEvent getComment();
    }

    public static interface IAddedIssue {
        public int getFileIndex();

        public int getIssueIndex();

        public IIssue getIssue();
    }

    public static interface ICodeReviewChange {
    }

    public static interface ICodeReviewUpdateCollision {
    }

    public static interface IIssueCollision
    extends ICodeReviewUpdateCollision {
        public int getFileIndex();

        public int getIssueIndex();

        public boolean isSetSummaryNew();

        public String getSummaryNew();

        public boolean isSetSummaryCur();

        public String getSummaryCur();

        public boolean isSetCategoryNew();

        public String getCategoryNew();

        public boolean isSetCategoryCur();

        public String getCategoryCur();

        public boolean isSetResolutionNew();

        public String getResolutionNew();

        public boolean isSetResolutionCur();

        public String getResolutionCur();

        public boolean isSetTypeNew();

        public String getTypeNew();

        public boolean isSetTypeCur();

        public String getTypeCur();

        public boolean isSetMustFixNew();

        public boolean isMustFixNew();

        public boolean isSetMustFixCur();

        public boolean isMustFixCur();

        public boolean isSetResolvedNew();

        public boolean isResolvedNew();

        public boolean isSetResolvedCur();

        public boolean isResolvedCur();

        public boolean isSetResolvedDateNew();

        public Date getResolvedDateNew();

        public boolean isSetResolvedDateCur();

        public Date getResolvedDateCur();

        public boolean isSetResolvedUserNew();

        public IContributorHandle getResolvedUserNew();

        public boolean isSetResolvedUserCur();

        public IContributorHandle getResolvedUserCur();
    }

    public static interface IMetadataCollision
    extends ICodeReviewUpdateCollision {
    }

    public static interface IUpdatedIssueChange
    extends ICodeReviewChange {
        public int getFileIndex();

        public int getIssueIndex();

        public boolean isSetSummaryAfter();

        public String getSummaryAfter();

        public boolean isSetDescriptionAfter();

        public String getDescriptionAfter();

        public boolean isSetCategoryAfter();

        public String getCategoryAfter();

        public boolean isSetTypeAfter();

        public String getTypeAfter();

        public boolean isSetResolutionAfter();

        public String getResolutionAfter();

        public boolean isSetMustFixAfter();

        public boolean isMustFixAfter();

        public boolean isSetResolvedAfter();

        public boolean isResolvedAfter();

        public boolean isSetResolvedDateAfter();

        public Date getResolvedDateAfter();

        public boolean isSetResolvedUserAfter();

        public IContributorHandle getResolvedUserAfter();
    }

    public static interface IUpdatedMetadataChange
    extends ICodeReviewChange {
        public boolean isUpdated();
    }
}

