/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.reviews.common;

import com.ibm.team.filesystem.reviews.common.ICodeReview;
import com.ibm.team.filesystem.reviews.common.IIssue;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.dto.IConsolidatedChangeInfo;
import com.ibm.team.scm.common.dto.IConsolidatedStateInfo;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;

public class CodeReviewUtil {
    private static final String CODE_REVIEW_PRESENTATION_ID = "com.ibm.team.filesystem.kind.codeReview";
    private static final Log logger = LogFactory.getLog(CodeReviewUtil.class);

    public static Comparator<IIssue> getIssueNumberComparator() {
        return new Comparator<IIssue>(){

            @Override
            public int compare(IIssue object1, IIssue object2) {
                if (object1 == null && object2 == null) {
                    return 0;
                }
                if (object1 == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return object1.getIssueNumber() - object2.getIssueNumber();
            }
        };
    }

    public static boolean categoryEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean issueTypeEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static boolean resolutionEqual(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static String makeCodeReviewUri(String requestUri, ICodeReview cr, IIssue issue) {
        String issueInfo;
        if (issue == null) {
            issueInfo = null;
        } else {
            StringBuilder buf = new StringBuilder();
            if (issue.getVersionable() != null) {
                buf.append("fileId=");
                buf.append(issue.getVersionable().getItemId().getUuidValue());
                buf.append("&");
            }
            buf.append("issueId=");
            buf.append(issue.getIssueId().getUuidValue());
            issueInfo = buf.toString();
        }
        Location reviewLocation = Location.itemLocation((IItemHandle)cr, (String)requestUri, issueInfo, null);
        return reviewLocation.toAbsoluteUri().toASCIIString();
    }

    public static IConsolidatedStateInfo findLastMergeState(IConsolidatedChangeInfo changeInfo) {
        List mergeStates = changeInfo.getMergeStates();
        if (mergeStates != null && !mergeStates.isEmpty() && mergeStates.get(mergeStates.size() - 1) != null) {
            return (IConsolidatedStateInfo)mergeStates.get(mergeStates.size() - 1);
        }
        return null;
    }

    public static class CodeReviewPresentationCache {
        private Map<IProjectAreaHandle, Map<String, Boolean>> codeReviewPresentationCache = new HashMap<IProjectAreaHandle, Map<String, Boolean>>();

        public boolean hasCodeReviewPresentation(IWorkItem workItem, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
            String workItemType;
            Boolean isCodeReviewEnabled;
            IProjectAreaHandle pa = workItem.getProjectArea();
            Map<String, Boolean> workItemTypeMap = this.codeReviewPresentationCache.get(pa);
            if (workItemTypeMap == null) {
                workItemTypeMap = new HashMap<String, Boolean>();
                this.codeReviewPresentationCache.put(pa, workItemTypeMap);
            }
            if ((isCodeReviewEnabled = workItemTypeMap.get(workItemType = workItem.getWorkItemType())) == null) {
                try {
                    isCodeReviewEnabled = workItemCommon.isPresentationInWorkItemType(CodeReviewUtil.CODE_REVIEW_PRESENTATION_ID, pa, workItemType, monitor);
                }
                catch (TeamRepositoryException ex) {
                    logger.error((Object)("Error in checking whether code review is enabled or not for the workitem type '" + workItemType + "' in the project area '" + pa.getItemId().getUuidValue() + "'"), (Throwable)ex);
                    isCodeReviewEnabled = false;
                }
                workItemTypeMap.put(workItemType, isCodeReviewEnabled);
            }
            return isCodeReviewEnabled;
        }
    }
}

