/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.reviews.common;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectArea;
import java.util.ArrayList;
import java.util.List;

public class CodeReviewIssueTagDefinition {
    private final IProjectArea projectArea;
    private final List<CodeReviewIssueTagDefinitionEntry> definitions;

    public CodeReviewIssueTagDefinition(List<CodeReviewIssueTagDefinitionEntry> definitions, IProjectArea projectArea) {
        this.definitions = new ArrayList<CodeReviewIssueTagDefinitionEntry>(definitions);
        this.projectArea = projectArea;
    }

    public List<CodeReviewIssueTagDefinitionEntry> getAllDefinedTags() {
        return this.definitions;
    }

    public IProcessArea getProcessArea() {
        return this.projectArea;
    }

    public static class CodeReviewIssueTagDefinitionEntry {
        private final String itemId;
        private final String name;
        private final String description;

        public CodeReviewIssueTagDefinitionEntry(String name, String description, String itemId) {
            this.name = name;
            this.description = description;
            this.itemId = itemId;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getItemId() {
            return this.itemId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CodeReviewIssueTagDefinitionEntry other = (CodeReviewIssueTagDefinitionEntry)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            return !(this.itemId == null ? other.itemId != null : !this.itemId.equals(other.itemId));
        }
    }
}

