/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.rcp.ui.internal.util;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.operations.MarkAsMergedDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.rcp.ui.internal.Messages;
import com.ibm.team.filesystem.rcp.ui.internal.util.DialogUtil;
import com.ibm.team.filesystem.rcp.ui.internal.util.WarnOutOfSync;
import com.ibm.team.repository.rcp.ui.internal.utils.JFaceUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class WarnResolveAsMergedUser
extends MarkAsMergedDilemmaHandler {
    private boolean confirmCheckin;
    private boolean allowUnmerged = true;
    private final WarnOutOfSync warnOutOfSync;
    private final Shell shell;
    private final String title;

    public WarnResolveAsMergedUser(Shell shell, String title) {
        this.shell = shell;
        this.title = title;
        this.warnOutOfSync = new WarnOutOfSync(shell, title);
    }

    public OutOfSyncDilemmaHandler getOutOfSyncDilemmaHandler() {
        return this.warnOutOfSync;
    }

    public BackupDilemmaHandler getBackupDilemmaHandler() {
        return this.warnOutOfSync.getBackupDilemmaHandler();
    }

    public int uncheckedInChanges(Collection<ILocalChange> changes) {
        if (this.confirmCheckin) {
            final int[] result = new int[]{1};
            if (PlatformUI.isWorkbenchRunning()) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox dialog = new MessageBox(WarnResolveAsMergedUser.this.shell, 65825);
                        dialog.setText(Messages.WarnResolveAsMergedUser_0);
                        dialog.setMessage(Messages.WarnResolveAsMergedUser_1);
                        if (dialog.open() == 32) {
                            result[0] = 0;
                        }
                    }
                });
            }
            return result[0];
        }
        return 0;
    }

    public int unmergedChanges(Collection<ILogicalChange> changes) {
        if (this.allowUnmerged) {
            return 0;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            String message = changes.size() > 1 ? Messages.WarnResolveAsMergedUser_2 : Messages.WarnResolveAsMergedUser_6;
            JFaceUtils.showMessageBlocking((String)Messages.WarnResolveAsMergedUser_3, (String)message, (int)4);
        }
        return 1;
    }

    public int missingRequiredChanges(final Collection<ILogicalChange> requiredChanges) {
        final int[] result = new int[]{1};
        if (PlatformUI.isWorkbenchRunning()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    ListDialog dialog = DialogUtil.createConflictDialog(WarnResolveAsMergedUser.this.shell, requiredChanges, Messages.WarnResolveAsMergedUser_4, Messages.WarnResolveAsMergedUser_5);
                    if (dialog.open() == 0) {
                        result[0] = 0;
                    }
                }
            });
        }
        return result[0];
    }

    public int deletedContent(Collection<IShareable> contentDeleted) {
        return this.warnOutOfSync.deletedContent(contentDeleted);
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean isConfirmCheckin() {
        return this.confirmCheckin;
    }

    public void setConfirmCheckin(boolean confirmCheckin) {
        this.confirmCheckin = confirmCheckin;
    }

    public boolean isAllowUnmerged() {
        return this.allowUnmerged;
    }

    public void setAllowUnmerged(boolean allowUnmerged) {
        this.allowUnmerged = allowUnmerged;
    }

    public int predecessorContentDeletedErrors(Collection<IShareable> failedUploads) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        final ArrayList<IRelativeLocation> input = new ArrayList<IRelativeLocation>();
        final int[] result = new int[]{1};
        for (IShareable share : failedUploads) {
            input.add(share.getLocalPath());
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ListDialog dialog = new ListDialog(WarnResolveAsMergedUser.this.shell){

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 2, Messages.WarnResolveAsMergedUser_checkinButton, false);
                        this.createButton(parent, 3, Messages.WarnResolveAsMergedUser_skipButton, true);
                        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                    }

                    protected void buttonPressed(int buttonId) {
                        super.buttonPressed(buttonId);
                        this.setReturnCode(buttonId);
                        this.close();
                    }
                };
                dialog.setInput((Object)input);
                dialog.setTitle(WarnResolveAsMergedUser.this.title);
                dialog.setMessage(Messages.WarnResolveAsMergedUser_contentDeletedMessage);
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                result[0] = dialog.open();
            }
        });
        if (result[0] == 2) {
            return 0;
        }
        if (result[0] == 3) {
            return 3;
        }
        return 1;
    }

    public int inaccessibleForUpdate(Collection<IShareable> shareables) {
        final int[] result = new int[]{1};
        final ArrayList<IRelativeLocation> input = new ArrayList<IRelativeLocation>();
        Display display = PlatformUI.getWorkbench().getDisplay();
        for (IShareable share : shareables) {
            input.add(share.getLocalPath());
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ListDialog dialog = new ListDialog(WarnResolveAsMergedUser.this.shell){

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
                        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
                    }

                    protected void buttonPressed(int buttonId) {
                        super.buttonPressed(buttonId);
                        this.setReturnCode(buttonId);
                        this.close();
                    }
                };
                dialog.setInput((Object)input);
                dialog.setTitle(WarnResolveAsMergedUser.this.title);
                dialog.setMessage(Messages.WarnResolveAsMergedUser_inaccessibleForUpdateMsg);
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    public int siblingSharesToAdd(Collection<IShareable> shareables) {
        final int[] result = new int[]{1};
        final ArrayList<IRelativeLocation> input = new ArrayList<IRelativeLocation>();
        Display display = PlatformUI.getWorkbench().getDisplay();
        for (IShareable share : shareables) {
            input.add(share.getLocalPath());
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                ListDialog dialog = new ListDialog(WarnResolveAsMergedUser.this.shell){

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
                        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
                    }

                    protected void buttonPressed(int buttonId) {
                        super.buttonPressed(buttonId);
                        this.setReturnCode(buttonId);
                        this.close();
                    }
                };
                dialog.setInput((Object)input);
                dialog.setTitle(WarnResolveAsMergedUser.this.title);
                dialog.setMessage(Messages.WarnResolveAsMergedUser_siblingSharesAddedMsg);
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                result[0] = dialog.open();
            }
        });
        return result[0];
    }
}

